/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import io.georocket.util.CompoundCRSDecoder;
import io.georocket.util.WKTCRSDecoder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoordinateTransformer {
    private final boolean flipped;
    private final MathTransform transform;

    public CoordinateTransformer(CoordinateReferenceSystem crs) throws FactoryException {
        this.flipped = CoordinateTransformer.isFlipped(crs);
        this.transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
    }

    public double[] transform(double[] from, int dimension) throws TransformException {
        if (dimension <= 0) {
            dimension = CoordinateTransformer.guessDimension(from);
        }
        if (dimension != 2 && dimension != 3) {
            return null;
        }
        if (from.length % dimension != 0) {
            return null;
        }
        int count = from.length / dimension;
        for (int i = 0; i < from.length; i += dimension) {
            if (!this.flipped) continue;
            double tmp = from[i];
            from[i] = from[i + 1];
            from[i + 1] = tmp;
        }
        double[] destination = new double[count * 2];
        this.transform.transform(from, 0, destination, 0, count);
        return destination;
    }

    private static int guessDimension(double[] points) {
        if (points.length % 2 == 0) {
            return 2;
        }
        if (points.length % 3 == 0) {
            return 3;
        }
        return -1;
    }

    private static boolean isFlipped(CoordinateReferenceSystem crs) {
        AxisDirection direction;
        return crs.getCoordinateSystem().getDimension() == 2 && ((direction = crs.getCoordinateSystem().getAxis(0).getDirection()).equals((Object)AxisDirection.NORTH) || direction.equals((Object)AxisDirection.UP));
    }

    public static CoordinateReferenceSystem decode(String s) throws FactoryException {
        if (CompoundCRSDecoder.isCompound(s)) {
            return CompoundCRSDecoder.decode(s);
        }
        if (WKTCRSDecoder.isWKT(s)) {
            return WKTCRSDecoder.decode(s);
        }
        return CRS.decode((String)s);
    }
}

