/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import de.undercouch.actson.JsonParser;
import io.georocket.util.JsonStreamEvent;
import io.vertx.core.buffer.Buffer;
import java.util.Iterator;
import rx.Observable;

public class JsonParserTransformer
implements Observable.Transformer<Buffer, JsonStreamEvent> {
    private final JsonParser parser = new JsonParser();

    public Observable<JsonStreamEvent> call(Observable<Buffer> o) {
        return o.flatMap(buf -> Observable.from(() -> new StreamEventIterator((Buffer)buf))).concatWith(Observable.from(() -> {
            this.parser.getFeeder().done();
            return new StreamEventIterator();
        }));
    }

    private class StreamEventIterator
    implements Iterator<JsonStreamEvent> {
        private final byte[] bytes;
        private int pos = 0;
        private int nextEvent = 0;
        private boolean eof = false;

        public StreamEventIterator() {
            this.bytes = null;
        }

        public StreamEventIterator(Buffer buf) {
            this.bytes = buf.getBytes();
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            this.nextEvent = JsonParserTransformer.this.parser.nextEvent();
            while (this.nextEvent == 0) {
                if (this.bytes == null || this.pos >= this.bytes.length) {
                    return false;
                }
                this.pos += JsonParserTransformer.this.parser.getFeeder().feed(this.bytes, this.pos, this.bytes.length - this.pos);
                this.nextEvent = JsonParserTransformer.this.parser.nextEvent();
            }
            if (this.nextEvent == 99) {
                this.eof = true;
            }
            return true;
        }

        @Override
        public JsonStreamEvent next() {
            if (this.nextEvent == 0) {
                throw new IllegalStateException("Not enough input data to parse JSON file");
            }
            if (this.nextEvent == 99) {
                return new JsonStreamEvent(this.nextEvent, JsonParserTransformer.this.parser.getParsedCharacterCount());
            }
            if (this.nextEvent == -1) {
                throw new IllegalStateException("Syntax error");
            }
            Object value = null;
            if (this.nextEvent == 6 || this.nextEvent == 5) {
                value = JsonParserTransformer.this.parser.getCurrentString();
            } else if (this.nextEvent == 8) {
                value = JsonParserTransformer.this.parser.getCurrentDouble();
            } else if (this.nextEvent == 7) {
                value = JsonParserTransformer.this.parser.getCurrentInt();
            }
            return new JsonStreamEvent(this.nextEvent, JsonParserTransformer.this.parser.getParsedCharacterCount(), value);
        }
    }
}

