/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathUtils {
    public static String join(String ... paths) {
        String joined = Stream.of(paths).filter(p -> p != null && !p.isEmpty()).collect(Collectors.joining("/"));
        return PathUtils.normalize(joined);
    }

    public static String normalize(String path) {
        try {
            String result = new URI(path).normalize().toString();
            if (result.startsWith("//")) {
                result = result.substring(1);
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal path", e);
        }
    }

    public static boolean isAbsolute(String path) {
        return path != null && !path.isEmpty() && path.charAt(0) == '/';
    }

    public static String removeLeadingSlash(String path) {
        if (path != null && !path.isEmpty() && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public static String addLeadingSlash(String path) {
        if (path == null) {
            return null;
        }
        if (!path.isEmpty() && path.charAt(0) == '/') {
            return path;
        }
        return "/" + path;
    }

    public static String addTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        if (!path.isEmpty() && path.charAt(path.length() - 1) == '/') {
            return path;
        }
        return path + "/";
    }
}

