/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import io.vertx.core.logging.Logger;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.functions.Func1;

public final class RxUtils {
    private RxUtils() {
    }

    public static Func1<Observable<? extends Throwable>, Observable<Long>> makeRetry(int retries, int interval) {
        return RxUtils.makeRetry(retries, interval, null);
    }

    public static Func1<Observable<? extends Throwable>, Observable<Long>> makeRetry(int retries, int interval, Logger log) {
        return attempts -> attempts.zipWith(Observable.range((int)1, (int)(retries + 1)), (n, i) -> Pair.of((Object)n, (Object)i)).flatMap(t -> {
            if ((Integer)t.getValue() > retries) {
                return Observable.error((Throwable)((Throwable)t.getKey()));
            }
            if (log != null) {
                log.warn((Object)"Operation failed", (Throwable)t.getKey());
                log.info((Object)("Retry " + t.getValue() + " in " + interval + " milliseconds"));
            }
            return Observable.timer((long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
        });
    }
}

