/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class SizeFormat {
    private static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB"};
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,##0.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public static String format(long size) {
        if (size <= 0L) {
            return "0 B";
        }
        int d = (int)(Math.log10(size) / 3.0);
        return FORMATTER.format((double)size / Math.pow(1000.0, d)) + " " + UNITS[d];
    }
}

