/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;

public class StringWindow {
    private final int DEFAULT_CHAR_BUFFER_SIZE = 2048;
    private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private CharBuffer charBuf = CharBuffer.allocate(2048);
    private Buffer buf = Buffer.buffer();
    private StringBuilder decodedBuf = new StringBuilder();
    private int pos = 0;

    private void ensureCharBuffer(int length) {
        int maxLength = (int)((double)length * (double)this.decoder.maxCharsPerByte());
        if (maxLength > this.charBuf.length()) {
            this.charBuf = CharBuffer.allocate(maxLength);
        }
    }

    public void append(Buffer buf) {
        if (this.buf.length() > 0) {
            this.buf.appendBuffer(buf);
        } else {
            this.buf = buf;
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(this.buf.getBytes());
        this.ensureCharBuffer(buf.length());
        this.charBuf.position(0);
        this.charBuf.limit(this.charBuf.capacity());
        CoderResult result = this.decoder.decode(byteBuf, this.charBuf, false);
        if (result.isMalformed()) {
            throw new IllegalStateException(new MalformedInputException(result.length()));
        }
        if (result.isUnmappable()) {
            throw new IllegalStateException(new UnmappableCharacterException(result.length()));
        }
        this.charBuf.flip();
        this.buf = this.buf.getBuffer(byteBuf.position(), this.buf.length());
        this.decodedBuf.append(this.charBuf);
    }

    public String getChars(int startCharacter, int endCharacter) {
        return this.decodedBuf.substring(startCharacter - this.pos, endCharacter - this.pos);
    }

    public void advanceTo(int pos) {
        this.decodedBuf = this.decodedBuf.delete(0, pos - this.pos);
        this.pos = pos;
    }
}

