/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WKTCRSDecoder {
    private static final String[] TYPES = new String[]{"COMPD_CS", "FITTED_CS", "GEOCCS", "GEOGCS", "LOCAL_CS", "PROJCS", "VERT_CS"};

    public static boolean isWKT(String code) {
        code = code.trim();
        for (String type : TYPES) {
            if (!code.startsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static CoordinateReferenceSystem decode(String wkt) throws FactoryException {
        return CRS.parseWKT((String)wkt.trim());
    }
}

