/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import com.fasterxml.aalto.AsyncByteArrayFeeder;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import io.georocket.util.XMLStreamEvent;
import io.vertx.core.buffer.Buffer;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import rx.Observable;

public class XMLParserTransformer
implements Observable.Transformer<Buffer, XMLStreamEvent> {
    private AsyncXMLStreamReader<AsyncByteArrayFeeder> parser = new InputFactoryImpl().createAsyncForByteArray();

    public Observable<XMLStreamEvent> call(Observable<Buffer> o) {
        return o.flatMap(buf -> Observable.from(() -> new StreamEventIterator((Buffer)buf))).concatWith(Observable.from(() -> {
            ((AsyncByteArrayFeeder)this.parser.getInputFeeder()).endOfInput();
            return new StreamEventIterator();
        }));
    }

    private class StreamEventIterator
    implements Iterator<XMLStreamEvent> {
        private XMLStreamEvent nextEvent = null;

        public StreamEventIterator() {
        }

        public StreamEventIterator(Buffer buf) {
            byte[] bytes = buf.getBytes();
            try {
                ((AsyncByteArrayFeeder)XMLParserTransformer.this.parser.getInputFeeder()).feedInput(bytes, 0, bytes.length);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Could not feed input", e);
            }
        }

        @Override
        public boolean hasNext() {
            int event;
            try {
                event = XMLParserTransformer.this.parser.next();
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Could not parse input", e);
            }
            if (event == 257) {
                return false;
            }
            if (event == 8) {
                try {
                    XMLParserTransformer.this.parser.close();
                    return false;
                }
                catch (XMLStreamException e) {
                    throw new IllegalStateException("Could not close input", e);
                }
            }
            int pos = XMLParserTransformer.this.parser.getLocation().getCharacterOffset();
            this.nextEvent = new XMLStreamEvent(event, pos, (XMLStreamReader)XMLParserTransformer.this.parser);
            return true;
        }

        @Override
        public XMLStreamEvent next() {
            return this.nextEvent;
        }
    }
}

