/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util.io;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;

public class BufferReadStream
implements ReadStream<Buffer> {
    private Buffer buf;
    private boolean paused;
    private Handler<Buffer> handler;
    private Handler<Void> endHandler;

    public BufferReadStream(Buffer buf) {
        this.buf = buf;
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    private void doWrite(Handler<Buffer> handler) {
        handler.handle((Object)this.buf);
        this.buf = null;
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        if (this.paused) {
            this.handler = handler;
        } else {
            this.doWrite(handler);
        }
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.paused = true;
        return this;
    }

    public ReadStream<Buffer> resume() {
        if (this.paused) {
            this.paused = false;
            if (this.handler != null) {
                Handler<Buffer> h = this.handler;
                this.handler = null;
                this.doWrite(h);
            }
        }
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        if (this.buf == null) {
            endHandler.handle(null);
        } else {
            this.endHandler = endHandler;
        }
        return this;
    }
}

