/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util.io;

import io.georocket.util.io.DelegateReadStream;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.lang3.tuple.Pair;

public class GzipReadStream
extends DelegateReadStream<Buffer> {
    private static final Logger log = LoggerFactory.getLogger(GzipReadStream.class);
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private final Inflater inflater = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final byte[] buf = new byte[512];
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private boolean headerRead;
    private Buffer headerBuffer;
    private Buffer trailerBuffer;

    public GzipReadStream(ReadStream<Buffer> delegate) {
        super(delegate);
    }

    public GzipReadStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        this.delegate.exceptionHandler(handler);
        return this;
    }

    private void handleException(Throwable t) {
        if (this.exceptionHandler != null && t instanceof Exception) {
            this.exceptionHandler.handle((Object)t);
        } else {
            log.error((Object)"Unhandled exception", t);
        }
    }

    public GzipReadStream handler(Handler<Buffer> handler) {
        if (handler == null) {
            this.delegate.handler(null);
            return this;
        }
        this.delegate.handler(data -> {
            int start = 0;
            if (!this.headerRead) {
                int headerSize;
                if (this.headerBuffer != null) {
                    this.headerBuffer.appendBuffer(data);
                    data = this.headerBuffer;
                }
                if ((headerSize = this.tryParseHeader((Buffer)data)) > 0) {
                    this.headerRead = true;
                    start = headerSize;
                    this.headerBuffer = null;
                } else {
                    if (this.headerBuffer == null) {
                        this.headerBuffer = Buffer.buffer();
                        this.headerBuffer.appendBuffer(data);
                    }
                    return;
                }
            }
            int finalStart = start;
            Buffer finalData = data;
            Vertx.currentContext().executeBlocking(f -> {
                if (this.inflater.finished()) {
                    f.complete((Object)Pair.of(null, (Object)finalData));
                    return;
                }
                byte[] currentData = finalData.getBytes(finalStart, finalData.length());
                try {
                    Buffer r = null;
                    Buffer remainingBytes = null;
                    while (true) {
                        int n;
                        if ((n = this.inflater.inflate(this.buf, 0, this.buf.length)) == 0) {
                            if (this.inflater.finished() || this.inflater.needsDictionary()) {
                                int remaining = this.inflater.getRemaining();
                                if (remaining > 0) {
                                    remainingBytes = finalData.getBuffer(finalData.length() - remaining, finalData.length());
                                }
                            } else {
                                if (!this.inflater.needsInput()) continue;
                                if (currentData != null) {
                                    this.inflater.setInput(currentData, 0, currentData.length);
                                    currentData = null;
                                    continue;
                                }
                            }
                        }
                        if (n == 0) break;
                        this.crc.update(this.buf, 0, n);
                        if (r == null) {
                            r = Buffer.buffer();
                        }
                        r.appendBytes(this.buf, 0, n);
                    }
                    f.complete((Object)Pair.of(r, remainingBytes));
                }
                catch (DataFormatException e) {
                    f.fail((Throwable)e);
                }
            }, ar -> {
                if (ar.failed()) {
                    this.handleException(ar.cause());
                    return;
                }
                Pair r = (Pair)ar.result();
                Buffer b = (Buffer)r.getLeft();
                if (b != null && b.length() > 0) {
                    handler.handle((Object)b);
                }
                if (r.getRight() != null) {
                    if (this.trailerBuffer != null) {
                        this.trailerBuffer.appendBuffer((Buffer)r.getRight());
                    } else {
                        this.trailerBuffer = (Buffer)r.getRight();
                    }
                }
                if (this.trailerBuffer != null) {
                    this.tryParseTrailer();
                }
            });
        });
        return this;
    }

    private int tryParseHeader(Buffer buf) {
        if (buf.length() < 10) {
            return 0;
        }
        if (buf.getUnsignedShortLE(0) != 35615) {
            this.handleException(new ZipException("Not in GZIP format"));
            return 0;
        }
        if (buf.getByte(2) != 8) {
            this.handleException(new ZipException("Unsupported compression method"));
            return 0;
        }
        byte flg = buf.getByte(3);
        int n = 10;
        if ((flg & 4) == 4) {
            if (buf.length() < n + 2) {
                return 0;
            }
            int m = buf.getUnsignedShortLE(n);
            n += m + 2;
        }
        if ((flg & 8) == 8) {
            do {
                if (buf.length() > n) continue;
                return 0;
            } while (buf.getByte(++n - 1) != 0);
        }
        if ((flg & 0x10) == 16) {
            do {
                if (buf.length() > n) continue;
                return 0;
            } while (buf.getByte(++n - 1) != 0);
        }
        if ((flg & 2) == 2) {
            if (buf.length() < n + 2) {
                return 0;
            }
            this.crc.reset();
            this.crc.update(buf.getBytes(0, n));
            int v = (int)this.crc.getValue() & 0xFFFF;
            if (buf.getUnsignedShortLE(n) != v) {
                this.handleException(new ZipException("Corrupt GZIP header"));
                return 0;
            }
            n += 2;
            this.crc.reset();
        }
        return n;
    }

    private void tryParseTrailer() {
        if (this.trailerBuffer.length() < 8) {
            return;
        }
        long v = this.trailerBuffer.getUnsignedIntLE(0);
        long bytesWritten = this.trailerBuffer.getUnsignedIntLE(4);
        if (v != this.crc.getValue() || bytesWritten != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
            this.handleException(new ZipException("Corrupt GZIP trailer"));
            return;
        }
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    public GzipReadStream endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }
}

