/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util.io;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamReadStream
implements ReadStream<Buffer> {
    private static Logger log = LoggerFactory.getLogger(InputStreamReadStream.class);
    private static final int READ_BUFFER_SIZE = 8192;
    private final InputStream is;
    private final Vertx vertx;
    private boolean readInProgress;
    private boolean paused;
    private boolean closed;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;

    public InputStreamReadStream(InputStream is, Vertx vertx) {
        this.is = is;
        this.vertx = vertx;
    }

    private void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)t);
        } else {
            log.error((Object)"Unhandled exception", t);
        }
    }

    private synchronized void handleData(Buffer buffer) {
        if (this.dataHandler != null) {
            this.dataHandler.handle((Object)buffer);
        }
    }

    private synchronized void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void doRead() {
        if (!this.readInProgress) {
            this.readInProgress = true;
            this.vertx.executeBlocking(f -> {
                Buffer r;
                int read;
                byte[] buf = new byte[8192];
                try {
                    InputStreamReadStream inputStreamReadStream = this;
                    synchronized (inputStreamReadStream) {
                        read = this.is.read(buf, 0, 8192);
                    }
                }
                catch (IOException e) {
                    f.fail((Throwable)e);
                    return;
                }
                if (read < 0) {
                    r = Buffer.buffer();
                } else if (read < 8192) {
                    r = Buffer.buffer((int)read);
                    r.setBytes(0, buf, 0, read);
                } else {
                    r = Buffer.buffer((byte[])buf);
                }
                f.complete((Object)r);
            }, ar -> {
                if (ar.failed()) {
                    this.handleException(ar.cause());
                } else {
                    this.readInProgress = false;
                    Buffer buffer = (Buffer)ar.result();
                    if (buffer.length() == 0) {
                        this.handleEnd();
                    } else {
                        this.handleData(buffer);
                        if (!this.paused && this.dataHandler != null) {
                            this.doRead();
                        }
                    }
                }
            });
        }
    }

    public InputStreamReadStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        if (this.dataHandler != null && !this.paused && !this.closed) {
            this.doRead();
        }
        return this;
    }

    public InputStreamReadStream pause() {
        this.paused = true;
        return this;
    }

    public InputStreamReadStream resume() {
        if (this.paused && !this.closed) {
            this.paused = false;
            if (this.dataHandler != null) {
                this.doRead();
            }
        }
        return this;
    }

    public InputStreamReadStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        if (handler == null) {
            handler = ar -> {
                if (ar.failed()) {
                    this.handleException(ar.cause());
                }
            };
        }
        this.closed = true;
        this.vertx.executeBlocking(f -> {
            try {
                InputStreamReadStream inputStreamReadStream = this;
                synchronized (inputStreamReadStream) {
                    this.is.close();
                }
            }
            catch (IOException e) {
                f.fail((Throwable)e);
                return;
            }
            f.complete();
        }, handler);
    }
}

