/*
 * Decompiled with CFR 0.152.
 */
package coursier.cputil;

import coursier.cputil.ClassPathUtil$CustomStringOps$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.SystemProperties;

public final class ClassPathUtil$
implements Serializable {
    private static final ClassPathUtil$CustomStringOps$ CustomStringOps;
    private static final Pattern propertyRegex;
    private static final Seq<String> allJarsSuffixes;
    public static final ClassPathUtil$ MODULE$;

    private ClassPathUtil$() {
    }

    static {
        MODULE$ = new ClassPathUtil$();
        propertyRegex = Pattern.compile(new StringBuilder(4).append(Pattern.quote("${")).append("[^").append(Pattern.quote("{[()]}")).append("]*").append(Pattern.quote("}")).toString());
        allJarsSuffixes = (Seq)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/", File.separator})).distinct()).flatMap((Function1 & Serializable)sep -> (IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"*", "*.jar"})).map((Function1 & Serializable)_$3 -> new StringBuilder(0).append((String)sep).append((String)_$3).toString()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClassPathUtil$.class);
    }

    private final String CustomStringOps(String str) {
        return str;
    }

    public Seq<Path> classPath(String input) {
        SystemProperties systemProperties = scala.sys.package$.MODULE$.props();
        return this.classPath(input, (Function1<String, Option<String>>)(Function1 & Serializable)key -> systemProperties.get(key));
    }

    public String substituteProperties(String input, Function1<String, Option<String>> getProperty) {
        String value = input;
        Matcher matcher = null;
        while ((matcher = propertyRegex.matcher(value)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            String subKey = value.substring(start + 2, end - 1);
            String subValue = (String)((Option)getProperty.apply((Object)subKey)).getOrElse(this::$anonfun$1);
            value = new StringBuilder(0).append(value.substring(0, start)).append(subValue).append(value.substring(end)).toString();
        }
        return value;
    }

    private Seq<Path> allJarsOf(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(dir).iterator()).asScala()).filter((Function1 & Serializable)_$1 -> ClassPathUtil$CustomStringOps$.MODULE$.endsWithIgnoreCase$extension(this.CustomStringOps(_$1.toString()), ".jar")).toVector().sortBy((Function1 & Serializable)_$2 -> _$2.getFileName(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        return package$.MODULE$.Nil();
    }

    public Seq<Path> classPath(String input, Function1<String, Option<String>> getProperty) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.substituteProperties(input, getProperty).split(File.pathSeparator));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4))));
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)elem -> {
            String string = this.CustomStringOps((String)elem);
            Option option = allJarsSuffixes.find((Function1 & Serializable)suffix -> ClassPathUtil$CustomStringOps$.MODULE$.endsWithIgnoreCase$extension(string, (String)suffix));
            if (option instanceof Some) {
                String suffix2 = (String)((Some)option).value();
                Path dir = Paths.get(elem.substring(0, elem.length() - suffix2.length()), new String[0]);
                return this.allJarsOf(dir);
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{Paths.get(elem, new String[0])}));
            }
            throw new MatchError((Object)option);
        }, ClassTag$.MODULE$.apply(Path.class)));
    }

    private final String $anonfun$1() {
        return "";
    }
}

