/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$Ar$;
import coursier.cache.ArchiveType$Gzip$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArchiveType$Tbz2$;
import coursier.cache.ArchiveType$Tgz$;
import coursier.cache.ArchiveType$Txz$;
import coursier.cache.ArchiveType$Tzst$;
import coursier.cache.ArchiveType$Xz$;
import coursier.cache.ArchiveType$Zip$;
import coursier.cache.Cache;
import coursier.cache.CacheDefaults$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.util.Sync;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class ArchiveCache$
implements Serializable {
    public static final ArchiveCache$ MODULE$ = new ArchiveCache$();

    public <F> ArchiveCache<F> apply(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.archiveCacheLocation(), S);
    }

    public <F> ArchiveCache<F> priviledged(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.priviledgedArchiveCacheLocation(), S).withUnArchiver(UnArchiver$.MODULE$.priviledged());
    }

    public <F> Sync<Task> priviledged$default$1() {
        return Task$.MODULE$.sync();
    }

    public void coursier$cache$ArchiveCache$$deleteRecursive(File f2) {
        if (f2.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])f2.listFiles()), (Function1 & Serializable)f -> {
                ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(f);
                return BoxedUnit.UNIT;
            });
        }
        f2.delete();
    }

    public Option<ArchiveType> coursier$cache$ArchiveCache$$archiveType(String url) {
        if (url.endsWith(".tar")) {
            return new Some((Object)ArchiveType$Tar$.MODULE$);
        }
        if (url.endsWith(".tar.gz") || url.endsWith(".tgz") || url.endsWith(".apk")) {
            return new Some((Object)ArchiveType$Tgz$.MODULE$);
        }
        if (url.endsWith(".tar.bz2") || url.endsWith(".tbz2")) {
            return new Some((Object)ArchiveType$Tbz2$.MODULE$);
        }
        if (url.endsWith(".tar.xz") || url.endsWith(".txz")) {
            return new Some((Object)ArchiveType$Txz$.MODULE$);
        }
        if (url.endsWith(".tar.zst") || url.endsWith(".tzst")) {
            return new Some((Object)ArchiveType$Tzst$.MODULE$);
        }
        if (url.endsWith(".zip") || url.endsWith(".jar")) {
            return new Some((Object)ArchiveType$Zip$.MODULE$);
        }
        if (url.endsWith(".ar") || url.endsWith(".deb")) {
            return new Some((Object)ArchiveType$Ar$.MODULE$);
        }
        if (url.endsWith(".gz")) {
            return new Some((Object)ArchiveType$Gzip$.MODULE$);
        }
        if (url.endsWith(".xz")) {
            return new Some((Object)ArchiveType$Xz$.MODULE$);
        }
        return None$.MODULE$;
    }

    public <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return new ArchiveCache<F>(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, (Option<Object>)None$.MODULE$, sync);
    }

    public <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return new ArchiveCache<F>(location, cache, unArchiver, (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, (Option<Object>)None$.MODULE$, sync);
    }

    public <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Option<File> shortPathDirectory, Option<Object> integrityCheck, Sync<F> sync) {
        return new ArchiveCache<F>(location, cache, unArchiver, openStream, shortPathDirectory, integrityCheck, sync);
    }

    public <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArchiveCache$.class);
    }

    private ArchiveCache$() {
    }
}

