/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$;
import coursier.cache.ArchiveType$Gzip$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArchiveType$Tgz$;
import coursier.cache.ArchiveType$Zip$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.EitherT;
import coursier.util.EitherT$;
import coursier.util.Monad;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tika.Tika;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\r\rb\u0001\u0002\u001c8\u0005qB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005+\"A\u0001\b\u0001BC\u0002\u0013\u0005a\f\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!Q1A\u0005\u0002eD\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u0015\u0001A!b\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\n\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003?\u0001!Q1A\u0005\u0004\u0005\u0005\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002$!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u0019\u0001\u0011\u0005\u0011q\t\u0005\b\u0003c\u0001A\u0011AA*\u0011\u001d\tY\u0006\u0001C\u0005\u0003CAq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\u001c\"A\u00111\u0015\u0001\u0005\u0002]\n)\u000bC\u0004\u0002:\u0002!I!a/\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\ti\u000e\u0001C\u0001\u0003?Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011Q\u001f\u0001\u0005B\u0005]\bb\u0002B\u0002\u0001\u0011\u0005#Q\u0001\u0005\b\u0005\u0017\u0001A\u0011\tB\u0007\u0011\u001d\u0011\t\u0002\u0001C!\u0005'AqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u0003&\u0001!\tEa\n\t\u000f\t%\u0002\u0001\"\u0011\u0003,!9!Q\u0006\u0001\u0005B\t=\u0002b\u0002B\u001b\u0001\u0011\u0005#qG\u0004\b\u0005w9\u0004\u0012\u0001B\u001f\r\u00191t\u0007#\u0001\u0003@!9\u0011\u0011\u0007\u0016\u0005\u0002\t\u0015\u0003b\u0002B$U\u0011\u0005!\u0011\n\u0005\n\u0005?R\u0013\u0013!C\u0001\u0005CBqAa\"+\t\u0003\u0011I\tC\u0005\u0003 *\n\n\u0011\"\u0001\u0003\"\"9!\u0011\u0016\u0016\u0005\n\t-\u0006b\u0002B\\U\u0011%!\u0011\u0018\u0005\b\u0005\u000fRC\u0011\u0001Bc\u0011\u001d\u00119E\u000bC\u0001\u00057DqAa\u0012+\t\u0003\u00119\u0010C\u0005\u0004\u001a)\n\t\u0011\"\u0003\u0004\u001c\ta\u0011I]2iSZ,7)Y2iK*\u0011\u0001(O\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005A1m\\;sg&,'o\u0001\u0001\u0016\u0005u*7\u0003\u0002\u0001?\t\u001e\u0003\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0007CA F\u0013\t1\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005!\u0003fBA%O\u001d\tQU*D\u0001L\u0015\ta5(\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011q\nQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002P\u0001\u0006AAn\\2bi&|g.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0002j_*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u00111\u0015\u000e\\3\u0002\u00131|7-\u0019;j_:\u0004S#A0\u0011\u0007\u0001\f7-D\u00018\u0013\t\u0011wGA\u0003DC\u000eDW\r\u0005\u0002eK2\u0001A!\u00024\u0001\u0005\u00049'!\u0001$\u0016\u0005!|\u0017CA5m!\ty$.\u0003\u0002l\u0001\n9aj\u001c;iS:<\u0007CA n\u0013\tq\u0007IA\u0002B]f$Q\u0001]3C\u0002!\u0014Aa\u0018\u0013%c\u000511-Y2iK\u0002\n!\"\u001e8Be\u000eD\u0017N^3s+\u0005!\bC\u00011v\u0013\t1xG\u0001\u0006V]\u0006\u00138\r[5wKJ\f1\"\u001e8Be\u000eD\u0017N^3sA\u0005Qq\u000e]3o'R\u0014X-Y7\u0016\u0003i\u0004\"a\u001f@\u000f\u0005\u0001d\u0018BA?8\u0003))f.\u0011:dQ&4XM]\u0005\u0004\u007f\u0006\u0005!AC(qK:\u001cFO]3b[*\u0011QpN\u0001\f_B,gn\u0015;sK\u0006l\u0007%\u0001\ntQ>\u0014H\u000fU1uQ\u0012K'/Z2u_JLXCAA\u0005!\u0011y\u00141B+\n\u0007\u00055\u0001I\u0001\u0004PaRLwN\\\u0001\u0014g\"|'\u000f\u001e)bi\"$\u0015N]3di>\u0014\u0018\u0010I\u0001\u000fS:$Xm\u001a:jif\u001c\u0005.Z2l+\t\t)\u0002E\u0003@\u0003\u0017\t9\u0002E\u0002@\u00033I1!a\u0007A\u0005\u001d\u0011un\u001c7fC:\fq\"\u001b8uK\u001e\u0014\u0018\u000e^=DQ\u0016\u001c7\u000eI\u0001\u0005gft7-\u0006\u0002\u0002$A)\u0011QEA\u0016G6\u0011\u0011q\u0005\u0006\u0004\u0003SI\u0014\u0001B;uS2LA!!\f\u0002(\t!1+\u001f8d\u0003\u0015\u0019\u0018P\\2!\u0003\u0019a\u0014N\\5u}Qq\u0011QGA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015C\u0003BA\u001c\u0003s\u00012\u0001\u0019\u0001d\u0011\u001d\tyb\u0004a\u0002\u0003GAQaU\bA\u0002UCQ\u0001O\bA\u0002}CQA]\bA\u0002QDQ\u0001_\bA\u0002iDq!!\u0002\u0010\u0001\u0004\tI\u0001C\u0004\u0002\u0012=\u0001\r!!\u0006\u0015\u0011\u0005%\u0013QJA(\u0003#\"B!a\u000e\u0002L!9\u0011q\u0004\tA\u0004\u0005\r\u0002\"B*\u0011\u0001\u0004)\u0006\"\u0002\u001d\u0011\u0001\u0004y\u0006\"\u0002:\u0011\u0001\u0004!H\u0003BA+\u00033\"B!a\u000e\u0002X!9\u0011qD\tA\u0004\u0005\r\u0002\"B*\u0012\u0001\u0004)\u0016!A*\u0002\u00111|7-\u00197ESJ$B!!\u0019\u0002~A1q(a\u0019V\u0003OJ1!!\u001aA\u0005\u0019!V\u000f\u001d7feA)\u0001*!\u001b\u0002n%\u0019\u00111\u000e*\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002p\u0005]d\u0002BA9\u0003g\u0002\"A\u0013!\n\u0007\u0005U\u0004)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\nYH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k\u0002\u0005bBA@'\u0001\u0007\u0011\u0011Q\u0001\tCJ$\u0018NZ1diB!\u0011QEAB\u0013\u0011\t))a\n\u0003\u0011\u0005\u0013H/\u001b4bGR\f1bZ3u\u0013\u001a,\u00050[:ugR!\u00111RAM!\u0011!W-!$\u0011\u000f!\u000by)a%\u0002\n%\u0019\u0011\u0011\u0013*\u0003\r\u0015KG\u000f[3s!\r\u0001\u0017QS\u0005\u0004\u0003/;$!D!si&4\u0017m\u0019;FeJ|'\u000fC\u0004\u0002\u0000Q\u0001\r!!!\u0015\r\u0005-\u0015QTAP\u0011\u001d\ty(\u0006a\u0001\u0003\u0003Cq!!)\u0016\u0001\u0004\t9\"\u0001\u0007jgNKgn\u001a7f\r&dW-\u0001\u0003hKR\u0004D\u0003CAT\u0003W\u000by+!.\u0011\t\u0011,\u0017\u0011\u0016\t\u0007\u0011\u0006=\u00151S+\t\r\u00055f\u00031\u0001V\u0003\r!\u0017N\u001d\u0005\b\u0003c3\u0002\u0019AAZ\u0003\u0019)(\u000f\\(qiB)q(a\u0003\u0002n!9\u0011q\u0017\fA\u0002\u0005\u001d\u0016\u0001\u00033po:dw.\u00193\u0002\u001f%tG/Z4sSRL8\t[3dWB\"b!!\u0006\u0002>\u0006\u0005\u0007bBA`/\u0001\u0007\u0011QN\u0001\u0004kJd\u0007BBAb/\u0001\u0007Q+\u0001\u0003gS2,\u0017aA4fiR!\u0011qUAe\u0011\u001d\ty\b\u0007a\u0001\u0003\u0003\u000bAb^5uQ2{7-\u0019;j_:$B!a\u000e\u0002P\")1+\u0007a\u0001+\u0006Iq/\u001b;i\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003o\t)\u000eC\u000395\u0001\u0007q,\u0001\bxSRDWK\\!sG\"Lg/\u001a:\u0015\t\u0005]\u00121\u001c\u0005\u0006en\u0001\r\u0001^\u0001\u000fo&$\bn\u00149f]N#(/Z1n)\u0011\t9$!9\t\u000bad\u0002\u0019\u0001>\u0002-]LG\u000f[*i_J$\b+\u0019;i\t&\u0014Xm\u0019;pef$B!a\u000e\u0002h\"9\u0011QA\u000fA\u0002\u0005%\u0011AE<ji\"Le\u000e^3he&$\u0018p\u00115fG.$B!a\u000e\u0002n\"9\u0011\u0011\u0003\u0010A\u0002\u0005U\u0011\u0001C<ji\"\u001c\u0016P\\2\u0015\t\u0005]\u00121\u001f\u0005\b\u0003?y\u0002\u0019AA\u0012\u0003!!xn\u0015;sS:<GCAA}!\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u00003\u0006!A.\u00198h\u0013\u0011\tI(!@\u0002\u0011\r\fg.R9vC2$B!a\u0006\u0003\b!1!\u0011B\u0011A\u00021\f1a\u001c2k\u0003\u0019)\u0017/^1mgR!\u0011q\u0003B\b\u0011\u0019\u0011IA\ta\u0001Y\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0016A\u0019qHa\u0006\n\u0007\te\u0001IA\u0002J]R\fQ\u0001^;qY\u0016,\"Aa\b\u0011\u001b}\u0012\t#V0uu\u0006%\u0011QCA\u0012\u0013\r\u0011\u0019\u0003\u0011\u0002\u0007)V\u0004H.Z\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\u0016\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00017\u00032!9!1G\u0014A\u0002\tU\u0011!\u00018\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003s\u0014I\u0004C\u0004\u00034!\u0002\rA!\u0006\u0002\u0019\u0005\u00138\r[5wK\u000e\u000b7\r[3\u0011\u0005\u0001T3\u0003\u0002\u0016?\u0005\u0003\u00022A\u0016B\"\u0013\t\tv\u000b\u0006\u0002\u0003>\u0005)\u0011\r\u001d9msV!!1\nB*)\t\u0011i\u0005\u0006\u0003\u0003P\tm\u0003\u0003\u00021\u0001\u0005#\u00022\u0001\u001aB*\t\u00191GF1\u0001\u0003VU\u0019\u0001Na\u0016\u0005\u000f\te#1\u000bb\u0001Q\n!q\f\n\u00133\u0011%\tY\u0006\fI\u0001\u0002\b\u0011i\u0006\u0005\u0004\u0002&\u0005-\"\u0011K\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!1\rBA)\t\u0011)G\u000b\u0003\u0003h\t=\u0004CBA\u0013\u0003W\u0011I\u0007\u0005\u0003\u0002&\t-\u0014\u0002\u0002B7\u0003O\u0011A\u0001V1tW.\u0012!\u0011\u000f\t\u0005\u0005g\u0012i(\u0004\u0002\u0003v)!!q\u000fB=\u0003%)hn\u00195fG.,GMC\u0002\u0003|\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yH!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004g[\t\u0007!1Q\u000b\u0004Q\n\u0015Ea\u0002B-\u0005\u0003\u0013\r\u0001[\u0001\faJLg/\u001b7fI\u001e,G-\u0006\u0003\u0003\f\nMEC\u0001BG)\u0011\u0011yIa'\u0011\t\u0001\u0004!\u0011\u0013\t\u0004I\nMEA\u00024/\u0005\u0004\u0011)*F\u0002i\u0005/#qA!'\u0003\u0014\n\u0007\u0001N\u0001\u0003`I\u0011\u001a\u0004\"CA.]A\u0005\t9\u0001BO!\u0019\t)#a\u000b\u0003\u0012\u0006)\u0002O]5wS2,GmZ3eI\u0011,g-Y;mi\u0012\nT\u0003\u0002B2\u0005G#aAZ\u0018C\u0002\t\u0015Vc\u00015\u0003(\u00129!\u0011\u0014BR\u0005\u0004A\u0017a\u00043fY\u0016$XMU3dkJ\u001c\u0018N^3\u0015\t\t5&1\u0017\t\u0004\u007f\t=\u0016b\u0001BY\u0001\n!QK\\5u\u0011\u0019\u0011)\f\ra\u0001+\u0006\ta-A\u0006be\u000eD\u0017N^3UsB,G\u0003\u0002B^\u0005\u0007\u0004RaPA\u0006\u0005{\u00032\u0001\u0019B`\u0013\r\u0011\tm\u000e\u0002\f\u0003J\u001c\u0007.\u001b<f)f\u0004X\rC\u0004\u0002@F\u0002\r!!\u001c\u0016\t\t\u001d'q\u001a\u000b\u0005\u0005\u0013\u0014I\u000e\u0006\u0003\u0003L\nU\u0007\u0003\u00021\u0001\u0005\u001b\u00042\u0001\u001aBh\t\u00191'G1\u0001\u0003RV\u0019\u0001Na5\u0005\rA\u0014yM1\u0001i\u0011\u001d\tyB\ra\u0002\u0005/\u0004b!!\n\u0002,\t5\u0007\"B*3\u0001\u0004)V\u0003\u0002Bo\u0005K$\u0002Ba8\u0003p\nE(Q\u001f\u000b\u0005\u0005C\u0014Y\u000f\u0005\u0003a\u0001\t\r\bc\u00013\u0003f\u00121am\rb\u0001\u0005O,2\u0001\u001bBu\t\u0019\u0001(Q\u001db\u0001Q\"9\u0011qD\u001aA\u0004\t5\bCBA\u0013\u0003W\u0011\u0019\u000fC\u0003Tg\u0001\u0007Q\u000b\u0003\u00049g\u0001\u0007!1\u001f\t\u0005A\u0006\u0014\u0019\u000fC\u0003sg\u0001\u0007A/\u0006\u0003\u0003z\u000e\u0005AC\u0004B~\u0007\u0017\u0019ia!\u0005\u0004\u0014\rU1q\u0003\u000b\u0005\u0005{\u001c9\u0001\u0005\u0003a\u0001\t}\bc\u00013\u0004\u0002\u00111a\r\u000eb\u0001\u0007\u0007)2\u0001[B\u0003\t\u0019\u00018\u0011\u0001b\u0001Q\"9\u0011q\u0004\u001bA\u0004\r%\u0001CBA\u0013\u0003W\u0011y\u0010C\u0003Ti\u0001\u0007Q\u000b\u0003\u00049i\u0001\u00071q\u0002\t\u0005A\u0006\u0014y\u0010C\u0003si\u0001\u0007A\u000fC\u0003yi\u0001\u0007!\u0010C\u0004\u0002\u0006Q\u0002\r!!\u0003\t\u000f\u0005EA\u00071\u0001\u0002\u0016\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111Q\u0004\t\u0005\u0003w\u001cy\"\u0003\u0003\u0004\"\u0005u(AB(cU\u0016\u001cG\u000f")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final UnArchiver.OpenStream openStream;
    private final Option<File> shortPathDirectory;
    private final Option<Object> integrityCheck;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Option<File> shortPathDirectory, Option<Object> integrityCheck, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, openStream, shortPathDirectory, integrityCheck, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> priviledged$default$1() {
        return ArchiveCache$.MODULE$.priviledged$default$1();
    }

    public static <F> ArchiveCache<F> priviledged(Sync<F> S) {
        return ArchiveCache$.MODULE$.priviledged(S);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public UnArchiver.OpenStream openStream() {
        return this.openStream;
    }

    public Option<File> shortPathDirectory() {
        return this.shortPathDirectory;
    }

    public Option<Object> integrityCheck() {
        return this.integrityCheck;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Tuple2<File, Seq<String>> localDir(Artifact artifact) {
        File file;
        Object object;
        String[] stringArray = artifact.url().split("\\!", -1);
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) < 0) {
            throw new MatchError((Object)stringArray);
        }
        String mainUrl = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Seq subPaths = Array.UnapplySeqWrapper$.MODULE$.drop$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)mainUrl, (Object)subPaths);
        String mainUrl2 = (String)tuple2._1();
        Seq subPaths2 = (Seq)tuple2._2();
        File dir = CachePath.localFile((String)mainUrl2, (File)this.location(), (String)((String)artifact.authentication().flatMap((Function1 & Serializable)x$2 -> x$2.userOpt()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (boolean)true);
        Option<File> option = this.shortPathDirectory();
        if (option instanceof Some) {
            Some some = (Some)option;
            File shortPathBase = (File)some.value();
            byte[] bytes = MessageDigest.getInstance("SHA-1").digest(dir.toString().getBytes());
            String baseSha1 = new BigInteger(1, bytes).toString(16);
            String sha1 = new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 40 - baseSha1.length())).append(baseSha1).toString();
            file = new File(shortPathBase, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(sha1), 8));
        } else if (None$.MODULE$.equals(option)) {
            file = dir;
        } else {
            throw new MatchError(option);
        }
        File finalDir = file;
        return new Tuple2((Object)finalDir, (Object)subPaths2);
    }

    public F getIfExists(Artifact artifact) {
        Option<ArchiveType> option = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType archiveType0 = (ArchiveType)some.value();
            return this.getIfExists(artifact, archiveType0.singleFile());
        }
        if (None$.MODULE$.equals(option)) {
            return (F)this.S().point((Object)new Left((Object)new ArtifactError.DownloadError(new StringBuilder(39).append("Cannot get archive format from URL for ").append(artifact.url()).toString(), (Option)None$.MODULE$)));
        }
        throw new MatchError(option);
    }

    public F getIfExists(Artifact artifact, boolean isSingleFile) {
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        File dir2 = ((Path)subPaths2.foldLeft((Object)dir02.toPath(), (Function2 & Serializable)(dir, subPath) -> {
            Path f = dir.resolve((String)subPath);
            return f.getParent().resolve(new StringBuilder(1).append(".").append(f.getFileName()).toString());
        })).toFile();
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> dir2.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$3(dir2, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (isSingleFile) {
            return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right((Object)new Some((Object)f));
                        }
                        return new Right((Object)new Some((Object)dir));
                    });
                }
                return this.S().point((Object)either);
            });
        }
        return (F)dirTask;
    }

    public F get0(File dir, Option<String> urlOpt, F download) {
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)exists -> ArchiveCache.$anonfun$get0$10(this, download, urlOpt, dir, BoxesRunTime.unboxToBoolean((Object)exists)));
        return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
            Right right;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                File dir = (File)tuple2._1();
                ArchiveType arcType = (ArchiveType)tuple2._2();
                if (arcType.singleFile()) {
                    return this.S().delay((Function0 & Serializable)() -> {
                        File f;
                        Object object;
                        File[] fileArray = dir.listFiles();
                        return new Right((Object)(fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0 ? (f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0)) : dir));
                    });
                }
            }
            return this.S().point((Object)either.map((Function1 & Serializable)x$5 -> (File)x$5._1()));
        });
    }

    private Option<Object> integrityCheck0(String url, File file) {
        return ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(url).collect((PartialFunction)new Serializable(this, file){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveCache $outer;
            private final File file$1;

            public final <A1 extends ArchiveType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ArchiveType$Gzip$.MODULE$.equals(A1) ? true : ArchiveType$Tgz$.MODULE$.equals(A1)) {
                    Boolean bl;
                    try (InputStream fis = null;){
                        fis = Files.newInputStream(this.file$1.toPath(), new OpenOption[0]);
                        GZIPInputStream gzis = new GZIPInputStream(fis);
                        try {
                            ArchiveCache.coursier$cache$ArchiveCache$$readAndDiscard$1(gzis);
                            bl = BoxesRunTime.boxToBoolean((boolean)true);
                        }
                        catch (ZipException zipException) {
                            bl = BoxesRunTime.boxToBoolean((boolean)false);
                        }
                    }
                    return (B1)bl;
                }
                if (ArchiveType$Zip$.MODULE$.equals(A1)) {
                    Boolean bl;
                    ObjectRef zf = ObjectRef.create(null);
                    try {
                        zf.elem = new ZipFile(this.file$1);
                        try {
                            CollectionConverters$.MODULE$.EnumerationHasAsScala(((ZipFile)zf.elem).entries()).asScala().foreach((Function1 & Serializable)ent -> {
                                $anonfun$integrityCheck0$1.$anonfun$applyOrElse$1(this, zf, ent);
                                return BoxedUnit.UNIT;
                            });
                            bl = BoxesRunTime.boxToBoolean((boolean)true);
                        }
                        catch (ZipException zipException) {
                            bl = BoxesRunTime.boxToBoolean((boolean)false);
                        }
                    }
                    finally {
                        if ((ZipFile)zf.elem != null) {
                            ((ZipFile)zf.elem).close();
                        }
                    }
                    return (B1)bl;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ArchiveType x1) {
                ArchiveType archiveType = x1;
                if (ArchiveType$Gzip$.MODULE$.equals(archiveType) ? true : ArchiveType$Tgz$.MODULE$.equals(archiveType)) {
                    return true;
                }
                return ArchiveType$Zip$.MODULE$.equals(archiveType);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$integrityCheck0$1 $this, ObjectRef zf$1, ZipEntry ent) {
                ArchiveCache.coursier$cache$ArchiveCache$$readAndDiscard$1(((ZipFile)zf$1.elem).getInputStream(ent));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.file$1 = file$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(coursier.cache.ArchiveCache$$anonfun$integrityCheck0$1 scala.runtime.ObjectRef java.util.zip.ZipEntry )}, serializedLambda);
            }
        });
    }

    public F get(Artifact artifact) {
        Object object;
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        Artifact artifact0 = artifact.withUrl(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(artifact.url()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiveCache.$anonfun$get$1(BoxesRunTime.unboxToChar((Object)x$7)))));
        if (BoxesRunTime.unboxToBoolean((Object)this.integrityCheck().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
            EitherT eitherT = new EitherT(this.doDownload$1(artifact0)).flatMap((Function1 & Serializable)f -> new EitherT(this.S().delay((Function0 & Serializable)() -> new Right((Object)BoxesRunTime.boxToBoolean((boolean)this.integrityCheck0(artifact0.url(), (File)f).contains((Object)BoxesRunTime.boxToBoolean((boolean)false)))))).flatMap((Function1 & Serializable)invalid -> ArchiveCache.$anonfun$get$5(this, f, artifact0, BoxesRunTime.unboxToBoolean((Object)invalid)), this.sync()), this.sync());
            object = eitherT.run();
        } else {
            object = this.doDownload$1(artifact0);
        }
        Object download = object;
        Object main = this.get0(dir02, (Option<String>)new Some((Object)artifact0.url()), download);
        return (F)new EitherT(main).flatMap((Function1 & Serializable)dir -> {
            if (subPaths2.isEmpty()) {
                return EitherT$.MODULE$.point(dir, this.sync());
            }
            Seq init = (Seq)subPaths2.init();
            String last = (String)subPaths2.last();
            return this.process$1(dir.toPath(), artifact0.url(), init.toList()).map((Function1 & Serializable)x$9 -> x$9.resolve(last).toFile(), this.sync());
        }, this.sync()).run();
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.openStream(), this.shortPathDirectory(), this.integrityCheck(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.openStream(), this.shortPathDirectory(), this.integrityCheck(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.openStream(), this.shortPathDirectory(), this.integrityCheck(), this.sync());
    }

    public ArchiveCache<F> withOpenStream(UnArchiver.OpenStream openStream) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), openStream, this.shortPathDirectory(), this.integrityCheck(), this.sync());
    }

    public ArchiveCache<F> withShortPathDirectory(Option<File> shortPathDirectory) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), shortPathDirectory, this.integrityCheck(), this.sync());
    }

    public ArchiveCache<F> withIntegrityCheck(Option<Object> integrityCheck) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), this.shortPathDirectory(), integrityCheck, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), this.shortPathDirectory(), this.integrityCheck(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.openStream()));
        b.append(", ");
        b.append(String.valueOf(this.shortPathDirectory()));
        b.append(", ");
        b.append(String.valueOf(this.integrityCheck()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        UnArchiver.OpenStream openStream = this.openStream();
        UnArchiver.OpenStream openStream2 = other.openStream();
        if (openStream == null) {
            if (openStream2 != null) {
                return false;
            }
        } else if (!openStream.equals(openStream2)) return false;
        Option<File> option = this.shortPathDirectory();
        Option<File> option2 = other.shortPathDirectory();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.integrityCheck();
        Option<Object> option4 = other.integrityCheck();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash((Object)this.openStream());
        code = 37 * code + Statics.anyHash(this.shortPathDirectory());
        code = 37 * code + Statics.anyHash(this.integrityCheck());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple7<File, Cache<F>, UnArchiver, UnArchiver.OpenStream, Option<File>, Option<Object>, Sync<F>> tuple() {
        return new Tuple7((Object)this.location(), this.cache(), (Object)this.unArchiver(), (Object)this.openStream(), this.shortPathDirectory(), this.integrityCheck(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.openStream();
            }
            case 4: {
                return this.shortPathDirectory();
            }
            case 5: {
                return this.integrityCheck();
            }
            case 6: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "openStream";
            }
            case 4: {
                return "shortPathDirectory";
            }
            case 5: {
                return "integrityCheck";
            }
            case 6: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$3(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return new Right((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return new Right((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Either maybeArchiveType$1(File f, Option urlOpt) {
        return (Either)urlOpt.flatMap((Function1 & Serializable)url -> ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType((String)url)).map((Function1 & Serializable)x$4 -> new Right(x$4)).getOrElse((Function0 & Serializable)() -> {
            Tika tika = new Tika();
            String mimeType = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> tika.detect(is), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            boolean bl = false;
            Some some = null;
            Option<ArchiveType> option = ArchiveType$.MODULE$.fromMimeType(mimeType);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ArchiveType compressed = (ArchiveType)some.value();
                if (compressed instanceof ArchiveType.Compressed) {
                    Some some2;
                    ArchiveType archiveType;
                    ArchiveType.Compressed compressed2 = (ArchiveType.Compressed)compressed;
                    String t0 = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> {
                        Tika tika = new Tika();
                        return tika.detect(this.openStream().inputStream(compressed2, (InputStream)is));
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    Option<ArchiveType> option2 = ArchiveType$.MODULE$.fromMimeType(t0);
                    return new Right((Object)(option2 instanceof Some && ArchiveType$Tar$.MODULE$.equals(archiveType = (ArchiveType)(some2 = (Some)option2).value()) ? compressed2.tar() : compressed2));
                }
            }
            if (bl) {
                ArchiveType tpe = (ArchiveType)some.value();
                return new Right((Object)tpe);
            }
            if (None$.MODULE$.equals(option)) {
                return new Left((Object)new ArtifactError.DownloadError(new StringBuilder(72).append("Cannot detect archive type of ").append(f).append(", or unsupported archive type (MIME type ").append(mimeType).append(")").toString(), (Option)None$.MODULE$));
            }
            throw new MatchError(option);
        });
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, ArchiveType archiveType0, File dir$3) {
        return this.S().delay((Function0 & Serializable)() -> {
            ArchiveType archiveType1 = (ArchiveType)CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (Function0 & Serializable)() -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile((File)dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
                return archiveType0;
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType1));
        });
    }

    public static final /* synthetic */ Object $anonfun$get0$10(ArchiveCache $this, Object download$1, Option urlOpt$1, File dir$3, boolean exists) {
        return Monad.ops$.MODULE$.toAllMonadOps(download$1, $this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return $this.S().point((Object)new Left((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                Either either2 = $this.maybeArchiveType$1(f, urlOpt$1);
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    ArtifactError err = (ArtifactError)left.value();
                    return $this.S().point((Object)new Left((Object)err));
                }
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    ArchiveType archiveType0 = (ArchiveType)right2.value();
                    if (exists) {
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point((Object)new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType0)));
                        }
                        return $this.extract$1(f, true, archiveType0, dir$3);
                    }
                    return $this.extract$1(f, false, archiveType0, dir$3);
                }
                throw new MatchError((Object)either2);
            }
            throw new MatchError((Object)either);
        });
    }

    public static final void coursier$cache$ArchiveCache$$readAndDiscard$1(InputStream is) {
        byte[] buf = (byte[])Array$.MODULE$.ofDim(65536, (ClassTag)ClassTag$.MODULE$.Byte());
        int read = 0;
        while ((read = is.read(buf)) >= 0) {
        }
    }

    public static final /* synthetic */ boolean $anonfun$get$1(char x$7) {
        return x$7 != '!';
    }

    private final Object doDownload$1(Artifact artifact0$1) {
        return this.cache().file(artifact0$1).run();
    }

    public static final /* synthetic */ EitherT $anonfun$get$5(ArchiveCache $this, File f$3, Artifact artifact0$1, boolean invalid) {
        return new EitherT(invalid ? Monad.ops$.MODULE$.toAllMonadOps($this.S().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Files.delete(f$3.toPath());
            FileCache$.MODULE$.clearAuxiliaryFiles(f$3);
        }), $this.sync()).flatMap((Function1 & Serializable)x$8 -> $this.doDownload$1(artifact0$1)) : $this.S().point((Object)new Right((Object)f$3))).map((Function1 & Serializable)f0 -> f0, $this.sync());
    }

    private final EitherT process$1(Path file, String url, List subPaths0) {
        List list = subPaths0;
        if (Nil$.MODULE$.equals(list)) {
            return EitherT$.MODULE$.point((Object)file, this.sync());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String subPath = (String)colon2.head();
            List rest = colon2.next$access$1();
            Path arc = file.resolve(subPath);
            Path dest = arc.getParent().resolve(new StringBuilder(1).append(".").append(arc.getFileName()).toString());
            String url0 = new StringBuilder(1).append(url).append("!").append(subPath).toString();
            return new EitherT(this.get0(dest.toFile(), (Option<String>)new Some((Object)url0), this.S().point((Object)new Right((Object)arc.toFile())))).flatMap((Function1 & Serializable)dir0 -> this.process$1(dir0.toPath(), url0, rest), this.sync());
        }
        throw new MatchError((Object)list);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Option<File> shortPathDirectory, Option<Object> integrityCheck, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.openStream = openStream;
        this.shortPathDirectory = shortPathDirectory;
        this.integrityCheck = integrityCheck;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this(location, cache, unArchiver, (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, (Option<Object>)None$.MODULE$, sync);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, (Cache<F>)FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, (Option<Object>)None$.MODULE$, sync);
    }
}

