/*
 * Decompiled with CFR 0.152.
 */
package io.github.soc.directories;

import io.github.soc.directories.UnsupportedOperatingSystemException;
import io.github.soc.directories.Util;
import java.util.Locale;

public final class ProjectDirectories {
    public final String projectName;
    public final String projectCacheDir;
    public final String projectConfigDir;
    public final String projectDataDir;
    public final String projectDataRoamingDir;

    private ProjectDirectories(String string, String string2, String string3, String string4, String string5) {
        Util.requireNonNull(string);
        this.projectName = string;
        this.projectCacheDir = string2;
        this.projectConfigDir = string3;
        this.projectDataDir = string4;
        this.projectDataRoamingDir = string5;
    }

    public static ProjectDirectories fromUnprocessedString(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                String string6 = System.getenv("HOME");
                string5 = Util.defaultIfNullOrEmpty(System.getenv("XDG_CACHE_HOME"), string6 + "/.cache/", string + "/");
                string4 = Util.defaultIfNullOrEmpty(System.getenv("XDG_CONFIG_HOME"), string6 + "/.config/", string + "/");
                string2 = string3 = Util.defaultIfNullOrEmpty(System.getenv("XDG_DATA_HOME"), string6 + "/.local/share/", string + "/");
                break;
            }
            case 'm': {
                String string7 = System.getenv("HOME");
                string5 = string7 + "/Library/Caches/" + string + "/";
                string4 = string7 + "/Library/Preferences/" + string + "/";
                string2 = string3 = string7 + "/Library/Application Support/" + string + "/";
                break;
            }
            case 'w': {
                string3 = Util.runPowerShellCommand("LocalApplicationData") + "/" + string + "/";
                string2 = Util.runPowerShellCommand("ApplicationData") + "/" + string + "/";
                string4 = string3;
                string5 = string3 + "cache/";
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return new ProjectDirectories(string, string5, string4, string3, string2);
    }

    public static ProjectDirectories fromQualifiedProjectName(String string) {
        String string2;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                string2 = Util.stripQualification(string).toLowerCase(Locale.ENGLISH).trim();
                break;
            }
            case 'm': {
                string2 = string;
                break;
            }
            case 'w': {
                string2 = Util.stripQualification(string);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromUnprocessedString(string2);
    }

    public static ProjectDirectories fromProjectName(String string) {
        String string2;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                string2 = Util.trimAndReplaceSpacesWithHyphensThenLowerCase(string);
                break;
            }
            case 'm': 
            case 'w': {
                string2 = string;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromUnprocessedString(string2);
    }

    public String toString() {
        return "ProjectDirectories on operating system '" + Util.operatingSystemName + "':  projectName           ='" + this.projectName + '\'' + "  projectCacheDir       ='" + this.projectCacheDir + '\'' + "  projectConfigDir      ='" + this.projectConfigDir + '\'' + "  projectDataDir        ='" + this.projectDataDir + '\'' + "  projectDataRoamingDir ='" + this.projectDataRoamingDir + '\'';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectDirectories projectDirectories = (ProjectDirectories)object;
        if (!this.projectName.equals(projectDirectories.projectName)) {
            return false;
        }
        if (this.projectCacheDir != null ? !this.projectCacheDir.equals(projectDirectories.projectCacheDir) : projectDirectories.projectCacheDir != null) {
            return false;
        }
        if (this.projectConfigDir != null ? !this.projectConfigDir.equals(projectDirectories.projectConfigDir) : projectDirectories.projectConfigDir != null) {
            return false;
        }
        if (this.projectDataDir != null ? !this.projectDataDir.equals(projectDirectories.projectDataDir) : projectDirectories.projectDataDir != null) {
            return false;
        }
        return this.projectDataRoamingDir != null ? this.projectDataRoamingDir.equals(projectDirectories.projectDataRoamingDir) : projectDirectories.projectDataRoamingDir == null;
    }

    public int hashCode() {
        int n = this.projectName.hashCode();
        n = 31 * n + (this.projectCacheDir != null ? this.projectCacheDir.hashCode() : 0);
        n = 31 * n + (this.projectConfigDir != null ? this.projectConfigDir.hashCode() : 0);
        n = 31 * n + (this.projectDataDir != null ? this.projectDataDir.hashCode() : 0);
        n = 31 * n + (this.projectDataRoamingDir != null ? this.projectDataRoamingDir.hashCode() : 0);
        return n;
    }
}

