/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArtifactError;
import coursier.paths.CachePath;
import coursier.paths.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class CacheLocks$ {
    public static CacheLocks$ MODULE$;
    private final ConcurrentHashMap<String, Object> urlLocks;
    private final Object urlLockDummyObject;

    static {
        new CacheLocks$();
    }

    public <T> T withStructureLock(File cache, Function0<T> f) {
        return (T)CachePath.withStructureLock(cache, new Callable<T>(f){
            private final Function0 f$1;

            public T call() {
                return (T)this.f$1.apply();
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public <T> T withStructureLock(Path cache, Function0<T> f) {
        return (T)CachePath.withStructureLock(cache, new Callable<T>(f){
            private final Function0 f$2;

            public T call() {
                return (T)this.f$2.apply();
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public <T> T withLockOr(File cache, File file, Function0<T> f, Function0<Option<T>> ifLocked) {
        Object object;
        Path lockFile = CachePath.lockFile(file).toPath();
        ObjectRef channel = ObjectRef.create(null);
        this.withStructureLock(cache, (Function0<T>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Util.createDirectories(lockFile.getParent());
            channel$1.elem = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        });
        try {
            object = this.loop$1(channel, ifLocked, f, lockFile);
        }
        finally {
            if ((FileChannel)channel.elem != null) {
                ((FileChannel)channel.elem).close();
            }
        }
        return (T)object;
    }

    public <T> Either<ArtifactError, T> withLockFor(File cache, File file, Function0<Either<ArtifactError, T>> f) {
        return this.withLockOr(cache, file, f, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)package$.MODULE$.Left().apply((Object)new ArtifactError.Locked(file))));
    }

    private ConcurrentHashMap<String, Object> urlLocks() {
        return this.urlLocks;
    }

    private Object urlLockDummyObject() {
        return this.urlLockDummyObject;
    }

    public <T> Option<T> withUrlLock(String url, Function0<T> f) {
        Object prev = this.urlLocks().putIfAbsent(url, this.urlLockDummyObject());
        if (prev == null) {
            Some some;
            try {
                some = new Some(f.apply());
            }
            finally {
                this.urlLocks().remove(url);
            }
            return some;
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ FileLock liftedTree1$1(ObjectRef channel$1, BooleanRef deadlockAvoided$1) {
        FileLock fileLock;
        try {
            fileLock = ((FileChannel)channel$1.elem).tryLock();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof OverlappingFileLockException) {
                fileLock = null;
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                String string = iOException.getMessage();
                String string2 = "Resource deadlock avoided";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    deadlockAvoided$1.elem = true;
                    Thread.sleep(200L);
                    fileLock = null;
                }
            }
            throw throwable;
        }
        return fileLock;
    }

    private final Object loop$1(ObjectRef channel$1, Function0 ifLocked$1, Function0 f$3, Path lockFile$1) {
        None$ none$;
        do {
            None$ resOpt;
            None$ none$2;
            block10: {
                FileLock lock = null;
                try {
                    BooleanRef deadlockAvoided = BooleanRef.create((boolean)false);
                    lock = CacheLocks$.liftedTree1$1(channel$1, deadlockAvoided);
                    if (deadlockAvoided.elem) {
                        none$2 = None$.MODULE$;
                        break block10;
                    }
                    if (lock == null) {
                        none$2 = (Option)ifLocked$1.apply();
                        break block10;
                    }
                    try {
                        none$2 = new Some(f$3.apply());
                    }
                    finally {
                        lock.release();
                        lock = null;
                        ((FileChannel)channel$1.elem).close();
                        channel$1.elem = null;
                        Files.deleteIfExists(lockFile$1);
                    }
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                }
            }
            none$ = resOpt = none$2;
            if (!(none$ instanceof Some)) continue;
            Some some = (Some)none$;
            Object res = some.value();
            return res;
        } while (None$.MODULE$.equals(none$));
        throw new MatchError((Object)none$);
    }

    private CacheLocks$() {
        MODULE$ = this;
        this.urlLocks = new ConcurrentHashMap();
        this.urlLockDummyObject = new Object();
    }
}

