/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$Gzip$;
import coursier.cache.ArchiveType$Tbz2$;
import coursier.cache.ArchiveType$Tgz$;
import coursier.cache.ArchiveType$Zip$;
import coursier.cache.UnArchiver$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u00113q!\u0003\u0006\u0011\u0002G\u0005q\u0002C\u0003\u0017\u0001\u0019\u0005qcB\u00033\u0015!\u00051GB\u0003\n\u0015!\u0005A\u0007C\u00036\u0007\u0011\u0005aG\u0002\u00038\u0007\u0019A\u0004\"B\u001b\u0006\t\u0003Q\u0004\"\u0002\f\u0006\t\u0003i\u0004\"\u0002\"\u0004\t\u0003\u0019%AC+o\u0003J\u001c\u0007.\u001b<fe*\u00111\u0002D\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005A1m\\;sg&,'o\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-A\u0004fqR\u0014\u0018m\u0019;\u0015\u000baY\u0012eK\u0017\u0011\u0005EI\u0012B\u0001\u000e\u0013\u0005\u0011)f.\u001b;\t\u000bq\t\u0001\u0019A\u000f\u0002\u0017\u0005\u00148\r[5wKRK\b/\u001a\t\u0003=}i\u0011AC\u0005\u0003A)\u00111\"\u0011:dQ&4X\rV=qK\")!%\u0001a\u0001G\u00059\u0011M]2iSZ,\u0007C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\tIwNC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#\u0001\u0002$jY\u0016DQ\u0001L\u0001A\u0002\r\nq\u0001Z3ti\u0012K'\u000fC\u0003/\u0003\u0001\u0007q&A\u0005pm\u0016\u0014xO]5uKB\u0011\u0011\u0003M\u0005\u0003cI\u0011qAQ8pY\u0016\fg.\u0001\u0006V]\u0006\u00138\r[5wKJ\u0004\"AH\u0002\u0014\u0005\r\u0001\u0012A\u0002\u001fj]&$h\bF\u00014\u0005E!UMZ1vYR,f.\u0011:dQ&4XM]\n\u0004\u000bAI\u0004C\u0001\u0010\u0001)\u0005Y\u0004C\u0001\u001f\u0006\u001b\u0005\u0019A#\u0002\r?\u007f\u0001\u000b\u0005\"\u0002\u000f\b\u0001\u0004i\u0002\"\u0002\u0012\b\u0001\u0004\u0019\u0003\"\u0002\u0017\b\u0001\u0004\u0019\u0003\"\u0002\u0018\b\u0001\u0004y\u0013a\u00023fM\u0006,H\u000e\u001e\u000b\u0002s\u0001")
public interface UnArchiver {
    public static UnArchiver default() {
        return UnArchiver$.MODULE$.default();
    }

    public void extract(ArchiveType var1, File var2, File var3, boolean var4);

    private static final class DefaultUnArchiver
    implements UnArchiver {
        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            Right right;
            ArchiveType archiveType2 = archiveType;
            if (ArchiveType$Zip$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new ZipUnArchiver());
            } else if (ArchiveType$Tgz$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new TarGZipUnArchiver());
            } else if (ArchiveType$Tbz2$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new TarBZip2UnArchiver());
            } else if (ArchiveType$Gzip$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Left().apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    File dest = new File(destDir, new StringOps(Predef$.MODULE$.augmentString(archive.getName())).stripSuffix(".gz"));
                    InputStream fis = null;
                    OutputStream fos = null;
                    GZIPInputStream gzis = null;
                    try {
                        fis = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                        gzis = new GZIPInputStream(fis);
                        fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = gzis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (gzis != null) {
                            gzis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                });
            } else {
                throw new MatchError((Object)archiveType2);
            }
            Right unArchiver = right;
            destDir.mkdirs();
            Right right2 = unArchiver;
            if (right2 instanceof Left) {
                Left left = (Left)right2;
                Function0 f = (Function0)left.value();
                f.apply$mcV$sp();
                return;
            }
            if (right2 instanceof Right) {
                Right right3 = right2;
                org.codehaus.plexus.archiver.UnArchiver u = (org.codehaus.plexus.archiver.UnArchiver)right3.value();
                u.setOverwrite(false);
                u.setSourceFile(archive);
                u.setDestDirectory(destDir);
                u.extract();
                return;
            }
            throw new MatchError((Object)right2);
        }
    }
}

