/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.Monad;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\u0014(\u00051B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\u0006\u0001BC\u0002\u0013\u0005a\n\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q1A\u0005\u0004%D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t!\u001f\u0005\u0006{\u0002!I!\u001b\u0005\u0006}\u0002!Ia \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u000f\u001d\t)j\nE\u0001\u0003/3aAJ\u0014\t\u0002\u0005e\u0005BB9\u001e\t\u0003\ty\nC\u0004\u0002\"v!\t!a)\t\u0013\u0005eV$%A\u0005\u0002\u0005m\u0006bBAq;\u0011%\u00111\u001d\u0005\b\u0003_lB\u0011BAy\u0011\u001d\t\t+\bC\u0001\u0005\u0017Aq!!)\u001e\t\u0003\u0011\t\u0003C\u0005\u0003>u\t\t\u0011\"\u0003\u0003@\ta\u0011I]2iSZ,7)Y2iK*\u0011\u0001&K\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005A1m\\;sg&,'o\u0001\u0001\u0016\u00055*6\u0003\u0002\u0001/i]\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u00186\u0013\t1\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta4&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011q\bM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@a\u0005AAn\\2bi&|g.F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0002j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u0005\u00111\u0015\u000e\\3\u0002\u00131|7-\u0019;j_:\u0004S#A(\u0011\u0007A\u000b6+D\u0001(\u0013\t\u0011vEA\u0003DC\u000eDW\r\u0005\u0002U+2\u0001A!\u0002,\u0001\u0005\u00049&!\u0001$\u0016\u0005a{\u0016CA-]!\ty#,\u0003\u0002\\a\t9aj\u001c;iS:<\u0007CA\u0018^\u0013\tq\u0006GA\u0002B]f$Q\u0001Y+C\u0002a\u0013Aa\u0018\u0013%c\u000511-Y2iK\u0002\n!\"\u001e8Be\u000eD\u0017N^3s+\u0005!\u0007C\u0001)f\u0013\t1wE\u0001\u0006V]\u0006\u00138\r[5wKJ\f1\"\u001e8Be\u000eD\u0017N^3sA\u0005!1/\u001f8d+\u0005Q\u0007cA6o'6\tAN\u0003\u0002nS\u0005!Q\u000f^5m\u0013\tyGN\u0001\u0003Ts:\u001c\u0017!B:z]\u000e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003tm^DHC\u0001;v!\r\u0001\u0006a\u0015\u0005\u0006Q&\u0001\u001dA\u001b\u0005\u0006\u0007&\u0001\r!\u0012\u0005\u0006Q%\u0001\ra\u0014\u0005\u0006E&\u0001\r\u0001\u001a\u000b\u0003ur$\"\u0001^>\t\u000b!T\u00019\u00016\t\u000b\rS\u0001\u0019A#\u0002\u0003M\u000b\u0001\u0002\\8dC2$\u0015N\u001d\u000b\u0004\u000b\u0006\u0005\u0001bBA\u0002\u0019\u0001\u0007\u0011QA\u0001\tCJ$\u0018NZ1diB\u00191.a\u0002\n\u0007\u0005%AN\u0001\u0005BeRLg-Y2u\u0003-9W\r^%g\u000bbL7\u000f^:\u0015\t\u0005=\u00111\u0005\t\u0005)V\u000b\t\u0002E\u00049\u0003'\t9\"!\b\n\u0007\u0005U!I\u0001\u0004FSRDWM\u001d\t\u0004!\u0006e\u0011bAA\u000eO\ti\u0011I\u001d;jM\u0006\u001cG/\u0012:s_J\u0004BaLA\u0010\u000b&\u0019\u0011\u0011\u0005\u0019\u0003\r=\u0003H/[8o\u0011\u001d\t\u0019!\u0004a\u0001\u0003\u000b\t1aZ3u)\u0011\tI#!\f\u0011\tQ+\u00161\u0006\t\u0007q\u0005M\u0011qC#\t\u000f\u0005\ra\u00021\u0001\u0002\u0006\u0005aq/\u001b;i\u0019>\u001c\u0017\r^5p]R\u0019A/a\r\t\u000b\r{\u0001\u0019A#\u0002\u0013]LG\u000f[\"bG\",Gc\u0001;\u0002:!)\u0001\u0006\u0005a\u0001\u001f\u0006qq/\u001b;i+:\f%o\u00195jm\u0016\u0014Hc\u0001;\u0002@!)!-\u0005a\u0001I\u0006Aq/\u001b;i'ft7\rF\u0002u\u0003\u000bBQ\u0001\u001b\nA\u0002)\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#J\u0015\u0001\u00027b]\u001eLA!!\u0016\u0002P\t11\u000b\u001e:j]\u001e\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00037\n\t\u0007E\u00020\u0003;J1!a\u00181\u0005\u001d\u0011un\u001c7fC:Da!a\u0019\u0015\u0001\u0004a\u0016aA8cU\u00061Q-];bYN$B!a\u0017\u0002j!1\u00111M\u000bA\u0002q\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003_\u00022aLA9\u0013\r\t\u0019\b\r\u0002\u0004\u0013:$\u0018!\u0002;va2,WCAA=!\u001dy\u00131P#PI*L1!! 1\u0005\u0019!V\u000f\u001d7fi\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u00049\u0006-\u0005bBAG5\u0001\u0007\u0011qN\u0001\u0002]\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY%a%\t\u000f\u000555\u00041\u0001\u0002p\u0005a\u0011I]2iSZ,7)Y2iKB\u0011\u0001+H\n\u0005;9\nY\nE\u0002G\u0003;K!!Q$\u0015\u0005\u0005]\u0015!B1qa2LX\u0003BAS\u0003[#\"!a*\u0015\t\u0005%\u0016Q\u0017\t\u0005!\u0002\tY\u000bE\u0002U\u0003[#aAV\u0010C\u0002\u0005=Vc\u0001-\u00022\u00129\u00111WAW\u0005\u0004A&\u0001B0%IIB\u0001\"`\u0010\u0011\u0002\u0003\u000f\u0011q\u0017\t\u0005W:\fY+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\ti,a7\u0015\u0005\u0005}&\u0006BAa\u0003\u0013\u0004Ba\u001b8\u0002DB\u00191.!2\n\u0007\u0005\u001dGN\u0001\u0003UCN\\7FAAf!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0007'\u0001\u0006b]:|G/\u0019;j_:LA!!7\u0002P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\rY\u0003#\u0019AAo+\rA\u0016q\u001c\u0003\b\u0003g\u000bYN1\u0001Y\u0003=!W\r\\3uKJ+7-\u001e:tSZ,G\u0003BAs\u0003W\u00042aLAt\u0013\r\tI\u000f\r\u0002\u0005+:LG\u000f\u0003\u0004\u0002n\u0006\u0002\r!R\u0001\u0002M\u0006Y\u0011M]2iSZ,G+\u001f9f)\u0011\t\u00190!?\u0011\u0007A\u000b)0C\u0002\u0002x\u001e\u00121\"\u0011:dQ&4X\rV=qK\"9\u00111 \u0012A\u0002\u0005u\u0018aA;sYB!\u0011q B\u0004\u001d\u0011\u0011\tAa\u0001\u0011\u0005i\u0002\u0014b\u0001B\u0003a\u00051\u0001K]3eK\u001aLA!!\u0016\u0003\n)\u0019!Q\u0001\u0019\u0016\t\t5!Q\u0003\u000b\u0005\u0005\u001f\u0011y\u0002\u0006\u0003\u0003\u0012\tm\u0001\u0003\u0002)\u0001\u0005'\u00012\u0001\u0016B\u000b\t\u001916E1\u0001\u0003\u0018U\u0019\u0001L!\u0007\u0005\r\u0001\u0014)B1\u0001Y\u0011\u0019A7\u0005q\u0001\u0003\u001eA!1N\u001cB\n\u0011\u0015\u00195\u00051\u0001F+\u0011\u0011\u0019Ca\u000b\u0015\u0011\t\u0015\"Q\u0007B\u001c\u0005w!BAa\n\u00032A!\u0001\u000b\u0001B\u0015!\r!&1\u0006\u0003\u0007-\u0012\u0012\rA!\f\u0016\u0007a\u0013y\u0003\u0002\u0004a\u0005W\u0011\r\u0001\u0017\u0005\u0007Q\u0012\u0002\u001dAa\r\u0011\t-t'\u0011\u0006\u0005\u0006\u0007\u0012\u0002\r!\u0012\u0005\u0007Q\u0011\u0002\rA!\u000f\u0011\tA\u000b&\u0011\u0006\u0005\u0006E\u0012\u0002\r\u0001Z\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0003\u0002B!!\u0014\u0003D%!!QIA(\u0005\u0019y%M[3di\u0002")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1 & Serializable)x$1 -> x$1.user()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (archiveType0.singleFile()) {
            return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return package$.MODULE$.Right().apply((Object)new Some((Object)f));
                        }
                        return package$.MODULE$.Right().apply((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return (F)dirTask;
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad.ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return this.S().point(package$.MODULE$.Left().apply((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                return this.extract$1(f, false, dir, archiveType0);
            }
            throw new MatchError((Object)either);
        });
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean((Object)x0$2)));
        if (archiveType0.singleFile()) {
            return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$4 -> {
                Either either = x0$4;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    File dir = (File)right.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return package$.MODULE$.Right().apply((Object)f);
                        }
                        return package$.MODULE$.Right().apply((Object)dir);
                    });
                }
                return this.S().point(either);
            });
        }
        return (F)dirTask;
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple4<File, Cache<F>, UnArchiver, Sync<F>> tuple() {
        return new Tuple4((Object)this.location(), this.cache(), (Object)this.unArchiver(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return package$.MODULE$.Right().apply((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0 & Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (JFunction0.mcV.sp & Serializable)() -> {
                if (deleteDest || !dir$3.exists()) {
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                            return;
                        }
                        ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        return;
                    }
                    ArchiveCache.moveToDest$1(tmp, dir$3);
                    return;
                }
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return package$.MODULE$.Right().apply((Object)dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        boolean bl = x0$2;
        if (bl) {
            if (artifact$1.changing()) {
                return Monad.ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1 & Serializable)x0$3 -> {
                    Either either = x0$3;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        ArtifactError err = (ArtifactError)left.value();
                        return $this.S().point(package$.MODULE$.Left().apply((Object)err));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        File f = (File)right.value();
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
                        }
                        return $this.extract$1(f, true, dir$3, archiveType0$1);
                    }
                    throw new MatchError((Object)either);
                });
            }
            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
        }
        if (!bl) {
            return downloadAndExtract$1;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), sync);
    }
}

