/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache.internal;

import coursier.cache.ArtifactError;
import coursier.cache.ArtifactError$NotFound$;
import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.CachePolicy;
import coursier.cache.CacheUrl$;
import coursier.cache.ConnectionBuilder$;
import coursier.cache.internal.Downloader;
import coursier.cache.internal.Downloader$UnknownProtocol$;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import coursier.util.Artifact;
import coursier.util.Sync;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader = new .colon.colon((Object)"MD5", (List)new .colon.colon((Object)"SHA1", (List)new .colon.colon((Object)"SHA256", (List)Nil$.MODULE$)));

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f, Function0<Option<Either<ArtifactError, T>>> ifLocked) {
        return this.helper$2(sslRetry, url, f, ifLocked);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left left;
        block9: {
            URLConnection conn;
            block8: {
                conn = null;
                try {
                    URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        logger.gettingLength(url);
                        boolean success = false;
                        try {
                            Option len = new Some((Object)BoxesRunTime.boxToLong((long)httpURLConnection.getContentLengthLong())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$26 -> x$26 >= 0L);
                            success = true;
                            logger.gettingLengthResult(url, (Option<Object>)len);
                            left = package$.MODULE$.Right().apply((Object)len);
                            break block8;
                        }
                        finally {
                            if (!success) {
                                logger.gettingLengthResult(url, (Option<Object>)None$.MODULE$);
                            }
                        }
                    }
                    left = package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), (Option<Throwable>)None$.MODULE$));
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        CacheUrl$.MODULE$.closeConn(conn);
                    }
                    throw throwable;
                }
            }
            if (conn == null) break block9;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.bufferSize(), (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, Clock.systemDefaultZone(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, S);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Downloader$.class);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$10, Function0 f$1, Function0 ifLocked$1) {
        Option option;
        while (true) {
            Option resOpt;
            Option option2;
            try {
                Option res0 = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0 & Serializable)() -> {
                    Either either;
                    try {
                        either = (Either)f$1.apply();
                    }
                    catch (Throwable throwable) {
                        FileNotFoundException fileNotFoundException;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileNotFoundException && (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() != null) {
                            either = package$.MODULE$.Left().apply((Object)new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                        }
                        throw throwable;
                    }
                    return either;
                });
                option2 = res0.orElse(ifLocked$1);
            }
            catch (Throwable throwable) {
                Option option3;
                Option<Tuple2<MalformedURLException, String>> option4;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SSLException && retry >= 1) {
                    option2 = None$.MODULE$;
                }
                if (throwable2 != null && !(option4 = Downloader$UnknownProtocol$.MODULE$.unapply(throwable2)).isEmpty()) {
                    MalformedURLException e = (MalformedURLException)((Tuple2)option4.get())._1();
                    String msg0 = (String)((Tuple2)option4.get())._2();
                    String docUrl = "https://get-coursier.io/docs/extra.html#extra-protocols";
                    String msg = new .colon.colon((Object)new StringBuilder(30).append("Caught ").append(e.getClass().getName()).append(" (").append(msg0).append(") while downloading ").append(url$10).append(".").toString(), (List)new .colon.colon((Object)new StringBuilder(47).append("Visit ").append(docUrl).append(" to learn how to handle custom protocols.").toString(), (List)Nil$.MODULE$)).mkString(" ");
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(msg, (Option<Throwable>)new Some((Object)e));
                    option2 = new Some((Object)package$.MODULE$.Left().apply((Object)ex));
                }
                if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option3.get();
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$25 -> new StringBuilder(3).append(" (").append((String)x$25).append(")").toString())).append(" while downloading ").append(url$10).toString(), (Option<Throwable>)new Some((Object)e));
                    if (Boolean.getBoolean("coursier.cache.throw-exceptions")) {
                        throw ex;
                    }
                    option2 = new Some((Object)package$.MODULE$.Left().apply((Object)ex));
                }
                throw throwable;
            }
            option = resOpt = option2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Either res = (Either)some.value();
                return res;
            }
            if (!None$.MODULE$.equals(option)) break;
            --retry;
        }
        throw new MatchError((Object)option);
    }

    private Downloader$() {
    }
}

