/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.EitherT;
import coursier.util.EitherT$;
import coursier.util.Monad;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import org.apache.tika.Tika;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\t}h\u0001\u0002\u001a4\u0005aB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t3\u0002\u0011\t\u0011)A\u0005#\"AA\u0007\u0001BC\u0002\u0013\u0005!\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005\u0002UD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005%\u0001A!b\u0001\n\u0007\tY\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002\u001c\u0001!\t!a\f\t\u000f\u0005m\u0001\u0001\"\u0001\u0002<!9\u00111\t\u0001\u0005\n\u0005-\u0001bBA#\u0001\u0011%\u0011q\t\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\ty\u0007\u0001C\u0001\u0003\u0007C\u0001\"!%\u0001\t\u0003\u0019\u00141\u0013\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\ty\u000e\u0001C!\u0003CDq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0003\u0001\u0011\u0005#q\u0001\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0011\u001d\u0011\t\u0002\u0001C!\u0005'9qAa\u00064\u0011\u0003\u0011IB\u0002\u00043g!\u0005!1\u0004\u0005\b\u000371C\u0011\u0001B\u0011\u0011\u001d\u0011\u0019C\nC\u0001\u0005KA\u0011Ba\u000f'#\u0003%\tA!\u0010\t\u000f\t\rd\u0005\"\u0001\u0003f!I!1\u0010\u0014\u0012\u0002\u0013\u0005!Q\u0010\u0005\b\u0005\u000b3C\u0011\u0002BD\u0011\u001d\u0011\u0019J\nC\u0005\u0005+CqAa\t'\t\u0003\u0011\u0019\u000bC\u0004\u0003$\u0019\"\tA!/\t\u000f\t\rb\u0005\"\u0001\u0003V\"I!Q\u001f\u0014\u0002\u0002\u0013%!q\u001f\u0002\r\u0003J\u001c\u0007.\u001b<f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003iU\nQaY1dQ\u0016T\u0011AN\u0001\tG>,(o]5fe\u000e\u0001QCA\u001db'\u0011\u0001!\bQ\"\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g!\tY\u0014)\u0003\u0002Cy\t9\u0001K]8ek\u000e$\bC\u0001#M\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002Io\u00051AH]8pizJ\u0011!P\u0005\u0003\u0017r\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\na1+\u001a:jC2L'0\u00192mK*\u00111\nP\u0001\tY>\u001c\u0017\r^5p]V\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006\u0011\u0011n\u001c\u0006\u0002-\u0006!!.\u0019<b\u0013\tA6K\u0001\u0003GS2,\u0017!\u00037pG\u0006$\u0018n\u001c8!+\u0005Y\u0006c\u0001/^?6\t1'\u0003\u0002_g\t)1)Y2iKB\u0011\u0001-\u0019\u0007\u0001\t\u0015\u0011\u0007A1\u0001d\u0005\u00051UC\u00013l#\t)\u0007\u000e\u0005\u0002<M&\u0011q\r\u0010\u0002\b\u001d>$\b.\u001b8h!\tY\u0014.\u0003\u0002ky\t\u0019\u0011I\\=\u0005\u000b1\f'\u0019\u00013\u0003\t}#C%M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0015Ut\u0017I]2iSZ,'/F\u0001q!\ta\u0016/\u0003\u0002sg\tQQK\\!sG\"Lg/\u001a:\u0002\u0017Ut\u0017I]2iSZ,'\u000fI\u0001\u000b_B,gn\u0015;sK\u0006lW#\u0001<\u0011\u0005]ThB\u0001/y\u0013\tI8'\u0001\u0006V]\u0006\u00138\r[5wKJL!a\u001f?\u0003\u0015=\u0003XM\\*ue\u0016\fWN\u0003\u0002zg\u0005Yq\u000e]3o'R\u0014X-Y7!\u0003I\u0019\bn\u001c:u!\u0006$\b\u000eR5sK\u000e$xN]=\u0016\u0005\u0005\u0005\u0001\u0003B\u001e\u0002\u0004EK1!!\u0002=\u0005\u0019y\u0005\u000f^5p]\u0006\u00192\u000f[8siB\u000bG\u000f\u001b#je\u0016\u001cGo\u001c:zA\u0005!1/\u001f8d+\t\ti\u0001E\u0003\u0002\u0010\u0005Uq,\u0004\u0002\u0002\u0012)\u0019\u00111C\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003/\t\tB\u0001\u0003Ts:\u001c\u0017!B:z]\u000e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002 \u0005\u0015\u0012qEA\u0015\u0003W\ti\u0003\u0006\u0003\u0002\"\u0005\r\u0002c\u0001/\u0001?\"9\u0011\u0011B\u0007A\u0004\u00055\u0001\"B(\u000e\u0001\u0004\t\u0006\"\u0002\u001b\u000e\u0001\u0004Y\u0006\"\u00028\u000e\u0001\u0004\u0001\b\"\u0002;\u000e\u0001\u00041\bB\u0002@\u000e\u0001\u0004\t\t\u0001\u0006\u0005\u00022\u0005U\u0012qGA\u001d)\u0011\t\t#a\r\t\u000f\u0005%a\u0002q\u0001\u0002\u000e!)qJ\u0004a\u0001#\")AG\u0004a\u00017\")aN\u0004a\u0001aR!\u0011QHA!)\u0011\t\t#a\u0010\t\u000f\u0005%q\u0002q\u0001\u0002\u000e!)qj\u0004a\u0001#\u0006\t1+\u0001\u0005m_\u000e\fG\u000eR5s)\u0011\tI%!\u001a\u0011\rm\nY%UA(\u0013\r\ti\u0005\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0011\u000b\t&!\u0016\n\u0007\u0005McJA\u0002TKF\u0004B!a\u0016\u0002`9!\u0011\u0011LA.!\t1E(C\u0002\u0002^q\na\u0001\u0015:fI\u00164\u0017\u0002BA1\u0003G\u0012aa\u0015;sS:<'bAA/y!9\u0011qM\tA\u0002\u0005%\u0014\u0001C1si&4\u0017m\u0019;\u0011\t\u0005=\u00111N\u0005\u0005\u0003[\n\tB\u0001\u0005BeRLg-Y2u\u0003-9W\r^%g\u000bbL7\u000f^:\u0015\t\u0005M\u0014\u0011\u0011\t\u0005A\u0006\f)\bE\u0004E\u0003o\nY(!\u0001\n\u0007\u0005edJ\u0001\u0004FSRDWM\u001d\t\u00049\u0006u\u0014bAA@g\ti\u0011I\u001d;jM\u0006\u001cG/\u0012:s_JDq!a\u001a\u0013\u0001\u0004\tI\u0007\u0006\u0004\u0002t\u0005\u0015\u0015q\u0011\u0005\b\u0003O\u001a\u0002\u0019AA5\u0011\u001d\tIi\u0005a\u0001\u0003\u0017\u000bA\"[:TS:<G.\u001a$jY\u0016\u00042aOAG\u0013\r\ty\t\u0010\u0002\b\u0005>|G.Z1o\u0003\u00119W\r\u001e\u0019\u0015\u0011\u0005U\u0015\u0011TAO\u0003G\u0003B\u0001Y1\u0002\u0018B1A)a\u001e\u0002|ECa!a'\u0015\u0001\u0004\t\u0016a\u00013je\"9\u0011q\u0014\u000bA\u0002\u0005\u0005\u0016AB;sY>\u0003H\u000fE\u0003<\u0003\u0007\t)\u0006C\u0004\u0002&R\u0001\r!!&\u0002\u0011\u0011|wO\u001c7pC\u0012\f1aZ3u)\u0011\t)*a+\t\u000f\u0005\u001dT\u00031\u0001\u0002j\u0005aq/\u001b;i\u0019>\u001c\u0017\r^5p]R!\u0011\u0011EAY\u0011\u0015ye\u00031\u0001R\u0003%9\u0018\u000e\u001e5DC\u000eDW\r\u0006\u0003\u0002\"\u0005]\u0006\"\u0002\u001b\u0018\u0001\u0004Y\u0016AD<ji\",f.\u0011:dQ&4XM\u001d\u000b\u0005\u0003C\ti\fC\u0003o1\u0001\u0007\u0001/\u0001\bxSRDw\n]3o'R\u0014X-Y7\u0015\t\u0005\u0005\u00121\u0019\u0005\u0006if\u0001\rA^\u0001\u0017o&$\bn\u00155peR\u0004\u0016\r\u001e5ESJ,7\r^8ssR!\u0011\u0011EAe\u0011\u0019q(\u00041\u0001\u0002\u0002\u0005Aq/\u001b;i'ft7\r\u0006\u0003\u0002\"\u0005=\u0007bBA\u00057\u0001\u0007\u0011QB\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\\+\u0002\t1\fgnZ\u0005\u0005\u0003C\nI.\u0001\u0005dC:,\u0015/^1m)\u0011\tY)a9\t\r\u0005\u0015X\u00041\u0001i\u0003\ry'M[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u00151\u001e\u0005\u0007\u0003Kt\u0002\u0019\u00015\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!=\u0011\u0007m\n\u00190C\u0002\u0002vr\u00121!\u00138u\u0003\u0015!X\u000f\u001d7f+\t\tY\u0010E\u0006<\u0003{\f6\f\u001d<\u0002\u0002\u00055\u0011bAA\u0000y\t1A+\u001e9mKZ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAk\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t0\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007!\u0014i\u0001C\u0004\u0003\u0010\r\u0002\r!!=\u0002\u00039\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q\u001bB\u000b\u0011\u001d\u0011y\u0001\na\u0001\u0003c\fA\"\u0011:dQ&4XmQ1dQ\u0016\u0004\"\u0001\u0018\u0014\u0014\t\u0019R$Q\u0004\t\u0004%\n}\u0011BA'T)\t\u0011I\"A\u0003baBd\u00170\u0006\u0003\u0003(\t=BC\u0001B\u0015)\u0011\u0011YCa\u000e\u0011\tq\u0003!Q\u0006\t\u0004A\n=BA\u00022)\u0005\u0004\u0011\t$F\u0002e\u0005g!qA!\u000e\u00030\t\u0007AM\u0001\u0003`I\u0011\u0012\u0004\"CA\"QA\u0005\t9\u0001B\u001d!\u0019\ty!!\u0006\u0003.\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003@\tuCC\u0001B!U\u0011\u0011\u0019Ea\u0013\u0011\r\u0005=\u0011Q\u0003B#!\u0011\tyAa\u0012\n\t\t%\u0013\u0011\u0003\u0002\u0005)\u0006\u001c8n\u000b\u0002\u0003NA!!q\nB-\u001b\t\u0011\tF\u0003\u0003\u0003T\tU\u0013!C;oG\",7m[3e\u0015\r\u00119\u0006P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B.\u0005#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019\u0011\u0017F1\u0001\u0003`U\u0019AM!\u0019\u0005\u000f\tU\"Q\fb\u0001I\u0006Y\u0001O]5wS2,GmZ3e+\u0011\u00119Ga\u001c\u0015\u0005\t%D\u0003\u0002B6\u0005o\u0002B\u0001\u0018\u0001\u0003nA\u0019\u0001Ma\u001c\u0005\r\tT#\u0019\u0001B9+\r!'1\u000f\u0003\b\u0005k\u0012yG1\u0001e\u0005\u0011yF\u0005J\u001a\t\u0013\u0005\r#\u0006%AA\u0004\te\u0004CBA\b\u0003+\u0011i'A\u000bqe&4\u0018\u000e\\3eO\u0016$G\u0005Z3gCVdG\u000fJ\u0019\u0016\t\t}\"q\u0010\u0003\u0007E.\u0012\rA!!\u0016\u0007\u0011\u0014\u0019\tB\u0004\u0003v\t}$\u0019\u00013\u0002\u001f\u0011,G.\u001a;f%\u0016\u001cWO]:jm\u0016$BA!#\u0003\u0010B\u00191Ha#\n\u0007\t5EH\u0001\u0003V]&$\bB\u0002BIY\u0001\u0007\u0011+A\u0001g\u0003-\t'o\u00195jm\u0016$\u0016\u0010]3\u0015\t\t]%q\u0014\t\u0006w\u0005\r!\u0011\u0014\t\u00049\nm\u0015b\u0001BOg\tY\u0011I]2iSZ,G+\u001f9f\u0011\u001d\u0011\t+\fa\u0001\u0003+\n1!\u001e:m+\u0011\u0011)K!,\u0015\t\t\u001d&q\u0017\u000b\u0005\u0005S\u0013\u0019\f\u0005\u0003]\u0001\t-\u0006c\u00011\u0003.\u00121!M\fb\u0001\u0005_+2\u0001\u001aBY\t\u0019a'Q\u0016b\u0001I\"9\u0011\u0011\u0002\u0018A\u0004\tU\u0006CBA\b\u0003+\u0011Y\u000bC\u0003P]\u0001\u0007\u0011+\u0006\u0003\u0003<\n\rG\u0003\u0003B_\u0005\u001b\u0014yMa5\u0015\t\t}&\u0011\u001a\t\u00059\u0002\u0011\t\rE\u0002a\u0005\u0007$aAY\u0018C\u0002\t\u0015Wc\u00013\u0003H\u00121ANa1C\u0002\u0011Dq!!\u00030\u0001\b\u0011Y\r\u0005\u0004\u0002\u0010\u0005U!\u0011\u0019\u0005\u0006\u001f>\u0002\r!\u0015\u0005\u0007i=\u0002\rA!5\u0011\tqk&\u0011\u0019\u0005\u0006]>\u0002\r\u0001]\u000b\u0005\u0005/\u0014y\u000e\u0006\u0007\u0003Z\n%(1\u001eBx\u0005c\u0014\u0019\u0010\u0006\u0003\u0003\\\n\u0015\b\u0003\u0002/\u0001\u0005;\u00042\u0001\u0019Bp\t\u0019\u0011\u0007G1\u0001\u0003bV\u0019AMa9\u0005\r1\u0014yN1\u0001e\u0011\u001d\tI\u0001\ra\u0002\u0005O\u0004b!a\u0004\u0002\u0016\tu\u0007\"B(1\u0001\u0004\t\u0006B\u0002\u001b1\u0001\u0004\u0011i\u000f\u0005\u0003];\nu\u0007\"\u000281\u0001\u0004\u0001\b\"\u0002;1\u0001\u00041\bB\u0002@1\u0001\u0004\t\t!\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003zB!\u0011q\u001bB~\u0013\u0011\u0011i0!7\u0003\r=\u0013'.Z2u\u0001")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final UnArchiver.OpenStream openStream;
    private final Option<File> shortPathDirectory;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Option<File> shortPathDirectory, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, openStream, shortPathDirectory, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> priviledged$default$1() {
        return ArchiveCache$.MODULE$.priviledged$default$1();
    }

    public static <F> ArchiveCache<F> priviledged(Sync<F> S) {
        return ArchiveCache$.MODULE$.priviledged(S);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public UnArchiver.OpenStream openStream() {
        return this.openStream;
    }

    public Option<File> shortPathDirectory() {
        return this.shortPathDirectory;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Tuple2<File, Seq<String>> localDir(Artifact artifact) {
        File file;
        Object object;
        String[] stringArray = artifact.url().split("\\!", -1);
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) < 0) {
            throw new MatchError((Object)stringArray);
        }
        String mainUrl = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Seq subPaths = Array.UnapplySeqWrapper$.MODULE$.drop$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)mainUrl, (Object)subPaths);
        String mainUrl2 = (String)tuple2._1();
        Seq subPaths2 = (Seq)tuple2._2();
        File dir = CachePath.localFile(mainUrl2, this.location(), (String)artifact.authentication().flatMap((Function1 & Serializable)x$2 -> x$2.userOpt()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true);
        Option<File> option = this.shortPathDirectory();
        if (option instanceof Some) {
            Some some = (Some)option;
            File shortPathBase = (File)some.value();
            byte[] bytes = MessageDigest.getInstance("SHA-1").digest(dir.toString().getBytes());
            String baseSha1 = new BigInteger(1, bytes).toString(16);
            String sha1 = new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 40 - baseSha1.length())).append(baseSha1).toString();
            file = new File(shortPathBase, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(sha1), 8));
        } else if (None$.MODULE$.equals(option)) {
            file = dir;
        } else {
            throw new MatchError(option);
        }
        File finalDir = file;
        return new Tuple2((Object)finalDir, (Object)subPaths2);
    }

    public F getIfExists(Artifact artifact) {
        Option<ArchiveType> option = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType archiveType0 = (ArchiveType)some.value();
            return this.getIfExists(artifact, archiveType0.singleFile());
        }
        if (None$.MODULE$.equals(option)) {
            return (F)this.S().point(new Left((Object)new ArtifactError.DownloadError(new StringBuilder(39).append("Cannot get archive format from URL for ").append(artifact.url()).toString(), (Option<Throwable>)None$.MODULE$)));
        }
        throw new MatchError(option);
    }

    public F getIfExists(Artifact artifact, boolean isSingleFile) {
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        File dir2 = ((Path)subPaths2.foldLeft((Object)dir02.toPath(), (Function2 & Serializable)(dir, subPath) -> {
            Path f = dir.resolve((String)subPath);
            return f.getParent().resolve(new StringBuilder(1).append(".").append(f.getFileName()).toString());
        })).toFile();
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir2.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$3(dir2, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (isSingleFile) {
            return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right((Object)new Some((Object)f));
                        }
                        return new Right((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return (F)dirTask;
    }

    public F get0(File dir, Option<String> urlOpt, F download) {
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)exists -> ArchiveCache.$anonfun$get0$10(this, download, urlOpt, dir, BoxesRunTime.unboxToBoolean((Object)exists)));
        return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
            Right right;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                File dir = (File)tuple2._1();
                ArchiveType arcType = (ArchiveType)tuple2._2();
                if (arcType.singleFile()) {
                    return this.S().delay((Function0 & Serializable)() -> {
                        File f;
                        Object object;
                        File[] fileArray = dir.listFiles();
                        return new Right((Object)(fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0 ? (f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0)) : dir));
                    });
                }
            }
            return this.S().point(either.map((Function1 & Serializable)x$5 -> (File)x$5._1()));
        });
    }

    public F get(Artifact artifact) {
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        Artifact artifact0 = artifact.withUrl(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(artifact.url()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiveCache.$anonfun$get$1(BoxesRunTime.unboxToChar((Object)x$7)))));
        Object download = this.cache().file(artifact0).run();
        Object main = this.get0(dir02, (Option<String>)new Some((Object)artifact0.url()), download);
        return (F)new EitherT(main).flatMap((Function1 & Serializable)dir -> {
            if (subPaths2.isEmpty()) {
                return EitherT$.MODULE$.point(dir, this.sync());
            }
            Seq init = (Seq)subPaths2.init();
            String last = (String)subPaths2.last();
            return this.process$1(dir.toPath(), artifact0.url(), init.toList()).map((Function1 & Serializable)x$8 -> x$8.resolve(last).toFile(), this.sync());
        }, this.sync()).run();
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.openStream(), this.shortPathDirectory(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.openStream(), this.shortPathDirectory(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.openStream(), this.shortPathDirectory(), this.sync());
    }

    public ArchiveCache<F> withOpenStream(UnArchiver.OpenStream openStream) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), openStream, this.shortPathDirectory(), this.sync());
    }

    public ArchiveCache<F> withShortPathDirectory(Option<File> shortPathDirectory) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), shortPathDirectory, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), this.shortPathDirectory(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.openStream()));
        b.append(", ");
        b.append(String.valueOf(this.shortPathDirectory()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        UnArchiver.OpenStream openStream = this.openStream();
        UnArchiver.OpenStream openStream2 = other.openStream();
        if (openStream == null) {
            if (openStream2 != null) {
                return false;
            }
        } else if (!openStream.equals(openStream2)) return false;
        Option<File> option = this.shortPathDirectory();
        Option<File> option2 = other.shortPathDirectory();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash((Object)this.openStream());
        code = 37 * code + Statics.anyHash(this.shortPathDirectory());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple6<File, Cache<F>, UnArchiver, UnArchiver.OpenStream, Option<File>, Sync<F>> tuple() {
        return new Tuple6((Object)this.location(), this.cache(), (Object)this.unArchiver(), (Object)this.openStream(), this.shortPathDirectory(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.openStream();
            }
            case 4: {
                return this.shortPathDirectory();
            }
            case 5: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "openStream";
            }
            case 4: {
                return "shortPathDirectory";
            }
            case 5: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$3(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return new Right((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return new Right((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Either maybeArchiveType$1(File f, Option urlOpt) {
        return (Either)urlOpt.flatMap((Function1 & Serializable)url -> ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType((String)url)).map((Function1 & Serializable)x$4 -> new Right(x$4)).getOrElse((Function0 & Serializable)() -> {
            Tika tika = new Tika();
            String mimeType = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> tika.detect(is), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            boolean bl = false;
            Some some = null;
            Option<ArchiveType> option = ArchiveType$.MODULE$.fromMimeType(mimeType);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ArchiveType compressed = (ArchiveType)some.value();
                if (compressed instanceof ArchiveType.Compressed) {
                    Some some2;
                    ArchiveType archiveType;
                    ArchiveType.Compressed compressed2 = (ArchiveType.Compressed)compressed;
                    String t0 = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> {
                        Tika tika = new Tika();
                        return tika.detect(this.openStream().inputStream(compressed2, (InputStream)is));
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    Option<ArchiveType> option2 = ArchiveType$.MODULE$.fromMimeType(t0);
                    return new Right((Object)(option2 instanceof Some && ArchiveType$Tar$.MODULE$.equals(archiveType = (ArchiveType)(some2 = (Some)option2).value()) ? compressed2.tar() : compressed2));
                }
            }
            if (bl) {
                ArchiveType tpe = (ArchiveType)some.value();
                return new Right((Object)tpe);
            }
            if (None$.MODULE$.equals(option)) {
                return new Left((Object)new ArtifactError.DownloadError(new StringBuilder(72).append("Cannot detect archive type of ").append(f).append(", or unsupported archive type (MIME type ").append(mimeType).append(")").toString(), (Option<Throwable>)None$.MODULE$));
            }
            throw new MatchError(option);
        });
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, ArchiveType archiveType0, File dir$3) {
        return this.S().delay((Function0 & Serializable)() -> {
            ArchiveType archiveType1 = (ArchiveType)CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (Function0 & Serializable)() -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
                return archiveType0;
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType1));
        });
    }

    public static final /* synthetic */ Object $anonfun$get0$10(ArchiveCache $this, Object download$1, Option urlOpt$1, File dir$3, boolean exists) {
        return Monad.ops$.MODULE$.toAllMonadOps(download$1, $this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return $this.S().point(new Left((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                Either either2 = $this.maybeArchiveType$1(f, urlOpt$1);
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    ArtifactError err = (ArtifactError)left.value();
                    return $this.S().point(new Left((Object)err));
                }
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    ArchiveType archiveType0 = (ArchiveType)right2.value();
                    if (exists) {
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType0)));
                        }
                        return $this.extract$1(f, true, archiveType0, dir$3);
                    }
                    return $this.extract$1(f, false, archiveType0, dir$3);
                }
                throw new MatchError((Object)either2);
            }
            throw new MatchError((Object)either);
        });
    }

    public static final /* synthetic */ boolean $anonfun$get$1(char x$7) {
        return x$7 != '!';
    }

    private final EitherT process$1(Path file, String url, List subPaths0) {
        List list = subPaths0;
        if (Nil$.MODULE$.equals(list)) {
            return EitherT$.MODULE$.point((Object)file, this.sync());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String subPath = (String)colon2.head();
            List rest = colon2.next$access$1();
            Path arc = file.resolve(subPath);
            Path dest = arc.getParent().resolve(new StringBuilder(1).append(".").append(arc.getFileName()).toString());
            String url0 = new StringBuilder(1).append(url).append("!").append(subPath).toString();
            return new EitherT(this.get0(dest.toFile(), (Option<String>)new Some((Object)url0), this.S().point(new Right((Object)arc.toFile())))).flatMap((Function1 & Serializable)dir0 -> this.process$1(dir0.toPath(), url0, rest), this.sync());
        }
        throw new MatchError((Object)list);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Option<File> shortPathDirectory, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.openStream = openStream;
        this.shortPathDirectory = shortPathDirectory;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this(location, cache, unArchiver, (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, sync);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), (Option<File>)None$.MODULE$, sync);
    }
}

