/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.CachePolicy;
import coursier.cache.FileCache;
import coursier.cache.internal.FileUtil;
import coursier.cache.internal.FileUtil$;
import coursier.cache.internal.Retry;
import coursier.credentials.Credentials;
import coursier.paths.CachePath;
import coursier.util.Sync;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class FileCache$
implements Serializable {
    public static final FileCache$ MODULE$ = new FileCache$();

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file) {
        return new StringBuilder(3).append(".").append(file.getName()).append("__").toString();
    }

    public void clearAuxiliaryFiles(File file) {
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])file.getParentFile().listFiles(filter)), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public File auxiliaryFile(File file, String key) {
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar((Object)x$23))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file)).append(key0).toString());
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.location(), S);
    }

    public BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile, Retry retry) {
        byte[] byArray;
        String location0 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(location.getCanonicalPath()), File.separator)).append(File.separator).toString();
        boolean isInCache = localFile.getCanonicalPath().startsWith(location0);
        if (!isInCache) {
            byArray = this.computeDigest(sumType, localFile, retry);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = (byte[])retry.retry((Function0 & Serializable)() -> Files.readAllBytes(cacheFilePath), (PartialFunction<Throwable, BoxedUnit>)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                    }
                });
            }
            catch (NoSuchFileException noSuchFileException) {
                byte[] bytes = this.computeDigest(sumType, localFile, retry);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    retry.retry((Function0 & Serializable)() -> {
                        Object object;
                        try {
                            object = Files.move(tmpFile, cacheFilePath, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }, (PartialFunction<Throwable, BoxedUnit>)new Serializable(){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                        }
                    });
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = bytes;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, digested);
    }

    private byte[] computeDigest(String sumType, File localFile, Retry retry) {
        MessageDigest md = MessageDigest.getInstance(sumType);
        ObjectRef is = ObjectRef.create(null);
        try {
            retry.retry((JFunction0.mcV.sp & Serializable)() -> {
                is$1.elem = Files.newInputStream(localFile.toPath(), new OpenOption[0]);
            }, (PartialFunction<Throwable, BoxedUnit>)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof FileNotFoundException && Properties$.MODULE$.isWin()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable instanceof FileNotFoundException && Properties$.MODULE$.isWin();
                }
            });
            FileUtil$.MODULE$.withContent((InputStream)is.elem, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        finally {
            if ((InputStream)is.elem != null) {
                ((InputStream)is.elem).close();
            }
        }
        return md.digest();
    }

    public <F> FileCache<F> apply(File location, Sync<F> sync) {
        return new FileCache<F>(location, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.retryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.bufferSize(), (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, FiniteDuration retryBackoffInitialDelay2, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, retryBackoffInitialDelay2, CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, retryBackoffInitialDelay2, retryBackoffMultiplier, sync);
    }

    public <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileCache$.class);
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$23) {
        return x$23 != '-';
    }

    private FileCache$() {
    }
}

