/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.CacheEnv$;
import coursier.cache.CachePolicy;
import coursier.credentials.Credentials;
import coursier.paths.CachePath;
import coursier.util.Sync$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Try$;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static File archiveCacheLocation;
    private static File priviledgedArchiveCacheLocation;
    private static File digestBasedCacheLocation;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int retryCount;
    private static FiniteDuration retryBackoffInitialDelay;
    private static double retryBackoffMultiplier;
    private static Option<Object> maxRedirections;
    private static Seq<Credentials> credentials;
    private static Seq<CachePolicy> cachePolicies;
    private static int sslRetryCount;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static volatile int bitmap$0;

    static {
        checksums = new .colon.colon((Object)new Some((Object)"SHA-1"), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$));
        bufferSize = 0x100000;
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 1) == 0) {
                location = CacheEnv$.MODULE$.defaultCacheLocation(CacheEnv$.MODULE$.cache().read()).toFile();
                bitmap$0 |= 1;
            }
        }
        return location;
    }

    public File location() {
        if ((bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return location;
    }

    private File archiveCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 2) == 0) {
                archiveCacheLocation = CacheEnv$.MODULE$.defaultArchiveCacheLocation(CacheEnv$.MODULE$.archiveCache().read()).toFile();
                bitmap$0 |= 2;
            }
        }
        return archiveCacheLocation;
    }

    public File archiveCacheLocation() {
        if ((bitmap$0 & 2) == 0) {
            return this.archiveCacheLocation$lzycompute();
        }
        return archiveCacheLocation;
    }

    private File priviledgedArchiveCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 4) == 0) {
                priviledgedArchiveCacheLocation = CachePath.defaultPriviledgedArchiveCacheDirectory();
                bitmap$0 |= 4;
            }
        }
        return priviledgedArchiveCacheLocation;
    }

    public File priviledgedArchiveCacheLocation() {
        if ((bitmap$0 & 4) == 0) {
            return this.priviledgedArchiveCacheLocation$lzycompute();
        }
        return priviledgedArchiveCacheLocation;
    }

    private File digestBasedCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 8) == 0) {
                digestBasedCacheLocation = CachePath.defaultDigestBasedCacheDirectory();
                bitmap$0 |= 8;
            }
        }
        return digestBasedCacheLocation;
    }

    public File digestBasedCacheLocation() {
        if ((bitmap$0 & 8) == 0) {
            return this.digestBasedCacheLocation$lzycompute();
        }
        return digestBasedCacheLocation;
    }

    public void warnLegacyCacheLocation() {
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x10) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.parallel-download-count").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 |= 0x10;
            }
        }
        return concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x20) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 |= 0x20;
            }
        }
        return pool;
    }

    public ExecutorService pool() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.pool$lzycompute();
        }
        return pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        return CacheEnv$.MODULE$.parseDuration(s);
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x40) == 0) {
                ttl = CacheEnv$.MODULE$.defaultTtl(CacheEnv$.MODULE$.ttl().read());
                bitmap$0 |= 0x40;
            }
        }
        return ttl;
    }

    public Option<Duration> ttl() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.ttl$lzycompute();
        }
        return ttl;
    }

    public Seq<Option<String>> checksums() {
        return checksums;
    }

    public int defaultRetryCount() {
        return 5;
    }

    private FiniteDuration defaultRetryBackoffInitialDelay() {
        return new package.DurationInt(package$.MODULE$.DurationInt(10)).milliseconds();
    }

    private double defaultRetryBackoffMultiplier() {
        return 2.0;
    }

    private int retryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x80) == 0) {
                retryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.exception-retry").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.defaultRetryCount()));
                bitmap$0 |= 0x80;
            }
        }
        return retryCount;
    }

    public int retryCount() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.retryCount$lzycompute();
        }
        return retryCount;
    }

    private FiniteDuration retryBackoffInitialDelay$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x100) == 0) {
                retryBackoffInitialDelay = (FiniteDuration)scala.sys.package$.MODULE$.props().get("coursier.exception-retry-backoff-initial-delay").flatMap((Function1 & Serializable)s -> MODULE$.parseDuration((String)s).toOption()).collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FiniteDuration) {
                            FiniteDuration finiteDuration = (FiniteDuration)A1;
                            return (B1)finiteDuration;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Duration x1) {
                        Duration duration = x1;
                        return duration instanceof FiniteDuration;
                    }
                }).getOrElse((Function0 & Serializable)() -> MODULE$.defaultRetryBackoffInitialDelay());
                bitmap$0 |= 0x100;
            }
        }
        return retryBackoffInitialDelay;
    }

    public FiniteDuration retryBackoffInitialDelay() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.retryBackoffInitialDelay$lzycompute();
        }
        return retryBackoffInitialDelay;
    }

    private double retryBackoffMultiplier$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x200) == 0) {
                retryBackoffMultiplier = BoxesRunTime.unboxToDouble((Object)scala.sys.package$.MODULE$.props().get("coursier.exception-retry-backoff-multiplier").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$2 -> x$2 > 0.0).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> MODULE$.defaultRetryBackoffMultiplier()));
                bitmap$0 |= 0x200;
            }
        }
        return retryBackoffMultiplier;
    }

    public double retryBackoffMultiplier() {
        if ((bitmap$0 & 0x200) == 0) {
            return this.retryBackoffMultiplier$lzycompute();
        }
        return retryBackoffMultiplier;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x2000) == 0) {
                sslRetryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.sslexception-retry").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.retryCount()));
                bitmap$0 |= 0x2000;
            }
        }
        return sslRetryCount;
    }

    public int sslRetryCount() {
        if ((bitmap$0 & 0x2000) == 0) {
            return this.sslRetryCount$lzycompute();
        }
        return sslRetryCount;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x400) == 0) {
                maxRedirections = CacheDefaults$.prop$1("coursier.http.maxRedirects").orElse((Function0 & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0 & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 |= 0x400;
            }
        }
        return maxRedirections;
    }

    public Option<Object> maxRedirections() {
        if ((bitmap$0 & 0x400) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return maxRedirections;
    }

    public int bufferSize() {
        return bufferSize;
    }

    private Seq<Credentials> credentials$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x800) == 0) {
                credentials = CacheEnv$.MODULE$.defaultCredentials(CacheEnv$.MODULE$.credentials().read(), CacheEnv$.MODULE$.scalaCliConfig().read(), CacheEnv$.MODULE$.configDir().read());
                bitmap$0 |= 0x800;
            }
        }
        return credentials;
    }

    public Seq<Credentials> credentials() {
        if ((bitmap$0 & 0x800) == 0) {
            return this.credentials$lzycompute();
        }
        return credentials;
    }

    public Seq<Credentials> credentialsFromConfig(Path configPath) {
        return CacheEnv$.MODULE$.credentialsFromConfig(configPath);
    }

    public Seq<CachePolicy> noEnvCachePolicies() {
        return CacheEnv$.MODULE$.noEnvCachePolicies();
    }

    private Seq<CachePolicy> cachePolicies$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x1000) == 0) {
                cachePolicies = CacheEnv$.MODULE$.defaultCachePolicies(CacheEnv$.MODULE$.cachePolicy().read());
                bitmap$0 |= 0x1000;
            }
        }
        return cachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        if ((bitmap$0 & 0x1000) == 0) {
            return this.cachePolicies$lzycompute();
        }
        return cachePolicies;
    }

    private static final Option prop$1(String name) {
        return scala.sys.package$.MODULE$.props().get(name).flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 >= 0);
    }

    private CacheDefaults$() {
    }
}

