/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.CachePolicy;
import coursier.cache.CachePolicy$FetchMissing$;
import coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursier.credentials.Credentials;
import coursier.credentials.DirectCredentials$;
import coursier.credentials.FileCredentials$;
import coursier.credentials.Password$;
import coursier.parse.CachePolicyParser$;
import coursier.parse.CredentialsParser$;
import coursier.paths.CoursierPaths;
import coursier.util.EnvEntry;
import coursier.util.EnvValues;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.cli.config.ConfigDb;
import scala.cli.config.ConfigDb$;
import scala.cli.config.Key;
import scala.cli.config.Keys$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CacheEnv$ {
    public static final CacheEnv$ MODULE$ = new CacheEnv$();
    private static final EnvEntry cache = new EnvEntry("COURSIER_CACHE", "coursier.cache");
    private static final EnvEntry archiveCache = new EnvEntry("COURSIER_ARCHIVE_CACHE", "coursier.archive.cache");
    private static final EnvEntry credentials = new EnvEntry("COURSIER_CREDENTIALS", "coursier.credentials");
    private static final EnvEntry scalaCliConfig = new EnvEntry("SCALA_CLI_CONFIG", "scala-cli.config");
    private static final EnvEntry ttl = new EnvEntry("COURSIER_TTL", "coursier.ttl");
    private static final EnvEntry cachePolicy = new EnvEntry("COURSIER_MODE", "coursier.mode");
    private static final EnvEntry configDir = new EnvEntry("COURSIER_CONFIG_DIR", "coursier.config-dir");
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies = new .colon.colon((Object)CachePolicy$LocalUpdateChanging$.MODULE$, (List)new .colon.colon((Object)CachePolicy$FetchMissing$.MODULE$, (List)Nil$.MODULE$));

    public EnvEntry cache() {
        return cache;
    }

    public EnvEntry archiveCache() {
        return archiveCache;
    }

    public EnvEntry credentials() {
        return credentials;
    }

    public EnvEntry scalaCliConfig() {
        return scalaCliConfig;
    }

    public EnvEntry ttl() {
        return ttl;
    }

    public EnvEntry cachePolicy() {
        return cachePolicy;
    }

    public EnvEntry configDir() {
        return configDir;
    }

    public Path defaultCacheLocation(EnvValues values) {
        return Paths.get(CoursierPaths.computeCacheDirectoryFrom((String)((String)values.env().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)values.prop().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)"v1"), new String[0]);
    }

    public Path defaultArchiveCacheLocation(EnvValues values) {
        return Paths.get(CoursierPaths.computeCacheDirectoryFrom((String)((String)values.env().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)values.prop().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)"arc"), new String[0]);
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> defaultCredentials(EnvValues credentialsValues, EnvValues scalaCliConfig, EnvValues configDirValues) {
        Seq seq;
        Option credentialPropOpt = credentialsValues.env().orElse((Function0 & Serializable)() -> credentialsValues.prop()).map((Function1 & Serializable)s -> StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1))))));
        if (credentialPropOpt.isEmpty()) {
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])CoursierPaths.configDirectories((String)((String)configDirValues.env().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)configDirValues.prop().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1 & Serializable)configDir -> new File((File)configDir, "credentials.properties"));
            Seq dirs = (Seq)configDirs.map((Function1 & Serializable)configDir -> new File((File)configDir, "credentials"));
            Seq files = (Seq)dirs.flatMap((Function1 & Serializable)dir2 -> {
                File[] listOrNull = dir2.listFiles((dir, name) -> !name.startsWith(".") && name.endsWith(".properties"));
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)listOrNull)).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            });
            Seq otherFiles = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true));
            seq = (Seq)((IterableOps)mainCredentialsFiles.map((Function1 & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true))).$plus$plus((IterableOnce)otherFiles);
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(credentialPropOpt).toSeq().flatMap((Function1 & Serializable)x0$1 -> {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    return new .colon.colon((Object)FileCredentials$.MODULE$.apply(path0, true), (List)Nil$.MODULE$);
                }
                return (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            });
        }
        Seq legacyCredentials = seq;
        Seq<Path> configPaths = this.defaultConfFiles(scalaCliConfig);
        Seq configCredentials = (Seq)configPaths.flatMap((Function1 & Serializable)configPath -> MODULE$.credentialsFromConfig((Path)configPath));
        return (Seq)configCredentials.$plus$plus((IterableOnce)legacyCredentials);
    }

    public Seq<Credentials> credentialsFromConfig(Path configPath) {
        ConfigDb configDb = (ConfigDb)ConfigDb$.MODULE$.open(configPath).fold((Function1 & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1 & Serializable)x -> (ConfigDb)Predef$.MODULE$.identity(x));
        return (Seq)configDb.get((Key)Keys$.MODULE$.repositoryCredentials()).fold((Function1 & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1 & Serializable)x$2 -> ((List)x$2.getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable)c -> DirectCredentials$.MODULE$.apply(c.host(), c.user().map((Function1 & Serializable)x$3 -> (String)x$3.get().value()), c.password().map((Function1 & Serializable)p -> Password$.MODULE$.apply(p.get().value())), c.realm(), BoxesRunTime.unboxToBoolean((Object)c.optional().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultOptional())), BoxesRunTime.unboxToBoolean((Object)c.matchHost().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultMatchHost())), BoxesRunTime.unboxToBoolean((Object)c.httpsOnly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultHttpsOnly())), BoxesRunTime.unboxToBoolean((Object)c.passOnRedirect().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultPassOnRedirect())))));
    }

    public Seq<Path> defaultConfFiles(EnvValues values) {
        return new .colon.colon((Object)CoursierPaths.scalaConfigFile((String)((String)values.env().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)values.prop().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (List)Nil$.MODULE$);
    }

    public Option<Duration> defaultTtl(EnvValues values) {
        Option fromEnv = values.env().flatMap((Function1 & Serializable)x$4 -> MODULE$.parseDuration((String)x$4).toOption());
        return fromEnv.orElse((Function0 & Serializable)() -> CacheEnv$.fromProps$1(values)).orElse((Function0 & Serializable)() -> new Some((Object)CacheEnv$.default$1()));
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheEnv$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar((Object)x$6))))) {
            return new Right((Object)Duration$.MODULE$.Zero());
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Duration$.MODULE$.apply(s));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Duration s2 = (Duration)success.value();
            return new Right((Object)s2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return new Left((Object)t);
        }
        throw new MatchError((Object)try_);
    }

    public Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public Seq<CachePolicy> defaultCachePolicies(EnvValues values) {
        Option fromEnv = CacheEnv$.fromOption$1(values.env(), new StringBuilder(21).append(this.cachePolicy().envName()).append(" environment variable").toString());
        return (Seq)fromEnv.orElse((Function0 & Serializable)() -> this.fromProps$2(values)).getOrElse((Function0 & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    private static final Option fromProps$1(EnvValues values$1) {
        return values$1.prop().flatMap((Function1 & Serializable)x$5 -> MODULE$.parseDuration((String)x$5).toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours();
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$6) {
        return x$6 == '0';
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7)))).flatMap((Function1 & Serializable)str -> {
            boolean bl = false;
            Right right = null;
            Either either = CachePolicyParser$.MODULE$.cachePolicies((String)str, (Seq<CachePolicy>)MODULE$.noEnvCachePolicies()).either();
            if (either instanceof Right) {
                SeqOps seqOps;
                bl = true;
                right = (Right)either;
                Seq seq = (Seq)right.value();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                return new Some((Object)policies);
            }
            if (either instanceof Left) {
                Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        });
    }

    private final Option fromProps$2(EnvValues values$2) {
        return CacheEnv$.fromOption$1(values$2.prop(), new StringBuilder(14).append("Java property ").append(this.cachePolicy().propName()).toString());
    }

    private CacheEnv$() {
    }
}

