/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.EitherT;
import coursier.util.EitherT$;
import coursier.util.Monad;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.apache.tika.Tika;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001B\u00181\u0005UB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\u0007\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0007A!b\u0001\n\u0003a\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011E\u0004!Q1A\u0005\u0002ID\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tw\u0002\u0011)\u0019!C\u0002y\"I\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\tI\u0001\u0001C\u0001\u00037Aq!!\u0003\u0001\t\u0003\t9\u0003\u0003\u0004\u00020\u0001!I\u0001 \u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u0017\u0001\t\u0003\t)\b\u0003\u0005\u0002\u0004\u0002!\t\u0001MAC\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tY\r\u0001C!\u0003\u001bDq!a5\u0001\t\u0003\n)\u000eC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\ti\u0010\u0001C!\u0003\u007f<qAa\u00011\u0011\u0003\u0011)A\u0002\u00040a!\u0005!q\u0001\u0005\b\u0003\u0013\u0019C\u0011\u0001B\u0007\u0011\u001d\u0011ya\tC\u0001\u0005#A\u0011Ba\n$#\u0003%\tA!\u000b\t\u000f\t=3\u0005\"\u0001\u0003R!I!qM\u0012\u0012\u0002\u0013\u0005!\u0011\u000e\u0005\b\u0005c\u001aC\u0011\u0002B:\u0011\u001d\u0011yh\tC\u0005\u0005\u0003CqAa\u0004$\t\u0003\u0011y\tC\u0004\u0003\u0010\r\"\tA!*\t\u000f\t=1\u0005\"\u0001\u0003B\"I!q\\\u0012\u0002\u0002\u0013%!\u0011\u001d\u0002\r\u0003J\u001c\u0007.\u001b<f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003cI\nQaY1dQ\u0016T\u0011aM\u0001\tG>,(o]5fe\u000e\u0001QC\u0001\u001c_'\u0011\u0001q'\u0010!\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g!\tAd(\u0003\u0002@s\t9\u0001K]8ek\u000e$\bCA!J\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002Fi\u00051AH]8pizJ\u0011AO\u0005\u0003\u0011f\nq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001*O\u0001\tY>\u001c\u0017\r^5p]V\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011\u0011n\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0003GS2,\u0017!\u00037pG\u0006$\u0018n\u001c8!+\u0005A\u0006cA-[96\t\u0001'\u0003\u0002\\a\t)1)Y2iKB\u0011QL\u0018\u0007\u0001\t\u0015y\u0006A1\u0001a\u0005\u00051UCA1i#\t\u0011W\r\u0005\u00029G&\u0011A-\u000f\u0002\b\u001d>$\b.\u001b8h!\tAd-\u0003\u0002hs\t\u0019\u0011I\\=\u0005\u000b%t&\u0019A1\u0003\t}#C%M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0015Ut\u0017I]2iSZ,'/F\u0001n!\tIf.\u0003\u0002pa\tQQK\\!sG\"Lg/\u001a:\u0002\u0017Ut\u0017I]2iSZ,'\u000fI\u0001\u000b_B,gn\u0015;sK\u0006lW#A:\u0011\u0005Q<hBA-v\u0013\t1\b'\u0001\u0006V]\u0006\u00138\r[5wKJL!\u0001_=\u0003\u0015=\u0003XM\\*ue\u0016\fWN\u0003\u0002wa\u0005Yq\u000e]3o'R\u0014X-Y7!\u0003\u0011\u0019\u0018P\\2\u0016\u0003u\u0004BA`A\u000296\tqPC\u0002\u0002\u0002I\nA!\u001e;jY&\u0019\u0011QA@\u0003\tMKhnY\u0001\u0006gft7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u00111CA\u000b\u0003/\tI\u0002\u0006\u0003\u0002\u0010\u0005E\u0001cA-\u00019\")1p\u0003a\u0002{\")Aj\u0003a\u0001\u001d\")\u0011g\u0003a\u00011\")1n\u0003a\u0001[\")\u0011o\u0003a\u0001gRA\u0011QDA\u0011\u0003G\t)\u0003\u0006\u0003\u0002\u0010\u0005}\u0001\"B>\r\u0001\bi\b\"\u0002'\r\u0001\u0004q\u0005\"B\u0019\r\u0001\u0004A\u0006\"B6\r\u0001\u0004iG\u0003BA\u0015\u0003[!B!a\u0004\u0002,!)10\u0004a\u0002{\")A*\u0004a\u0001\u001d\u0006\t1+\u0001\u0005m_\u000e\fG\u000eR5s)\u0011\t)$!\u0015\u0011\ra\n9DTA\u001e\u0013\r\tI$\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005\u000bi$!\u0011\n\u0007\u0005}2JA\u0002TKF\u0004B!a\u0011\u0002L9!\u0011QIA$!\t\u0019\u0015(C\u0002\u0002Je\na\u0001\u0015:fI\u00164\u0017\u0002BA'\u0003\u001f\u0012aa\u0015;sS:<'bAA%s!9\u00111K\bA\u0002\u0005U\u0013\u0001C1si&4\u0017m\u0019;\u0011\u0007y\f9&C\u0002\u0002Z}\u0014\u0001\"\u0011:uS\u001a\f7\r^\u0001\fO\u0016$\u0018JZ#ySN$8\u000f\u0006\u0003\u0002`\u0005M\u0004\u0003B/_\u0003C\u0002r!QA2\u0003O\ni'C\u0002\u0002f-\u0013a!R5uQ\u0016\u0014\bcA-\u0002j%\u0019\u00111\u000e\u0019\u0003\u001b\u0005\u0013H/\u001b4bGR,%O]8s!\u0011A\u0014q\u000e(\n\u0007\u0005E\u0014H\u0001\u0004PaRLwN\u001c\u0005\b\u0003'\u0002\u0002\u0019AA+)\u0019\ty&a\u001e\u0002z!9\u00111K\tA\u0002\u0005U\u0003bBA>#\u0001\u0007\u0011QP\u0001\rSN\u001c\u0016N\\4mK\u001aKG.\u001a\t\u0004q\u0005}\u0014bAAAs\t9!i\\8mK\u0006t\u0017\u0001B4fiB\"\u0002\"a\"\u0002\f\u0006=\u0015Q\u0013\t\u0005;z\u000bI\t\u0005\u0004B\u0003G\n9G\u0014\u0005\u0007\u0003\u001b\u0013\u0002\u0019\u0001(\u0002\u0007\u0011L'\u000fC\u0004\u0002\u0012J\u0001\r!a%\u0002\rU\u0014Hn\u00149u!\u0015A\u0014qNA!\u0011\u001d\t9J\u0005a\u0001\u0003\u000f\u000b\u0001\u0002Z8x]2|\u0017\rZ\u0001\u0004O\u0016$H\u0003BAD\u0003;Cq!a\u0015\u0014\u0001\u0004\t)&\u0001\u0007xSRDGj\\2bi&|g\u000e\u0006\u0003\u0002\u0010\u0005\r\u0006\"\u0002'\u0015\u0001\u0004q\u0015!C<ji\"\u001c\u0015m\u00195f)\u0011\ty!!+\t\u000bE*\u0002\u0019\u0001-\u0002\u001d]LG\u000f[+o\u0003J\u001c\u0007.\u001b<feR!\u0011qBAX\u0011\u0015Yg\u00031\u0001n\u000399\u0018\u000e\u001e5Pa\u0016t7\u000b\u001e:fC6$B!a\u0004\u00026\")\u0011o\u0006a\u0001g\u0006Aq/\u001b;i'ft7\r\u0006\u0003\u0002\u0010\u0005m\u0006\"B>\u0019\u0001\u0004i\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0007\u0003BAb\u0003\u0013l!!!2\u000b\u0007\u0005\u001d'+\u0001\u0003mC:<\u0017\u0002BA'\u0003\u000b\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\ny\r\u0003\u0004\u0002Rj\u0001\r!Z\u0001\u0004_\nT\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002~\u0005]\u0007BBAi7\u0001\u0007Q-\u0001\u0005iCND7i\u001c3f)\t\ti\u000eE\u00029\u0003?L1!!9:\u0005\rIe\u000e^\u0001\u0006iV\u0004H.Z\u000b\u0003\u0003O\u0004\u0002\u0002OAu\u001dbk7/`\u0005\u0004\u0003WL$A\u0002+va2,W'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!8\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q-!?\t\u000f\u0005m\b\u00051\u0001\u0002^\u0006\ta.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAa\u0005\u0003Aq!a?\"\u0001\u0004\ti.\u0001\u0007Be\u000eD\u0017N^3DC\u000eDW\r\u0005\u0002ZGM!1e\u000eB\u0005!\ry%1B\u0005\u0003\u0015B#\"A!\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\tM!1\u0004\u000b\u0003\u0005+!BAa\u0006\u0003$A!\u0011\f\u0001B\r!\ri&1\u0004\u0003\u0007?\u0016\u0012\rA!\b\u0016\u0007\u0005\u0014y\u0002B\u0004\u0003\"\tm!\u0019A1\u0003\t}#CE\r\u0005\n\u0003_)\u0003\u0013!a\u0002\u0005K\u0001RA`A\u0002\u00053\tq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0005\u0005W\u0011I\u0005\u0006\u0002\u0003.)\"!q\u0006B\u001c!\u0015q\u00181\u0001B\u0019!\rq(1G\u0005\u0004\u0005ky(\u0001\u0002+bg.\\#A!\u000f\u0011\t\tm\"QI\u0007\u0003\u0005{QAAa\u0010\u0003B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0007J\u0014AC1o]>$\u0018\r^5p]&!!q\tB\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007?\u001a\u0012\rAa\u0013\u0016\u0007\u0005\u0014i\u0005B\u0004\u0003\"\t%#\u0019A1\u0002\u0017A\u0014\u0018N^5mK\u0012<W\rZ\u000b\u0005\u0005'\u0012Y\u0006\u0006\u0002\u0003VQ!!q\u000bB2!\u0011I\u0006A!\u0017\u0011\u0007u\u0013Y\u0006\u0002\u0004`O\t\u0007!QL\u000b\u0004C\n}Ca\u0002B1\u00057\u0012\r!\u0019\u0002\u0005?\u0012\"3\u0007C\u0005\u00020\u001d\u0002\n\u0011q\u0001\u0003fA)a0a\u0001\u0003Z\u0005)\u0002O]5wS2,GmZ3eI\u0011,g-Y;mi\u0012\nT\u0003\u0002B\u0016\u0005W\"aa\u0018\u0015C\u0002\t5TcA1\u0003p\u00119!\u0011\rB6\u0005\u0004\t\u0017a\u00043fY\u0016$XMU3dkJ\u001c\u0018N^3\u0015\t\tU$1\u0010\t\u0004q\t]\u0014b\u0001B=s\t!QK\\5u\u0011\u0019\u0011i(\u000ba\u0001\u001d\u0006\ta-A\u0006be\u000eD\u0017N^3UsB,G\u0003\u0002BB\u0005\u0017\u0003R\u0001OA8\u0005\u000b\u00032!\u0017BD\u0013\r\u0011I\t\r\u0002\f\u0003J\u001c\u0007.\u001b<f)f\u0004X\rC\u0004\u0003\u000e*\u0002\r!!\u0011\u0002\u0007U\u0014H.\u0006\u0003\u0003\u0012\neE\u0003\u0002BJ\u0005G#BA!&\u0003 B!\u0011\f\u0001BL!\ri&\u0011\u0014\u0003\u0007?.\u0012\rAa'\u0016\u0007\u0005\u0014i\n\u0002\u0004j\u00053\u0013\r!\u0019\u0005\u0007w.\u0002\u001dA!)\u0011\u000by\f\u0019Aa&\t\u000b1[\u0003\u0019\u0001(\u0016\t\t\u001d&q\u0016\u000b\t\u0005S\u0013ILa/\u0003@R!!1\u0016B[!\u0011I\u0006A!,\u0011\u0007u\u0013y\u000b\u0002\u0004`Y\t\u0007!\u0011W\u000b\u0004C\nMFAB5\u00030\n\u0007\u0011\r\u0003\u0004|Y\u0001\u000f!q\u0017\t\u0006}\u0006\r!Q\u0016\u0005\u0006\u00192\u0002\rA\u0014\u0005\u0007c1\u0002\rA!0\u0011\teS&Q\u0016\u0005\u0006W2\u0002\r!\\\u000b\u0005\u0005\u0007\u0014Y\r\u0006\u0006\u0003F\nU'q\u001bBn\u0005;$BAa2\u0003RB!\u0011\f\u0001Be!\ri&1\u001a\u0003\u0007?6\u0012\rA!4\u0016\u0007\u0005\u0014y\r\u0002\u0004j\u0005\u0017\u0014\r!\u0019\u0005\u0007w6\u0002\u001dAa5\u0011\u000by\f\u0019A!3\t\u000b1k\u0003\u0019\u0001(\t\rEj\u0003\u0019\u0001Bm!\u0011I&L!3\t\u000b-l\u0003\u0019A7\t\u000bEl\u0003\u0019A:\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\b\u0003BAb\u0005KLAAa:\u0002F\n1qJ\u00196fGR\u0004")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final UnArchiver.OpenStream openStream;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, openStream, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> priviledged$default$1() {
        return ArchiveCache$.MODULE$.priviledged$default$1();
    }

    public static <F> ArchiveCache<F> priviledged(Sync<F> S) {
        return ArchiveCache$.MODULE$.priviledged(S);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public UnArchiver.OpenStream openStream() {
        return this.openStream;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Tuple2<File, Seq<String>> localDir(Artifact artifact) {
        Object object;
        String[] stringArray = artifact.url().split("\\!", -1);
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) < 0) {
            throw new MatchError((Object)stringArray);
        }
        String mainUrl = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Seq subPaths = Array.UnapplySeqWrapper$.MODULE$.drop$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)mainUrl, (Object)subPaths);
        String mainUrl2 = (String)tuple2._1();
        Seq subPaths2 = (Seq)tuple2._2();
        File dir = CachePath.localFile(mainUrl2, this.location(), (String)artifact.authentication().flatMap((Function1 & Serializable)x$2 -> x$2.userOpt()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true);
        return new Tuple2((Object)dir, (Object)subPaths2);
    }

    public F getIfExists(Artifact artifact) {
        Option<ArchiveType> option = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType archiveType0 = (ArchiveType)some.value();
            return this.getIfExists(artifact, archiveType0.singleFile());
        }
        if (None$.MODULE$.equals(option)) {
            return (F)this.S().point(new Left((Object)new ArtifactError.DownloadError(new StringBuilder(39).append("Cannot get archive format from URL for ").append(artifact.url()).toString(), (Option<Throwable>)None$.MODULE$)));
        }
        throw new MatchError(option);
    }

    public F getIfExists(Artifact artifact, boolean isSingleFile) {
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        File dir2 = ((Path)subPaths2.foldLeft((Object)dir02.toPath(), (Function2 & Serializable)(dir, subPath) -> {
            Path f = dir.resolve((String)subPath);
            return f.getParent().resolve(new StringBuilder(1).append(".").append(f.getFileName()).toString());
        })).toFile();
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir2.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$3(dir2, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (isSingleFile) {
            return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right((Object)new Some((Object)f));
                        }
                        return new Right((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return (F)dirTask;
    }

    public F get0(File dir, Option<String> urlOpt, F download) {
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)exists -> ArchiveCache.$anonfun$get0$10(this, download, urlOpt, dir, BoxesRunTime.unboxToBoolean((Object)exists)));
        return (F)Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
            Right right;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                File dir = (File)tuple2._1();
                ArchiveType arcType = (ArchiveType)tuple2._2();
                if (arcType.singleFile()) {
                    return this.S().delay((Function0 & Serializable)() -> {
                        File f;
                        Object object;
                        File[] fileArray = dir.listFiles();
                        return new Right((Object)(fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0 ? (f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0)) : dir));
                    });
                }
            }
            return this.S().point(either.map((Function1 & Serializable)x$5 -> (File)x$5._1()));
        });
    }

    public F get(Artifact artifact) {
        Tuple2<File, Seq<String>> tuple2 = this.localDir(artifact);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File dir0 = (File)tuple2._1();
        Seq subPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dir0, (Object)subPaths);
        File dir02 = (File)tuple22._1();
        Seq subPaths2 = (Seq)tuple22._2();
        Artifact artifact0 = artifact.withUrl(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(artifact.url()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiveCache.$anonfun$get$1(BoxesRunTime.unboxToChar((Object)x$7)))));
        Object download = ((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact0).run(), this.sync());
        Object main = this.get0(dir02, (Option<String>)new Some((Object)artifact0.url()), download);
        return (F)new EitherT(main).flatMap((Function1 & Serializable)dir -> {
            if (subPaths2.isEmpty()) {
                return EitherT$.MODULE$.point(dir, this.sync());
            }
            Seq init = (Seq)subPaths2.init();
            String last = (String)subPaths2.last();
            return this.process$1(dir.toPath(), artifact0.url(), init.toList()).map((Function1 & Serializable)x$8 -> x$8.resolve(last).toFile(), this.sync());
        }, this.sync()).run();
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.openStream(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.openStream(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.openStream(), this.sync());
    }

    public ArchiveCache<F> withOpenStream(UnArchiver.OpenStream openStream) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), openStream, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.openStream()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        UnArchiver.OpenStream openStream = this.openStream();
        UnArchiver.OpenStream openStream2 = other.openStream();
        if (openStream == null) {
            if (openStream2 != null) {
                return false;
            }
        } else if (!openStream.equals(openStream2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash((Object)this.openStream());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple5<File, Cache<F>, UnArchiver, UnArchiver.OpenStream, Sync<F>> tuple() {
        return new Tuple5((Object)this.location(), this.cache(), (Object)this.unArchiver(), (Object)this.openStream(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.openStream();
            }
            case 4: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "openStream";
            }
            case 4: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$3(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return new Right((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return new Right((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Either maybeArchiveType$1(File f, Option urlOpt) {
        return (Either)urlOpt.flatMap((Function1 & Serializable)url -> ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType((String)url)).map((Function1 & Serializable)x$4 -> new Right(x$4)).getOrElse((Function0 & Serializable)() -> {
            Tika tika = new Tika();
            String mimeType = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> tika.detect(is), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            boolean bl = false;
            Some some = null;
            Option<ArchiveType> option = ArchiveType$.MODULE$.fromMimeType(mimeType);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ArchiveType compressed = (ArchiveType)some.value();
                if (compressed instanceof ArchiveType.Compressed) {
                    Some some2;
                    ArchiveType archiveType;
                    ArchiveType.Compressed compressed2 = (ArchiveType.Compressed)compressed;
                    String t0 = (String)Using$.MODULE$.resource((Object)Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1 & Serializable)is -> {
                        Tika tika = new Tika();
                        return tika.detect(this.openStream().inputStream(compressed2, (InputStream)is));
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    Option<ArchiveType> option2 = ArchiveType$.MODULE$.fromMimeType(t0);
                    return new Right((Object)(option2 instanceof Some && ArchiveType$Tar$.MODULE$.equals(archiveType = (ArchiveType)(some2 = (Some)option2).value()) ? compressed2.tar() : compressed2));
                }
            }
            if (bl) {
                ArchiveType tpe = (ArchiveType)some.value();
                return new Right((Object)tpe);
            }
            if (None$.MODULE$.equals(option)) {
                return new Left((Object)new ArtifactError.DownloadError(new StringBuilder(72).append("Cannot detect archive type of ").append(f).append(", or unsupported archive type (MIME type ").append(mimeType).append(")").toString(), (Option<Throwable>)None$.MODULE$));
            }
            throw new MatchError(option);
        });
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, ArchiveType archiveType0, File dir$3) {
        return this.S().delay((Function0 & Serializable)() -> {
            ArchiveType archiveType1 = (ArchiveType)CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (Function0 & Serializable)() -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
                return archiveType0;
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType1));
        });
    }

    public static final /* synthetic */ Object $anonfun$get0$10(ArchiveCache $this, Object download$1, Option urlOpt$1, File dir$3, boolean exists) {
        return Monad.ops$.MODULE$.toAllMonadOps(download$1, $this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return $this.S().point(new Left((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                Either either2 = $this.maybeArchiveType$1(f, urlOpt$1);
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    ArtifactError err = (ArtifactError)left.value();
                    return $this.S().point(new Left((Object)err));
                }
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    ArchiveType archiveType0 = (ArchiveType)right2.value();
                    if (exists) {
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(new Right((Object)new Tuple2((Object)dir$3, (Object)archiveType0)));
                        }
                        return $this.extract$1(f, true, archiveType0, dir$3);
                    }
                    return $this.extract$1(f, false, archiveType0, dir$3);
                }
                throw new MatchError((Object)either2);
            }
            throw new MatchError((Object)either);
        });
    }

    public static final /* synthetic */ boolean $anonfun$get$1(char x$7) {
        return x$7 != '!';
    }

    private final EitherT process$1(Path file, String url, List subPaths0) {
        List list = subPaths0;
        if (Nil$.MODULE$.equals(list)) {
            return EitherT$.MODULE$.point((Object)file, this.sync());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String subPath = (String)colon2.head();
            List rest = colon2.next$access$1();
            Path arc = file.resolve(subPath);
            Path dest = arc.getParent().resolve(new StringBuilder(1).append(".").append(arc.getFileName()).toString());
            String url0 = new StringBuilder(1).append(url).append("!").append(subPath).toString();
            return new EitherT(this.get0(dest.toFile(), (Option<String>)new Some((Object)url0), this.S().point(new Right((Object)arc.toFile())))).flatMap((Function1 & Serializable)dir0 -> this.process$1(dir0.toPath(), url0, rest), this.sync());
        }
        throw new MatchError((Object)list);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.openStream = openStream;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this(location, cache, unArchiver, (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), sync);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), sync);
    }
}

