/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$Ar$;
import coursier.cache.ArchiveType$Gzip$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArchiveType$Tbz2$;
import coursier.cache.ArchiveType$Tgz$;
import coursier.cache.ArchiveType$Txz$;
import coursier.cache.ArchiveType$Tzst$;
import coursier.cache.ArchiveType$Xz$;
import coursier.cache.ArchiveType$Zip$;
import coursier.cache.UnArchiver$;
import coursier.cache.UnArchiver$DefaultUnArchiver$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;
import org.codehaus.plexus.archiver.tar.TarXZUnArchiver;
import org.codehaus.plexus.archiver.tar.TarZstdUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005aa\u0002\u000b\u0016!\u0003\r\nA\u0007\u0005\u0006C\u00011\tAI\u0004\u0006{UA\tA\u0010\u0004\u0006)UA\ta\u0010\u0005\u0006\u0001\u000e!\t!\u0011\u0004\b\u0005\u000e\u0001\n1%\u0001D\u0011\u0015!UA\"\u0001F\r\u0011\u00196A\u0002+\t\u000b\u0001;A\u0011\u0001-\t\u000bi;A\u0011A.\t\u000b\u0005:A\u0011\u00012\t\u000b\u0011;A\u0011A4\u0007\t)\u001caa\u001b\u0005\tY2\u0011\t\u0011)A\u0005u!)\u0001\t\u0004C\u0001[\")\u0011\u0005\u0004C\u0001a\")A\t\u0004C\u0001k\")\u0001p\u0001C\u0001s\")Qp\u0001C\u0001}\")qp\u0001C\u0001}\nQQK\\!sG\"Lg/\u001a:\u000b\u0005Y9\u0012!B2bG\",'\"\u0001\r\u0002\u0011\r|WO]:jKJ\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fq!\u001a=ue\u0006\u001cG\u000fF\u0003$M12\u0004\b\u0005\u0002\u001dI%\u0011Q%\b\u0002\u0005+:LG\u000fC\u0003(\u0003\u0001\u0007\u0001&A\u0006be\u000eD\u0017N^3UsB,\u0007CA\u0015+\u001b\u0005)\u0012BA\u0016\u0016\u0005-\t%o\u00195jm\u0016$\u0016\u0010]3\t\u000b5\n\u0001\u0019\u0001\u0018\u0002\u000f\u0005\u00148\r[5wKB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0003S>T\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t!a)\u001b7f\u0011\u00159\u0014\u00011\u0001/\u0003\u001d!Wm\u001d;ESJDQ!O\u0001A\u0002i\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0005qY\u0014B\u0001\u001f\u001e\u0005\u001d\u0011un\u001c7fC:\f!\"\u00168Be\u000eD\u0017N^3s!\tI3a\u0005\u0002\u00047\u00051A(\u001b8jiz\"\u0012A\u0010\u0002\u000b\u001fB,gn\u0015;sK\u0006l7CA\u0003\u001c\u0003-Ig\u000e];u'R\u0014X-Y7\u0015\u0007\u0019K\u0015\u000b\u0005\u00020\u000f&\u0011\u0001\n\r\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003(\r\u0001\u0007!\n\u0005\u0002L\u001d:\u0011\u0011\u0006T\u0005\u0003\u001bV\t1\"\u0011:dQ&4X\rV=qK&\u0011q\n\u0015\u0002\u000b\u0007>l\u0007O]3tg\u0016$'BA'\u0016\u0011\u0015\u0011f\u00011\u0001G\u0003\tI7OA\tEK\u001a\fW\u000f\u001c;V]\u0006\u00138\r[5wKJ\u001cBaB\u000eV-B\u0011\u0011\u0006\u0001\t\u0003/\u0016i\u0011a\u0001\u000b\u00023B\u0011qkB\u0001\u0012Kb$(/Y2u\u0007>l\u0007O]3tg\u0016$G\u0003\u0002/`A\u0006\u00042\u0001H/$\u0013\tqVDA\u0005Gk:\u001cG/[8oa!)q%\u0003a\u0001\u0015\")Q&\u0003a\u0001]!)q'\u0003a\u0001]Q)1e\u00193fM\")qE\u0003a\u0001Q!)QF\u0003a\u0001]!)qG\u0003a\u0001]!)\u0011H\u0003a\u0001uQ\u0019a\t[5\t\u000b\u001dZ\u0001\u0019\u0001&\t\u000bI[\u0001\u0019\u0001$\u0003%M+Hm\\!cY\u0016,f.\u0011:dQ&4XM]\n\u0005\u0019m)f+A\u0004vg\u0016\u001cV\u000fZ8\u0015\u00059|\u0007CA,\r\u0011\u0015ag\u00021\u0001;)\u0015\u0019\u0013O]:u\u0011\u00159s\u00021\u0001)\u0011\u0015is\u00021\u0001/\u0011\u00159t\u00021\u0001/\u0011\u0015It\u00021\u0001;)\r1eo\u001e\u0005\u0006OA\u0001\rA\u0013\u0005\u0006%B\u0001\rAR\u0001\bI\u00164\u0017-\u001e7u)\u0005Q(cA>V-\u001a!Ap\u0001\u0001{\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003-\u0001(/\u001b<jY\u0016$w-\u001a3\u0015\u0003U\u000b1\u0003\u001d:jm&dW\rZ4fIR+7\u000f^'pI\u0016\u0004")
public interface UnArchiver {
    public static UnArchiver priviledgedTestMode() {
        return UnArchiver$.MODULE$.priviledgedTestMode();
    }

    public static UnArchiver priviledged() {
        return UnArchiver$.MODULE$.priviledged();
    }

    public static UnArchiver default() {
        return UnArchiver$.MODULE$.default();
    }

    public void extract(ArchiveType var1, File var2, File var3, boolean var4);

    private static final class DefaultUnArchiver
    implements UnArchiver,
    OpenStream {
        public Function0<BoxedUnit> extractCompressed(ArchiveType.Compressed archiveType, File archive, File destDir) {
            ArchiveType.Compressed compressed = archiveType;
            if (ArchiveType$Gzip$.MODULE$.equals(compressed)) {
                return (JFunction0.mcV.sp & Serializable)() -> {
                    File dest = new File(destDir, StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(archive.getName()), ".gz"));
                    InputStream fis = null;
                    OutputStream fos = null;
                    GZIPInputStream gzis = null;
                    try {
                        fis = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                        gzis = new GZIPInputStream(fis);
                        fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, (ClassTag)ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = gzis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (gzis != null) {
                            gzis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                };
            }
            if (ArchiveType$Xz$.MODULE$.equals(compressed)) {
                return (JFunction0.mcV.sp & Serializable)() -> {
                    File dest = new File(destDir, StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(archive.getName()), ".xz"));
                    InputStream fis = null;
                    OutputStream fos = null;
                    XZCompressorInputStream xis = null;
                    try {
                        fis = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                        xis = new XZCompressorInputStream(fis);
                        fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, (ClassTag)ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = xis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (xis != null) {
                            xis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                };
            }
            throw new MatchError((Object)compressed);
        }

        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            Left left;
            ArchiveType archiveType2 = archiveType;
            if (archiveType2 instanceof ArchiveType.Compressed) {
                ArchiveType.Compressed compressed = (ArchiveType.Compressed)archiveType2;
                left = new Left(this.extractCompressed(compressed, archive, destDir));
            } else if (ArchiveType$Zip$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new ZipUnArchiver());
            } else if (ArchiveType$Ar$.MODULE$.equals(archiveType2)) {
                AbstractUnArchiver unArc = new AbstractUnArchiver(null){

                    public /* synthetic */ boolean protected$isSelected(DefaultUnArchiver$$anon$1 x$1, String x$12, PlexusIoResource x$2) {
                        return x$1.isSelected(x$12, x$2);
                    }

                    public /* synthetic */ void protected$extractFile(DefaultUnArchiver$$anon$1 x$1, File x$12, File x$2, InputStream x$3, String x$4, Date x$5, boolean x$6, Integer x$7, String x$8, FileMapper[] x$9) {
                        x$1.extractFile(x$12, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
                    }

                    private PlexusIoResource fileInfo(ArArchiveEntry entry) {
                        return new PlexusIoResource(null, entry){
                            private final ArArchiveEntry entry$1;

                            public String getName() {
                                return this.entry$1.getName();
                            }

                            public boolean isSymbolicLink() {
                                return false;
                            }

                            public Nothing$ getContents() {
                                return Predef$.MODULE$.$qmark$qmark$qmark();
                            }

                            public long getLastModified() {
                                return this.entry$1.getLastModified();
                            }

                            public long getSize() {
                                return this.entry$1.getSize();
                            }

                            public Null$ getURL() {
                                return null;
                            }

                            public boolean isDirectory() {
                                return this.entry$1.isDirectory();
                            }

                            public boolean isExisting() {
                                return true;
                            }

                            public boolean isFile() {
                                return !this.isDirectory();
                            }
                            {
                                this.entry$1 = entry$1;
                            }
                        };
                    }

                    public void execute() {
                        this.execute("", this.getDestDirectory());
                    }

                    public void execute(String path, File outputDirectory) {
                        try {
                            Using$.MODULE$.resource((Object)Files.newInputStream(this.getSourceFile().toPath(), new OpenOption[0]), (Function1 & Serializable)fis -> {
                                DefaultUnArchiver$$anon$1.$anonfun$execute$1(this, path, outputDirectory, fis);
                                return BoxedUnit.UNIT;
                            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                        }
                        catch (IOException ex) {
                            throw new ArchiverException(new StringBuilder(22).append("Error while expanding ").append(this.getSourceFile().getAbsolutePath()).toString(), (Throwable)ex);
                        }
                    }

                    public static final /* synthetic */ Integer $anonfun$execute$3(int x) {
                        return Predef$.MODULE$.int2Integer(x);
                    }

                    public static final /* synthetic */ void $anonfun$execute$1(DefaultUnArchiver$$anon$1 $this, String path$1, File outputDirectory$1, InputStream fis) {
                        ArArchiveInputStream ais = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));
                        ArArchiveEntry entry = null;
                        long remainingSpace = Long.MAX_VALUE;
                        while ((entry = ais.getNextEntry()) != null) {
                            if (!entry.getName().startsWith(path$1) || !$this.protected$isSelected($this, entry.getName(), $this.fileInfo(entry))) continue;
                            BoundedInputStream bis = new BoundedInputStream((InputStream)ais, remainingSpace + 1L);
                            CountingInputStream cis = new CountingInputStream((InputStream)bis);
                            $this.protected$extractFile($this, $this.getSourceFile(), outputDirectory$1, (InputStream)cis, entry.getName(), entry.getLastModifiedDate(), entry.isDirectory(), (Integer)new Some((Object)BoxesRunTime.boxToInteger((int)entry.getMode())).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != 0).map((Function1 & Serializable)x -> DefaultUnArchiver$$anon$1.$anonfun$execute$3(BoxesRunTime.unboxToInt((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, $this.getFileMappers());
                            if ((remainingSpace -= cis.getByteCount()) >= 0L) continue;
                            throw new ArchiverException("Maximum output size limit reached");
                        }
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$execute$1$adapted(coursier.cache.UnArchiver$DefaultUnArchiver$$anon$1 java.lang.String java.io.File java.io.InputStream ), $anonfun$execute$2(int ), $anonfun$execute$3$adapted(java.lang.Object )}, serializedLambda);
                    }
                };
                left = new Right((Object)unArc);
            } else if (ArchiveType$Tar$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new TarUnArchiver());
            } else if (ArchiveType$Tgz$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new TarGZipUnArchiver());
            } else if (ArchiveType$Tbz2$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new TarBZip2UnArchiver());
            } else if (ArchiveType$Txz$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new TarXZUnArchiver());
            } else if (ArchiveType$Tzst$.MODULE$.equals(archiveType2)) {
                left = new Right((Object)new TarZstdUnArchiver());
            } else {
                throw new MatchError((Object)archiveType2);
            }
            Left unArchiver = left;
            Files.createDirectories(destDir.toPath(), new FileAttribute[0]);
            Left left2 = unArchiver;
            if (left2 instanceof Left) {
                Left left3 = left2;
                Function0 f = (Function0)left3.value();
                f.apply$mcV$sp();
                return;
            }
            if (left2 instanceof Right) {
                Right right = (Right)left2;
                org.codehaus.plexus.archiver.UnArchiver u = (org.codehaus.plexus.archiver.UnArchiver)right.value();
                u.setOverwrite(false);
                u.setSourceFile(archive);
                u.setDestDirectory(destDir);
                u.extract();
                return;
            }
            throw new MatchError((Object)left2);
        }

        @Override
        public InputStream inputStream(ArchiveType.Compressed archiveType, InputStream is) {
            ArchiveType.Compressed compressed = archiveType;
            if (ArchiveType$Gzip$.MODULE$.equals(compressed)) {
                return new GZIPInputStream(is);
            }
            if (ArchiveType$Xz$.MODULE$.equals(compressed)) {
                return new XZCompressorInputStream(is);
            }
            throw new MatchError((Object)compressed);
        }
    }

    public static interface OpenStream {
        public InputStream inputStream(ArchiveType.Compressed var1, InputStream var2);
    }

    private static final class SudoAbleUnArchiver
    implements UnArchiver,
    OpenStream {
        private final boolean useSudo;

        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            ArchiveType archiveType2 = archiveType;
            if (archiveType2 instanceof ArchiveType.Compressed) {
                ArchiveType.Compressed compressed = (ArchiveType.Compressed)archiveType2;
                Function0<BoxedUnit> proceed = new DefaultUnArchiver().extractCompressed(compressed, archive, destDir);
                Files.createDirectories(destDir.toPath(), new FileAttribute[0]);
                proceed.apply$mcV$sp();
                return;
            }
            if (archiveType2 instanceof ArchiveType.Tar) {
                Tuple2 tuple2;
                ArchiveType.Tar tar = (ArchiveType.Tar)archiveType2;
                ArchiveType.Tar tar2 = tar;
                if (ArchiveType$Tar$.MODULE$.equals(tar2)) {
                    tuple2 = new Tuple2((Object)"", (Object)Nil$.MODULE$);
                } else if (ArchiveType$Tgz$.MODULE$.equals(tar2)) {
                    tuple2 = new Tuple2((Object)"z", (Object)Nil$.MODULE$);
                } else if (ArchiveType$Tbz2$.MODULE$.equals(tar2)) {
                    tuple2 = new Tuple2((Object)"j", (Object)Nil$.MODULE$);
                } else if (ArchiveType$Txz$.MODULE$.equals(tar2)) {
                    tuple2 = new Tuple2((Object)"J", (Object)Nil$.MODULE$);
                } else if (ArchiveType$Tzst$.MODULE$.equals(tar2)) {
                    tuple2 = new Tuple2((Object)"", (Object)new .colon.colon((Object)"--zstd", (List)Nil$.MODULE$));
                } else {
                    throw new MatchError((Object)tar2);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                String compressionOptionOneLetter = (String)tuple22._1();
                scala.collection.immutable.Seq compressionArgs = (scala.collection.immutable.Seq)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)compressionOptionOneLetter, (Object)compressionArgs);
                String compressionOptionOneLetter2 = (String)tuple23._1();
                scala.collection.immutable.Seq compressionArgs2 = (scala.collection.immutable.Seq)tuple23._2();
                Nil$ maybeSudo = this.useSudo ? new .colon.colon((Object)"sudo", (List)Nil$.MODULE$) : Nil$.MODULE$;
                scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)maybeSudo.$plus$plus((IterableOnce)new .colon.colon((Object)"tar", (List)Nil$.MODULE$))).$plus$plus((IterableOnce)compressionArgs2)).$plus$plus((IterableOnce)new .colon.colon((Object)new StringBuilder(3).append("-").append(compressionOptionOneLetter2).append("xf").toString(), (List)new .colon.colon((Object)archive.toString(), (List)Nil$.MODULE$)));
                Files.createDirectories(destDir.toPath(), new FileAttribute[0]);
                Process proc = new ProcessBuilder(new String[0]).command(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)command).asJava()).directory(destDir).inheritIO().start();
                int retCode = proc.waitFor();
                if (retCode != 0) {
                    throw package$.MODULE$.error(new StringBuilder(57).append("Error extracting ").append(archive).append(" under ").append(destDir).append(" (see tar command messages above)").toString());
                }
                return;
            }
            new DefaultUnArchiver().extract(archiveType, archive, destDir, overwrite);
        }

        @Override
        public InputStream inputStream(ArchiveType.Compressed archiveType, InputStream is) {
            return new DefaultUnArchiver().inputStream(archiveType, is);
        }

        public SudoAbleUnArchiver(boolean useSudo) {
            this.useSudo = useSudo;
        }
    }
}

