/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths;

import coursier.jniutils.WindowsEnvironmentVariables;
import io.github.alexarchambault.isterminal.IsTerminal;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern propertyRegex = Pattern.compile(Pattern.quote("${") + "[^" + Pattern.quote("{[()]}") + "]*" + Pattern.quote("}"));
    private static volatile Boolean useColorOutput0 = null;
    private static volatile Boolean useAnsiOutput0 = null;
    private static Boolean useJni0 = null;

    public static Map<String, String> expandProperties(Map<String, String> map) {
        return Util.expandProperties(System.getProperties(), map);
    }

    public static Map<String, String> expandProperties(Properties properties, Map<String, String> map) {
        int n;
        Object object;
        String string;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map.size());
        LinkedHashMap<Object, String> linkedHashMap2 = new LinkedHashMap<Object, String>(map.size());
        for (String string2 : map.keySet()) {
            string = map.get(string2);
            object = string2;
            n = 1;
            if (string2.endsWith("?")) {
                object = string2.substring(0, string2.length() - 1);
                int n2 = n = !properties.containsKey(object) ? 1 : 0;
            }
            if (n == 0) continue;
            Matcher matcher = propertyRegex.matcher(string);
            if (matcher.find()) {
                linkedHashMap2.put(object, string);
                continue;
            }
            linkedHashMap.put((String)object, string);
        }
        for (String string2 : linkedHashMap2.keySet()) {
            string = (String)linkedHashMap2.get(string2);
            object = propertyRegex.matcher(string);
            while (((Matcher)object).find()) {
                int n3;
                n = ((Matcher)object).start(0);
                String string3 = string.substring(n + 2, (n3 = ((Matcher)object).end(0)) - 1);
                String string4 = (String)linkedHashMap.get(string3);
                if (string4 == null) {
                    string4 = properties.getProperty(string3);
                }
                if (string4 == null) {
                    string4 = "";
                }
                string = string.substring(0, n) + string4 + string.substring(n3);
                object = propertyRegex.matcher(string);
            }
            linkedHashMap.put(string2, string);
        }
        return linkedHashMap;
    }

    public static void createDirectories(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    private static boolean computeUseColorOutput() {
        boolean bl;
        if (System.getenv("INSIDE_EMACS") != null) {
            return false;
        }
        String string = System.getenv("COURSIER_PROGRESS");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("1"))) {
            bl = false;
        } else if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disable") || string.equalsIgnoreCase("0"))) {
            bl = true;
        } else {
            boolean bl2 = bl = System.getenv("COURSIER_NO_TERM") != null;
        }
        return !bl;
    }

    public static boolean useColorOutput() {
        if (useColorOutput0 == null) {
            useColorOutput0 = Util.computeUseColorOutput();
        }
        return useColorOutput0;
    }

    private static boolean computeUseAnsiOutput() {
        boolean bl;
        if (!IsTerminal.isTerminal()) {
            return false;
        }
        if (System.getenv("INSIDE_EMACS") != null) {
            return false;
        }
        if (System.getenv("CI") != null) {
            return false;
        }
        String string = System.getenv("COURSIER_PROGRESS");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("1"))) {
            bl = false;
        } else if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disable") || string.equalsIgnoreCase("0"))) {
            bl = true;
        } else {
            boolean bl2 = bl = System.getenv("COURSIER_NO_TERM") != null;
        }
        return !bl;
    }

    public static boolean useAnsiOutput() {
        if (useAnsiOutput0 == null) {
            useAnsiOutput0 = Util.computeUseAnsiOutput();
        }
        return useAnsiOutput0;
    }

    public static boolean useJni() {
        return Util.useJni(() -> {});
    }

    public static boolean useJni(Runnable runnable) {
        boolean bl;
        if (useJni0 != null) {
            return useJni0;
        }
        boolean bl2 = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
        if (!bl2) {
            useJni0 = false;
            return useJni0;
        }
        String string = System.getenv("COURSIER_JNI");
        if (string == null || string.isEmpty()) {
            string = System.getProperty("coursier.jni", "");
        }
        if (bl = string.equalsIgnoreCase("force")) {
            runnable.run();
            useJni0 = true;
            return useJni0;
        }
        boolean bl3 = string.equalsIgnoreCase("false");
        if (bl3) {
            useJni0 = false;
            return useJni0;
        }
        try {
            runnable.run();
            WindowsEnvironmentVariables.get((String)"PATH");
            useJni0 = true;
        }
        catch (Throwable throwable) {
            if (System.getProperty("coursier.jni.check.throw", "").equalsIgnoreCase("true")) {
                throw new RuntimeException(throwable);
            }
            useJni0 = false;
        }
        return useJni0;
    }
}

