/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.Monad;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u0014(\u00051B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\u0006\u0001BC\u0002\u0013\u0005a\n\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q1A\u0005\u0004%D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t!\u001f\u0005\u0006{\u0002!I!\u001b\u0005\u0006}\u0002!Ia \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u000f\u001d\t)j\nE\u0001\u0003/3aAJ\u0014\t\u0002\u0005e\u0005BB9\u001e\t\u0003\ty\nC\u0004\u0002\"v!\t!a)\t\u0013\u0005]V$%A\u0005\u0002\u0005e\u0006bBAp;\u0011%\u0011\u0011\u001d\u0005\b\u0003[lB\u0011BAx\u0011\u001d\t\t+\bC\u0001\u0005\u0013Aq!!)\u001e\t\u0003\u0011y\u0002C\u0005\u0003<u\t\t\u0011\"\u0003\u0003>\ta\u0011I]2iSZ,7)Y2iK*\u0011\u0001&K\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005A1m\\;sg&,'o\u0001\u0001\u0016\u00055*6\u0003\u0002\u0001/i]\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u00186\u0013\t1\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta4&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011q\bM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@a\u0005AAn\\2bi&|g.F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0002j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u0005\u00111\u0015\u000e\\3\u0002\u00131|7-\u0019;j_:\u0004S#A(\u0011\u0007A\u000b6+D\u0001(\u0013\t\u0011vEA\u0003DC\u000eDW\r\u0005\u0002U+2\u0001A!\u0002,\u0001\u0005\u00049&!\u0001$\u0016\u0005a{\u0016CA-]!\ty#,\u0003\u0002\\a\t9aj\u001c;iS:<\u0007CA\u0018^\u0013\tq\u0006GA\u0002B]f$Q\u0001Y+C\u0002a\u0013\u0011aX\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0015Ut\u0017I]2iSZ,'/F\u0001e!\t\u0001V-\u0003\u0002gO\tQQK\\!sG\"Lg/\u001a:\u0002\u0017Ut\u0017I]2iSZ,'\u000fI\u0001\u0005gft7-F\u0001k!\rYgnU\u0007\u0002Y*\u0011Q.K\u0001\u0005kRLG.\u0003\u0002pY\n!1+\u001f8d\u0003\u0015\u0019\u0018P\\2!\u0003\u0019a\u0014N\\5u}Q!1O^<y)\t!X\u000fE\u0002Q\u0001MCQ\u0001[\u0005A\u0004)DQaQ\u0005A\u0002\u0015CQ\u0001K\u0005A\u0002=CQAY\u0005A\u0002\u0011$\"A\u001f?\u0015\u0005Q\\\b\"\u00025\u000b\u0001\bQ\u0007\"B\"\u000b\u0001\u0004)\u0015!A*\u0002\u00111|7-\u00197ESJ$2!RA\u0001\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000b\t\u0001\"\u0019:uS\u001a\f7\r\u001e\t\u0004W\u0006\u001d\u0011bAA\u0005Y\nA\u0011I\u001d;jM\u0006\u001cG/A\u0006hKRLe-\u0012=jgR\u001cH\u0003BA\b\u0003G\u0001B\u0001V+\u0002\u0012A9\u0001(a\u0005\u0002\u0018\u0005u\u0011bAA\u000b\u0005\n1Q)\u001b;iKJ\u00042\u0001UA\r\u0013\r\tYb\n\u0002\u000e\u0003J$\u0018NZ1di\u0016\u0013(o\u001c:\u0011\t=\ny\"R\u0005\u0004\u0003C\u0001$AB(qi&|g\u000eC\u0004\u0002\u00045\u0001\r!!\u0002\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002*\u00055\u0002\u0003\u0002+V\u0003W\u0001b\u0001OA\n\u0003/)\u0005bBA\u0002\u001d\u0001\u0007\u0011QA\u0001\ro&$\b\u000eT8dCRLwN\u001c\u000b\u0004i\u0006M\u0002\"B\"\u0010\u0001\u0004)\u0015!C<ji\"\u001c\u0015m\u00195f)\r!\u0018\u0011\b\u0005\u0006QA\u0001\raT\u0001\u000fo&$\b.\u00168Be\u000eD\u0017N^3s)\r!\u0018q\b\u0005\u0006EF\u0001\r\u0001Z\u0001\to&$\bnU=oGR\u0019A/!\u0012\t\u000b!\u0014\u0002\u0019\u00016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015J\u0003\u0011a\u0017M\\4\n\t\u0005U\u0013q\n\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011\r\fg.R9vC2$B!a\u0017\u0002bA\u0019q&!\u0018\n\u0007\u0005}\u0003GA\u0004C_>dW-\u00198\t\r\u0005\rD\u00031\u0001]\u0003\ry'M[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0013\u0011\u000e\u0005\u0007\u0003G*\u0002\u0019\u0001/\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u001c\u0011\u0007=\n\t(C\u0002\u0002tA\u00121!\u00138u\u0003\u0015!X\u000f\u001d7f+\t\tI\bE\u00040\u0003w*u\n\u001a6\n\u0007\u0005u\u0004G\u0001\u0004UkBdW\rN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA8\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001XAF\u0011\u001d\tiI\u0007a\u0001\u0003_\n\u0011A\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002L\u0005M\u0005bBAG7\u0001\u0007\u0011qN\u0001\r\u0003J\u001c\u0007.\u001b<f\u0007\u0006\u001c\u0007.\u001a\t\u0003!v\u0019B!\b\u0018\u0002\u001cB\u0019a)!(\n\u0005\u0005;ECAAL\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\t)+!,\u0015\u0005\u0005\u001dF\u0003BAU\u0003g\u0003B\u0001\u0015\u0001\u0002,B\u0019A+!,\u0005\rY{\"\u0019AAX+\rA\u0016\u0011\u0017\u0003\u0007A\u00065&\u0019\u0001-\t\u0011u|\u0002\u0013!a\u0002\u0003k\u0003Ba\u001b8\u0002,\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002<\u0006eGCAA_U\u0011\ty,a2\u0011\t-t\u0017\u0011\u0019\t\u0004W\u0006\r\u0017bAAcY\n!A+Y:lW\t\tI\r\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\u0013Ut7\r[3dW\u0016$'bAAja\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0017Q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002,!\u0005\u0004\tY.F\u0002Y\u0003;$a\u0001YAm\u0005\u0004A\u0016a\u00043fY\u0016$XMU3dkJ\u001c\u0018N^3\u0015\t\u0005\r\u0018\u0011\u001e\t\u0004_\u0005\u0015\u0018bAAta\t!QK\\5u\u0011\u0019\tY/\ta\u0001\u000b\u0006\ta-A\u0006be\u000eD\u0017N^3UsB,G\u0003BAy\u0003o\u00042\u0001UAz\u0013\r\t)p\n\u0002\f\u0003J\u001c\u0007.\u001b<f)f\u0004X\rC\u0004\u0002z\n\u0002\r!a?\u0002\u0007U\u0014H\u000e\u0005\u0003\u0002~\n\u0015a\u0002BA\u0000\u0005\u0003\u0001\"A\u000f\u0019\n\u0007\t\r\u0001'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\u00129AC\u0002\u0003\u0004A*BAa\u0003\u0003\u0014Q!!Q\u0002B\u000f)\u0011\u0011yA!\u0007\u0011\tA\u0003!\u0011\u0003\t\u0004)\nMAA\u0002,$\u0005\u0004\u0011)\"F\u0002Y\u0005/!a\u0001\u0019B\n\u0005\u0004A\u0006B\u00025$\u0001\b\u0011Y\u0002\u0005\u0003l]\nE\u0001\"B\"$\u0001\u0004)U\u0003\u0002B\u0011\u0005S!\u0002Ba\t\u00034\tU\"\u0011\b\u000b\u0005\u0005K\u0011y\u0003\u0005\u0003Q\u0001\t\u001d\u0002c\u0001+\u0003*\u00111a\u000b\nb\u0001\u0005W)2\u0001\u0017B\u0017\t\u0019\u0001'\u0011\u0006b\u00011\"1\u0001\u000e\na\u0002\u0005c\u0001Ba\u001b8\u0003(!)1\t\na\u0001\u000b\"1\u0001\u0006\na\u0001\u0005o\u0001B\u0001U)\u0003(!)!\r\na\u0001I\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\b\t\u0005\u0003\u001b\u0012\t%\u0003\u0003\u0003D\u0005=#AB(cU\u0016\u001cG\u000f")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1 & Serializable)x$1 -> x$1.user()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        return (F)(archiveType0.singleFile() ? Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
            Object object;
            Right right;
            Option option;
            Either either = x0$2;
            if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                Some some = (Some)option;
                File dir = (File)some.value();
                object = this.S().delay((Function0 & Serializable)() -> {
                    Right right;
                    Object object;
                    File[] fileArray = dir.listFiles();
                    if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                        File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                        right = package$.MODULE$.Right().apply((Object)new Some((Object)f));
                    } else {
                        right = package$.MODULE$.Right().apply((Object)new Some((Object)dir));
                    }
                    return right;
                });
            } else {
                object = this.S().point(either);
            }
            return object;
        }) : dirTask);
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad.ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Object object;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                object = this.S().point(package$.MODULE$.Left().apply((Object)err));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                object = this.extract$1(f, false, dir, archiveType0);
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        });
        Object dirTask = Monad.ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean((Object)x0$2)));
        return (F)(archiveType0.singleFile() ? Monad.ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$4 -> {
            Object object;
            Either either = x0$4;
            if (either instanceof Right) {
                Right right = (Right)either;
                File dir = (File)right.value();
                object = this.S().delay((Function0 & Serializable)() -> {
                    Right right;
                    Object object;
                    File[] fileArray = dir.listFiles();
                    if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                        File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                        right = package$.MODULE$.Right().apply((Object)f);
                    } else {
                        right = package$.MODULE$.Right().apply((Object)dir);
                    }
                    return right;
                });
            } else {
                object = this.S().point(either);
            }
            return object;
        }) : dirTask);
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple4<File, Cache<F>, UnArchiver, Sync<F>> tuple() {
        return new Tuple4((Object)this.location(), this.cache(), (Object)this.unArchiver(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        Sync<F> sync;
        int n2 = n;
        switch (n2) {
            case 0: {
                sync = this.location();
                break;
            }
            case 1: {
                sync = this.cache();
                break;
            }
            case 2: {
                sync = this.unArchiver();
                break;
            }
            case 3: {
                sync = this.sync();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return sync;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "location";
                break;
            }
            case 1: {
                string = "cache";
                break;
            }
            case 2: {
                string = "unArchiver";
                break;
            }
            case 3: {
                string = "sync";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return string;
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        Right right;
        boolean bl = x0$1;
        if (bl) {
            right = package$.MODULE$.Right().apply((Object)new Some((Object)dir$1));
        } else if (!bl) {
            right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return right;
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0 & Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (JFunction0.mcV.sp & Serializable)() -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return package$.MODULE$.Right().apply((Object)dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        Object object;
        boolean bl = x0$2;
        if (bl) {
            object = artifact$1.changing() ? Monad.ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1 & Serializable)x0$3 -> {
                Object object;
                Either either = x0$3;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ArtifactError err = (ArtifactError)left.value();
                    object = $this.S().point(package$.MODULE$.Left().apply((Object)err));
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    File f = (File)right.value();
                    FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                    FileTime fileTime = archiveLastModifiedTime;
                    FileTime fileTime2 = dirLastModifiedTime;
                    object = !(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null) ? $this.S().point(package$.MODULE$.Right().apply((Object)dir$3)) : $this.extract$1(f, true, dir$3, archiveType0$1);
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            }) : $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
        } else if (!bl) {
            object = downloadAndExtract$1;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return object;
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), sync);
    }
}

