/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.install;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import cats.data.Validated;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.cli.CommandGroup$;
import coursier.cli.Coursier$;
import coursier.cli.CoursierCommand;
import coursier.cli.Util$;
import coursier.cli.Util$ValidatedExitOnError$;
import coursier.cli.channel.Channel$;
import coursier.cli.install.InstallOptions;
import coursier.cli.install.InstallOptions$;
import coursier.cli.install.InstallParams;
import coursier.cli.install.InstallParams$;
import coursier.cli.setup.MaybeSetupPath$;
import coursier.env.ShellUtil$;
import coursier.install.AppInfo;
import coursier.install.Channels;
import coursier.install.Channels$;
import coursier.install.InstallDir;
import coursier.install.error.InstallDirException;
import coursier.paths.Util;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class Install$
extends CoursierCommand<InstallOptions> {
    public static final Install$ MODULE$ = new Install$();

    public String group() {
        return CommandGroup$.MODULE$.install();
    }

    public void run(InstallOptions options, RemainingArgs args) {
        int x$22;
        PrintStream x$1;
        Validated<NonEmptyList<String>, InstallParams> qual$1 = Util$.MODULE$.ValidatedExitOnError(InstallParams$.MODULE$.apply(options, args.all().nonEmpty()));
        InstallParams params = Util$ValidatedExitOnError$.MODULE$.exitOnError$extension(qual$1, x$1 = Util$ValidatedExitOnError$.MODULE$.exitOnError$default$1$extension(qual$1), x$22 = Util$ValidatedExitOnError$.MODULE$.exitOnError$default$2$extension(qual$1));
        if (params.output().verbosity() >= 1) {
            System.err.println(new StringBuilder(24).append("Using install directory ").append(params.shared().dir()).toString());
        }
        if (Files.exists(params.shared().dir(), new LinkOption[0])) {
            if (params.output().verbosity() >= 0 && !Files.isDirectory(params.shared().dir(), new LinkOption[0])) {
                System.err.println(new StringBuilder(40).append("Warning: ").append(params.shared().dir()).append(" doesn't seem to be a directory").toString());
            }
        } else {
            Util.createDirectories((Path)params.shared().dir());
        }
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.cache().parallel());
        FileCache<Task> cache = params.cache().cache(pool, params.output().logger(), params.cache().cache$default$3());
        FileCache<Task> noUpdateCoursierCache = params.cache().cache(pool, params.output().logger(), (Option<Duration>)new Some((Object)Duration$.MODULE$.Inf()));
        Function1 & Serializable graalvmHome = (Function1 & Serializable)version -> new Task(Install$.$anonfun$run$1(params, cache, noUpdateCoursierCache, version));
        InstallDir installDir = params.shared().installDir((Cache<Task>)cache, params.repository().repositories()).withVerbosity(params.output().verbosity()).withNativeImageJavaHome((Option)new Some((Object)graalvmHome));
        if (params.installChannels().nonEmpty()) {
            String progName = Coursier$.MODULE$.progName();
            String options2 = ((IterableOnceOps)params.installChannels().flatMap((Function1 & Serializable)c -> new .colon.colon((Object)"--add", (List)new .colon.colon(c, (List)Nil$.MODULE$)))).mkString(" ");
            System.err.println(new StringBuilder(73).append("Warning: the --add-channel option is deprecated. Use '").append(progName).append(" channel ").append(options2).append("' instead.").toString());
            Channel$.MODULE$.addChannel((List<String>)params.installChannels().toList(), params.output());
            return;
        }
        if (params.env().env()) {
            String script = params.env().windowsScript() ? installDir.envUpdate().batScript() : installDir.envUpdate().bashScript();
            Predef$.MODULE$.println((Object)script);
            return;
        }
        if (params.env().disableEnv()) {
            String dir = ((Object)installDir.baseDir().toAbsolutePath()).toString();
            Option updatedPath = Option$.MODULE$.apply((Object)System.getenv("PATH")).flatMap((Function1 & Serializable)strPath -> {
                String[] path = strPath.split(File.pathSeparator);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])path), (Object)dir)) {
                    return new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])path), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Install$.$anonfun$run$4(dir, x$1)))).mkString(File.pathSeparator));
                }
                return None$.MODULE$;
            });
            String script = (String)updatedPath.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)s -> {
                if (params.env().windowsScript()) {
                    return new StringBuilder(13).append("set \"PATH=").append((String)s).append("\"").append("\r\n").toString();
                }
                return new StringBuilder(15).append("export PATH=\"").append((String)s).append("\"").append("\n").toString();
            });
            Predef$.MODULE$.print((Object)script);
            return;
        }
        if (params.env().setup()) {
            Function1<ExecutionContext, Future<BoxedUnit>> task2 = params.env().setupTask(installDir.envUpdate(), params.env().envVarUpdater(), params.output().verbosity(), MaybeSetupPath$.MODULE$.headerComment());
            Task$.MODULE$.PlatformTaskOps(task2).unsafeRun((ExecutionContext)cache.ec());
            return;
        }
        if (args.all().isEmpty()) {
            if (params.output().verbosity() >= 0 && params.installChannels().isEmpty()) {
                System.err.println("Nothing to install");
            }
            throw package$.MODULE$.exit(0);
        }
        Channels channels = Channels$.MODULE$.apply(params.channels(), params.repository().repositories(), cache).withVerbosity(params.output().verbosity());
        try {
            args.all().foreach((Function1 & Serializable)id -> {
                Install$.$anonfun$run$7(channels, cache, installDir, params, id);
                return BoxedUnit.UNIT;
            });
        }
        catch (InstallDirException e) {
            System.err.println(e.getMessage());
            if (params.output().verbosity() >= 2) {
                throw e;
            }
            throw package$.MODULE$.exit(1);
        }
        if (params.output().verbosity() >= 0) {
            Set path = ((IterableOnceOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)System.getenv("PATH"))).toSeq().flatMap((Function1 & Serializable)x$2 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$2), File.pathSeparatorChar))))).toSet();
            if (!path.apply((Object)((Object)params.shared().dir().toAbsolutePath()).toString())) {
                System.err.println(new StringBuilder(29).append("Warning: ").append(params.shared().dir()).append(" is not in your PATH").toString());
                if (!Properties$.MODULE$.isWin()) {
                    String rcFile = (String)ShellUtil$.MODULE$.rcFileOpt(ShellUtil$.MODULE$.rcFileOpt$default$1()).getOrElse((Function0 & Serializable)() -> "your shell configuration file");
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(97).append("To fix that, add the following line to ").append(rcFile).append("\n                 |\n                 |export PATH=\"$PATH:").append(params.shared().dir().toAbsolutePath()).append("\"").toString())));
                    return;
                }
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ Function1 $anonfun$run$1(InstallParams params$1, FileCache cache$1, FileCache noUpdateCoursierCache$1, String version) {
        return params$1.sharedJava().javaHome((Cache<Task>)cache$1, (Cache<Task>)noUpdateCoursierCache$1, params$1.repository().repositories(), params$1.output().verbosity()).get(new StringBuilder(8).append("graalvm:").append(version).toString());
    }

    public static final /* synthetic */ boolean $anonfun$run$4(String dir$1, String x$1) {
        String string = x$1;
        String string2 = dir$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$run$7(Channels channels$1, FileCache cache$1, InstallDir installDir$1, InstallParams params$1, String id) {
        boolean bl;
        boolean bl2 = false;
        Left left = null;
        Either either = (Either)Task$.MODULE$.PlatformTaskOps(Task$.MODULE$.attempt$extension(channels$1.appDescriptor(id))).unsafeRun((ExecutionContext)cache$1.ec());
        if (either instanceof Left) {
            bl2 = true;
            left = (Left)either;
            Throwable err = (Throwable)left.value();
            if (err instanceof Channels.ChannelsException) {
                Channels.ChannelsException channelsException = (Channels.ChannelsException)err;
                System.err.println(channelsException.getMessage());
                throw package$.MODULE$.exit(1);
            }
        }
        if (bl2) {
            Throwable err = (Throwable)left.value();
            throw err;
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        AppInfo appInfo = (AppInfo)right.value();
        AppInfo appInfo2 = appInfo;
        Option wroteSomethingOpt = installDir$1.createOrUpdate(appInfo2, Instant.now(), params$1.force());
        boolean bl3 = false;
        Some some = null;
        Option option = wroteSomethingOpt;
        if (option instanceof Some) {
            bl3 = true;
            some = (Some)option;
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (bl4) {
                if (params$1.output().verbosity() >= 0) {
                    System.err.println(new StringBuilder(6).append("Wrote ").append(appInfo2.source().id()).toString());
                    return;
                }
                return;
            }
        }
        if (bl3 && !(bl = BoxesRunTime.unboxToBoolean((Object)some.value()))) {
            if (params$1.output().verbosity() >= 1) {
                System.err.println(new StringBuilder(22).append(appInfo2.source().id()).append(" doesn't need updating").toString());
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (params$1.output().verbosity() >= 0) {
                System.err.println(new StringBuilder(49).append("Could not install ").append(appInfo2.source().id()).append(" (concurrent operation ongoing)").toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private Install$() {
        super(InstallOptions$.MODULE$.parser(), InstallOptions$.MODULE$.help());
    }
}

