/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.setup;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import cats.data.Validated;
import coursier.cache.Cache;
import coursier.cache.CacheLogger;
import coursier.cache.FileCache;
import coursier.cli.CommandGroup$;
import coursier.cli.CoursierCommand;
import coursier.cli.Util$;
import coursier.cli.Util$ValidatedExitOnError$;
import coursier.cli.setup.Confirm;
import coursier.cli.setup.Confirm$ConsoleInput$;
import coursier.cli.setup.Confirm$YesToAll$;
import coursier.cli.setup.MaybeInstallApps$;
import coursier.cli.setup.MaybeInstallJvm$;
import coursier.cli.setup.MaybeSetupPath$;
import coursier.cli.setup.SetupOptions;
import coursier.cli.setup.SetupOptions$;
import coursier.cli.setup.SetupParams;
import coursier.cli.setup.SetupParams$;
import coursier.cli.setup.SetupStep;
import coursier.env.EnvironmentUpdate$;
import coursier.env.ProfileUpdater;
import coursier.env.WindowsEnvVarUpdater;
import coursier.install.Channels;
import coursier.install.Channels$;
import coursier.install.InstallDir;
import coursier.install.error.InstallDirException;
import coursier.jvm.JavaHome;
import coursier.jvm.JvmCache;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Either;

public final class Setup$
extends CoursierCommand<SetupOptions> {
    public static final Setup$ MODULE$ = new Setup$();

    public String group() {
        return CommandGroup$.MODULE$.install();
    }

    public void run(SetupOptions options, RemainingArgs args) {
        Function1<ExecutionContext, Future<Object>> function1;
        Validated<NonEmptyList<String>, SetupParams> qual$1 = Util$.MODULE$.ValidatedExitOnError(SetupParams$.MODULE$.apply(options));
        PrintStream x$1 = Util$ValidatedExitOnError$.MODULE$.exitOnError$default$1$extension(qual$1);
        int x$2 = Util$ValidatedExitOnError$.MODULE$.exitOnError$default$2$extension(qual$1);
        SetupParams params = Util$ValidatedExitOnError$.MODULE$.exitOnError$extension(qual$1, x$1, x$2);
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.cache().parallel());
        CacheLogger logger = params.output().logger();
        FileCache<Task> cache = params.cache().cache(pool, logger, params.cache().cache$default$3());
        FileCache<Task> noUpdateCoursierCache = params.cache().cache(pool, params.output().logger(), (Option<Duration>)new Some((Object)Duration$.MODULE$.Inf()));
        JavaHome javaHome = params.sharedJava().javaHome((Cache<Task>)cache, (Cache<Task>)noUpdateCoursierCache, params.repository().repositories(), params.output().verbosity());
        None$ envVarUpdaterOpt = params.env().env() ? None$.MODULE$ : new Some(params.env().envVarUpdater());
        Function1 & Serializable graalvmHome = (Function1 & Serializable)version -> new Task(javaHome.get(new StringBuilder(8).append("graalvm:").append(version).toString()));
        FileCache installCache = cache.withLogger(params.output().logger(true));
        InstallDir installDir = params.sharedInstall().installDir((Cache<Task>)installCache, params.repository().repositories()).withVerbosity(params.output().verbosity()).withNativeImageJavaHome((Option)new Some((Object)graalvmHome));
        Channels channels = Channels$.MODULE$.apply(params.sharedChannel().channels(), params.repository().repositories(), (Cache)installCache).withVerbosity(params.output().verbosity());
        Confirm.YesToAll confirm = params.yes() ? Confirm$YesToAll$.MODULE$.apply() : Confirm$ConsoleInput$.MODULE$.apply().withIndent(2);
        .colon.colon tasks = new .colon.colon((Object)MaybeInstallJvm$.MODULE$.apply((Cache<Task>)cache, (Option<Either<WindowsEnvVarUpdater, ProfileUpdater>>)envVarUpdaterOpt, javaHome, confirm, params.sharedJava().id()), (List)new .colon.colon((Object)MaybeSetupPath$.MODULE$.apply(installDir, (Option<Either<WindowsEnvVarUpdater, ProfileUpdater>>)envVarUpdaterOpt, (Function1<String, Option<String>>)EnvironmentUpdate$.MODULE$.defaultGetEnv(), File.pathSeparator, confirm), (List)new .colon.colon((Object)MaybeInstallApps$.MODULE$.apply(installDir, channels, params.apps()), (List)Nil$.MODULE$)));
        if (params.tryRevert()) {
            String message = "Warning: the --try-revert option is experimental. Keep going only if you know what you are doing.";
            function1 = ((Confirm)confirm).confirm(message, false);
        } else {
            function1 = Task$.MODULE$.point((Object)BoxedUnit.UNIT);
        }
        Function1<ExecutionContext, Future<Object>> init = function1;
        Function1 task2 = ((Task)tasks.foldLeft((Object)new Task(init), (Function2 & Serializable)(acc, step) -> new Task(Setup$.$anonfun$run$2(params, ((Task)acc).value(), step)))).value();
        if (params.banner() && !params.tryRevert()) {
            System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |     ________ ___   / /  ___\n          |    / __/ __// _ | / /  / _ |\n          |  __\\ \\/ /__/ __ |/ /__/ __ |\n          | /____/\\___/_/ |_/____/_/ | |\n          |                          |/\n          |")));
        }
        try {
            Task$.MODULE$.PlatformTaskOps(task2).unsafeRun((ExecutionContext)cache.ec());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InstallDirException) {
                InstallDirException installDirException = (InstallDirException)throwable2;
                if (params.output().verbosity() <= 1) {
                    System.err.println(installDirException.getMessage());
                    throw package$.MODULE$.exit(1);
                }
            }
            if (throwable2 instanceof JvmCache.JvmCacheException) {
                JvmCache.JvmCacheException jvmCacheException = (JvmCache.JvmCacheException)throwable2;
                if (params.output().verbosity() <= 1) {
                    System.err.println(jvmCacheException.getMessage());
                    throw package$.MODULE$.exit(1);
                }
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ Function1 $anonfun$run$2(SetupParams params$1, Function1 acc, Product step) {
        Function1<ExecutionContext, Future<BoxedUnit>> t = params$1.tryRevert() ? ((SetupStep)step).tryRevert() : ((SetupStep)step).fullTask(System.err);
        return Task$.MODULE$.flatMap$extension(acc, (Function1 & Serializable)x$1 -> new Task(t));
    }

    private Setup$() {
        super(SetupOptions$.MODULE$.parser(), SetupOptions$.MODULE$.help());
    }
}

