/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.channel;

import caseapp.core.RemainingArgs;
import cats.data.Validated;
import coursier.cli.CommandGroup$;
import coursier.cli.CoursierCommand;
import coursier.cli.Util$;
import coursier.cli.Util$ValidatedExitOnError$;
import coursier.cli.channel.ChannelOptions;
import coursier.cli.channel.ChannelOptions$;
import coursier.cli.channel.ChannelParam;
import coursier.cli.channel.ChannelParam$;
import coursier.cli.params.OutputParams;
import coursier.paths.CoursierPaths;
import coursier.paths.Util;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Channel$
extends CoursierCommand<ChannelOptions> {
    public static final Channel$ MODULE$ = new Channel$();

    private Channel$() {
        super(ChannelOptions$.MODULE$.parser(), ChannelOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Channel$.class);
    }

    public String group() {
        return CommandGroup$.MODULE$.channel();
    }

    public void run(ChannelOptions options, RemainingArgs args) {
        Validated validated = Util$.MODULE$.ValidatedExitOnError(ChannelParam$.MODULE$.apply(options, args.all().nonEmpty()));
        ChannelParam params = (ChannelParam)Util$ValidatedExitOnError$.MODULE$.exitOnError$extension(validated, Util$ValidatedExitOnError$.MODULE$.exitOnError$default$1$extension(validated), Util$ValidatedExitOnError$.MODULE$.exitOnError$default$2$extension(validated));
        if (params.listChannels()) {
            this.displayChannels();
            return;
        }
        if (params.addChannel().nonEmpty()) {
            this.addChannel(params.addChannel(), params.output());
            return;
        }
    }

    public void displayChannels() {
        File configDir = CoursierPaths.defaultConfigDirectory();
        File channelDir = new File(configDir, "channels");
        Option$.MODULE$.apply((Object)channelDir.listFiles()).foreach((Function1)(JProcedure1 & Serializable)files -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])files);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)file -> StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8))).map((Function1 & Serializable)rawLine -> {
                String line = rawLine.trim();
                return Tuple2$.MODULE$.apply(rawLine, (Object)line);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String rawLine = (String)tuple2._1();
                    String line = (String)tuple2._2();
                    return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line));
                }
                throw new MatchError((Object)tuple2);
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String rawLine = (String)tuple2._1();
                    String line = (String)tuple2._2();
                    System.out.println(line);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
        });
    }

    public Path addChannel(List<String> channels, OutputParams output) {
        File configDir = CoursierPaths.defaultConfigDirectory();
        File channelDir = new File(configDir, "channels");
        File f = (File)package$.MODULE$.Iterator().from(1).map((Function1 & Serializable)n -> Channel$.$anonfun$1(channelDir, BoxesRunTime.unboxToInt((Object)n))).filter((Function1 & Serializable)_$1 -> !_$1.exists()).next();
        if (output.verbosity() >= 1) {
            System.err.println("Writing " + f);
        }
        Util.createDirectories((Path)f.toPath().getParent());
        return Files.write(f.toPath(), channels.map((Function1 & Serializable)_$2 -> _$2 + "\n").mkString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static final /* synthetic */ File $anonfun$1(File channelDir$1, int n) {
        return new File(channelDir$1, "channels-" + n);
    }
}

