/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.docker;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import coursier.cache.CacheLogger;
import coursier.cache.FileCache;
import coursier.cli.CoursierCommand;
import coursier.cli.docker.DockerBuildOptions;
import coursier.cli.docker.DockerBuildOptions$;
import coursier.cli.docker.DockerBuildParams;
import coursier.cli.docker.DockerBuildParams$;
import coursier.docker.DockerBuild$;
import coursier.docker.DockerImageConfig;
import coursier.docker.vm.Vm;
import coursier.docker.vm.Vm$;
import coursier.util.Sync$;
import coursier.util.Task;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathConvertible;
import os.RelPath$;
import os.exists$;
import os.isDir$;
import os.isFile$;
import pprint.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class DockerBuildCommand$
extends CoursierCommand<DockerBuildOptions> {
    public static final DockerBuildCommand$ MODULE$ = new DockerBuildCommand$();

    private DockerBuildCommand$() {
        super(DockerBuildOptions$.MODULE$.parser(), DockerBuildOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DockerBuildCommand$.class);
    }

    public boolean hidden() {
        return !this.experimentalFeatures();
    }

    public List<List<String>> names() {
        return (List)new .colon.colon((Object)((List)new .colon.colon((Object)"docker-build", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)"docker", (List)new .colon.colon((Object)"build", (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
    }

    public void run(DockerBuildOptions options, RemainingArgs args) {
        None$ none$;
        String string;
        SeqOps seqOps;
        block14: {
            Seq seq;
            block13: {
                seq = args.all();
                if (seq == null) break block13;
                seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    System.err.println("No docker context (directory) passed");
                    throw scala.sys.package$.MODULE$.exit(1);
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) break block14;
            }
            Seq other = seq;
            System.err.println("Too many arguments passed as docker context (directory), expected one");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        String arg = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
        String rawContextDir = arg;
        Path contextDir = Path$.MODULE$.apply((Object)rawContextDir, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
        if (!exists$.MODULE$.apply(contextDir)) {
            System.err.println("Error: " + rawContextDir + " not found");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!isDir$.MODULE$.apply(contextDir)) {
            System.err.println("Error: " + rawContextDir + " is not a directory");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Either either = DockerBuildParams$.MODULE$.apply(options).toEither();
        if (either instanceof Left) {
            NonEmptyList errors = (NonEmptyList)((Left)either).value();
            errors.toList().foreach((Function1)(JProcedure1 & Serializable)err -> System.err.println((String)err));
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        DockerBuildParams params0 = (DockerBuildParams)((Right)either).value();
        DockerBuildParams params = params0;
        Path dockerFile = (Path)params.dockerFile().getOrElse(() -> DockerBuildCommand$.$anonfun$2(contextDir));
        if (!exists$.MODULE$.apply(dockerFile)) {
            System.err.println("Error: " + dockerFile + " not found");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!isFile$.MODULE$.apply(dockerFile)) {
            System.err.println("Error: " + dockerFile + " is not a file");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.sharedPullParams().cache().parallel());
        CacheLogger logger = params.sharedPullParams().output().logger();
        FileCache<Task> cache = params.sharedPullParams().cache().cache(pool, logger, params.sharedPullParams().cache().cache$default$3());
        if (Properties$.MODULE$.isLinux()) {
            none$ = None$.MODULE$;
        } else {
            Path vmsDir = Vm$.MODULE$.defaultVmDir();
            Vm vm = Vm$.MODULE$.readFrom(vmsDir, params.sharedVmSelectParams().id());
            none$ = Some$.MODULE$.apply((Object)vm);
        }
        None$ vmOpt = none$;
        Tuple2 tuple2 = DockerBuild$.MODULE$.build(contextDir, (Option)Some$.MODULE$.apply((Object)dockerFile), (Option)vmOpt, params.sharedPullParams().authRegistry(), cache, params.sharedPullParams().os(), params.sharedPullParams().cpu(), params.sharedPullParams().cpuVariant());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DockerImageConfig.Config config = (DockerImageConfig.Config)tuple2._1();
        List layers = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)config, (Object)layers);
        DockerImageConfig.Config config2 = (DockerImageConfig.Config)tuple22._1();
        List layers2 = (List)tuple22._2();
        package$.MODULE$.err().log(Text$.MODULE$.apply((Object)config2, "config"), package$.MODULE$.err().log$default$2(), package$.MODULE$.err().log$default$3(), package$.MODULE$.err().log$default$4(), package$.MODULE$.err().log$default$5(), package$.MODULE$.err().log$default$6(), package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(87), FileName$.MODULE$.apply("DockerBuildCommand.scala"));
        package$.MODULE$.err().log(Text$.MODULE$.apply((Object)layers2, "layers"), package$.MODULE$.err().log$default$2(), package$.MODULE$.err().log$default$3(), package$.MODULE$.err().log$default$4(), package$.MODULE$.err().log$default$5(), package$.MODULE$.err().log$default$6(), package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(88), FileName$.MODULE$.apply("DockerBuildCommand.scala"));
    }

    private static final Path $anonfun$2(Path contextDir$1) {
        return contextDir$1.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"Dockerfile"})));
    }
}

