/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.docker;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveCache$;
import coursier.cache.CacheLogger;
import coursier.cache.FileCache;
import coursier.cli.CoursierCommand;
import coursier.cli.docker.DockerPullOptions;
import coursier.cli.docker.DockerPullOptions$;
import coursier.cli.docker.DockerPullParams;
import coursier.cli.docker.DockerPullParams$;
import coursier.docker.DockerPull;
import coursier.docker.DockerPull$;
import coursier.docker.DockerUnpack$;
import coursier.docker.DockerUtil$;
import coursier.docker.DockerVm$;
import coursier.docker.vm.Vm;
import coursier.docker.vm.Vm$;
import coursier.util.Sync$;
import coursier.util.Task;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import os.Path;
import os.Path$;
import os.PathConvertible;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class DockerPullCommand$
extends CoursierCommand<DockerPullOptions> {
    public static final DockerPullCommand$ MODULE$ = new DockerPullCommand$();

    private DockerPullCommand$() {
        super(DockerPullOptions$.MODULE$.parser(), DockerPullOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DockerPullCommand$.class);
    }

    public boolean hidden() {
        return !this.experimentalFeatures();
    }

    public List<List<String>> names() {
        return (List)new .colon.colon((Object)((List)new .colon.colon((Object)"docker-pull", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)"docker", (List)new .colon.colon((Object)"pull", (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
    }

    public void run(DockerPullOptions options, RemainingArgs args) {
        Either either = DockerPullParams$.MODULE$.apply(options).toEither();
        if (either instanceof Left) {
            NonEmptyList errors = (NonEmptyList)((Left)either).value();
            errors.toList().foreach((Function1)(JProcedure1 & Serializable)err -> System.err.println((String)err));
            throw package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        DockerPullParams params0 = (DockerPullParams)((Right)either).value();
        DockerPullParams params = params0;
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.sharedPullParams().cache().parallel());
        CacheLogger logger = params.sharedPullParams().output().logger();
        FileCache<Task> cache = params.sharedPullParams().cache().cache(pool, logger, params.sharedPullParams().cache().cache$default$3());
        Tuple2 tuple2 = DockerUtil$.MODULE$.repoNameVersion(args.all());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String repoName = (String)tuple2._1();
        String repoVersion = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)repoName, (Object)repoVersion);
        String repoName2 = (String)tuple22._1();
        String repoVersion2 = (String)tuple22._2();
        DockerPull.Result dockerPullResults = DockerPull$.MODULE$.pull(repoName2, repoVersion2, params.sharedPullParams().os(), params.sharedPullParams().cpu(), params.sharedPullParams().cpuVariant(), params.sharedPullParams().authRegistry(), cache);
        if (Properties$.MODULE$.isLinux()) {
            ArchiveCache priviledgedArchiveCache = ArchiveCache$.MODULE$.priviledged(ArchiveCache$.MODULE$.priviledged$default$1());
            Seq layerDirs = DockerUnpack$.MODULE$.unpack(priviledgedArchiveCache, dockerPullResults.layerArtifacts());
            System.err.println(layerDirs.length() + " unpacked layers");
            return;
        }
        Path vmsDir = Vm$.MODULE$.defaultVmDir();
        Vm vm = Vm$.MODULE$.readFrom(vmsDir, params.sharedVmSelectParams().id());
        vm.withSession((Function1)(JProcedure1 & Serializable)session -> DockerVm$.MODULE$.pullContainer(vm.params().hostWorkDir(), cache, (Seq)dockerPullResults.layerFiles().map((Function1 & Serializable)_$1 -> Path$.MODULE$.apply(_$1, (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$)), vm, session, DockerVm$.MODULE$.pullContainer$default$6()));
    }
}

