/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.get;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveCache$;
import coursier.cache.ArtifactError;
import coursier.cache.FileCache;
import coursier.cli.CoursierCommand;
import coursier.cli.get.GetOptions;
import coursier.cli.get.GetOptions$;
import coursier.cli.get.GetParams;
import coursier.cli.get.GetParams$;
import coursier.core.Authentication$;
import coursier.util.Artifact;
import coursier.util.Artifact$;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Get$
extends CoursierCommand<GetOptions> {
    public static final Get$ MODULE$ = new Get$();

    private Get$() {
        super(GetOptions$.MODULE$.parser(), GetOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Get$.class);
    }

    public boolean hidden() {
        return true;
    }

    public void run(GetOptions options, RemainingArgs args) {
        Either either = GetParams$.MODULE$.apply(options).toEither();
        if (either instanceof Left) {
            NonEmptyList errors = (NonEmptyList)((Left)either).value();
            errors.toList().foreach((Function1)(JProcedure1 & Serializable)e -> System.err.println((String)e));
            throw package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        GetParams p = (GetParams)((Right)either).value();
        GetParams params = p;
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.cache().parallel());
        FileCache<Task> cache = params.cache().cache(pool, params.output().logger(), params.cache().cache$default$3());
        ArchiveCache archiveCache = ArchiveCache$.MODULE$.apply(params.archiveCacheLocation(), Task$.MODULE$.sync()).withCache(cache);
        Seq artifacts = (Seq)args.all().map((Function1 & Serializable)rawUrl -> {
            ObjectRef artifact = ObjectRef.create((Object)Artifact$.MODULE$.fromUrl(rawUrl));
            params.changing().foreach((Function1 & Serializable)v1 -> {
                artifact.elem = ((Artifact)artifact.elem).withChanging(BoxesRunTime.unboxToBoolean((Object)v1));
                return BoxedUnit.UNIT;
            });
            if (params.authHeaders().nonEmpty()) {
                artifact.elem = ((Artifact)artifact.elem).withAuthentication((Option)Some$.MODULE$.apply((Object)Authentication$.MODULE$.apply(params.authHeaders())));
            }
            return (Artifact)artifact.elem;
        });
        if (artifacts.isEmpty()) {
            System.err.println("Warning: no URL passed");
        }
        BooleanRef anyError = BooleanRef.create((boolean)false);
        Seq fetchAll = (Seq)artifacts.map((Function1 & Serializable)artifact -> new Task(Get$.$anonfun$3(params, archiveCache, cache, artifact)));
        Function1 initLogger = Task$.MODULE$.delay((Function0 & Serializable)() -> {
            Get$.$anonfun$5(cache);
            return BoxedUnit.UNIT;
        });
        Function1 stopLogger = Task$.MODULE$.delay((Function0 & Serializable)() -> {
            Get$.$anonfun$6(cache);
            return BoxedUnit.UNIT;
        });
        Function1 task = Task$.MODULE$.flatMap$extension(initLogger, (Function1 & Serializable)x$1 -> new Task(this.$anonfun$7(fetchAll, stopLogger, anyError, params, (BoxedUnit)x$1)));
        ExecutionContextExecutorService ec = ExecutionContext$.MODULE$.fromExecutorService(pool);
        Task$.MODULE$.PlatformTaskOps(task).unsafeRun(true, (ExecutionContext)ec);
        if (anyError.elem) {
            throw package$.MODULE$.exit(1);
        }
    }

    private static final boolean $anonfun$4(Artifact artifact$2) {
        return artifact$2.url().contains("!");
    }

    private static final /* synthetic */ Function1 $anonfun$3(GetParams params$2, ArchiveCache archiveCache$1, FileCache cache$1, Artifact artifact) {
        boolean isArchive = BoxesRunTime.unboxToBoolean((Object)params$2.archiveOpt().getOrElse(() -> Get$.$anonfun$4(artifact)));
        if (isArchive) {
            Object object = archiveCache$1.get(artifact);
            if (object == null) {
                return null;
            }
            return ((Task)object).value();
        }
        Object object = cache$1.file(artifact).run();
        if (object == null) {
            return null;
        }
        return ((Task)object).value();
    }

    private static final void $anonfun$5(FileCache cache$2) {
        cache$2.logger().init(cache$2.logger().init$default$1());
    }

    private static final void $anonfun$6(FileCache cache$3) {
        cache$3.logger().stop();
    }

    private final /* synthetic */ Function1 $anonfun$7$$anonfun$1$$anonfun$1(Either a$1, BooleanRef anyError$3, GetParams params$5, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Function1 function1 = Task$.MODULE$.fromEither(a$1);
        return Task$.MODULE$.map$extension(function1, (Function1)(JProcedure1 & Serializable)pathsOrErrors -> {
            Iterator errorsIt = pathsOrErrors.iterator().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x) {
                    Either either = x;
                    if (either instanceof Left) {
                        ArtifactError e = (ArtifactError)((Left)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x, Function1 function1) {
                    Either either = x;
                    if (either instanceof Left) {
                        ArtifactError e = (ArtifactError)((Left)either).value();
                        return e;
                    }
                    return function1.apply((Object)x);
                }
            });
            anyError$4.elem = errorsIt.hasNext();
            if (!anyError$4.elem || params$5.force()) {
                Iterator pathsIt = pathsOrErrors.iterator().collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Either x) {
                        Either either = x;
                        if (either instanceof Right) {
                            File p = (File)((Right)either).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Either x, Function1 function1) {
                        Either either = x;
                        if (either instanceof Right) {
                            File p = (File)((Right)either).value();
                            return p;
                        }
                        return function1.apply((Object)x);
                    }
                });
                String output = pathsIt.mkString(params$5.separator());
                Predef$.MODULE$.println((Object)output);
            }
            errorsIt.foreach((Function1)(JProcedure1 & Serializable)err -> {
                if (params$5.output().verbosity() == 0) {
                    System.err.println(err.getMessage());
                    return;
                }
                if (params$5.output().verbosity() >= 1) {
                    throw err;
                }
            });
        });
    }

    private final /* synthetic */ Function1 $anonfun$7$$anonfun$1(Function1 stopLogger$2, BooleanRef anyError$2, GetParams params$4, Either a) {
        return Task$.MODULE$.flatMap$extension(stopLogger$2, (Function1 & Serializable)x$1 -> new Task(this.$anonfun$7$$anonfun$1$$anonfun$1(a, anyError$2, params$4, (BoxedUnit)x$1)));
    }

    private final /* synthetic */ Function1 $anonfun$7(Seq fetchAll$1, Function1 stopLogger$1, BooleanRef anyError$1, GetParams params$3, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Object object = Task$.MODULE$.gather().gather(fetchAll$1);
        Function1 function1 = object == null ? null : ((Task)object).value();
        Function1 function12 = new Task(Task$.MODULE$.attempt$extension(function1)).value();
        return Task$.MODULE$.flatMap$extension(function12, (Function1 & Serializable)a -> new Task(this.$anonfun$7$$anonfun$1(stopLogger$1, anyError$1, params$3, (Either)a)));
    }
}

