/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.install;

import caseapp.core.RemainingArgs;
import cats.data.Validated;
import coursier.cache.Cache;
import coursier.cli.CommandGroup$;
import coursier.cli.CoursierCommand;
import coursier.cli.Util$;
import coursier.cli.Util$ValidatedExitOnError$;
import coursier.cli.install.NoopCache;
import coursier.cli.install.UninstallOptions;
import coursier.cli.install.UninstallOptions$;
import coursier.cli.install.UninstallParams;
import coursier.cli.install.UninstallParams$;
import coursier.install.InstallDir;
import coursier.install.InstallDir$;
import coursier.install.error.InstallDirException;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;

public final class Uninstall$
extends CoursierCommand<UninstallOptions> {
    public static final Uninstall$ MODULE$ = new Uninstall$();

    private Uninstall$() {
        super(UninstallOptions$.MODULE$.parser(), UninstallOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Uninstall$.class);
    }

    public String group() {
        return CommandGroup$.MODULE$.install();
    }

    public void run(UninstallOptions options, RemainingArgs args) {
        Seq list;
        Validated validated = Util$.MODULE$.ValidatedExitOnError(UninstallParams$.MODULE$.apply(options));
        UninstallParams params = (UninstallParams)Util$ValidatedExitOnError$.MODULE$.exitOnError$extension(validated, Util$ValidatedExitOnError$.MODULE$.exitOnError$default$1$extension(validated), Util$ValidatedExitOnError$.MODULE$.exitOnError$default$2$extension(validated));
        Seq args0 = args.all();
        if (args0.isEmpty() && !params.all()) {
            System.err.println("Error: no application to uninstall or --all specified.");
            throw package$.MODULE$.exit(1);
        }
        if (args0.nonEmpty() && params.all()) {
            System.err.println("Error: cannot pass applications to uninstall along with --all");
            throw package$.MODULE$.exit(1);
        }
        if (params.verbosity() >= 1) {
            System.err.println("Using install directory " + params.dir());
        }
        InstallDir installDir = InstallDir$.MODULE$.apply(params.dir(), (Cache)new NoopCache()).withVerbosity(params.verbosity());
        Seq seq = list = params.all() ? installDir.list() : args0;
        if (list.isEmpty()) {
            if (params.verbosity() >= 0) {
                System.err.println("Nothing to remove");
                return;
            }
            return;
        }
        list.foreach((Function1)(JProcedure1 & Serializable)app -> {
            Option resOpt;
            Option option;
            try {
                option = installDir.delete(app);
            }
            catch (Throwable throwable) {
                Nothing$ nothing$;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InstallDirException) {
                    InstallDirException e = (InstallDirException)throwable2;
                    if (params.verbosity() <= 1) {
                        System.err.println(e.getMessage());
                        nothing$ = package$.MODULE$.exit(1);
                        throw nothing$;
                    }
                }
                if (!(throwable2 instanceof FileNotFoundException)) {
                    if (!(throwable2 instanceof NoSuchFileException)) throw throwable;
                }
                System.err.println(app + " is not installed by coursier");
                nothing$ = package$.MODULE$.exit(1);
                throw nothing$;
            }
            Option option2 = resOpt = option;
            if (None$.MODULE$.equals(option2)) {
                if (params.verbosity() < 0) return;
                System.err.println("Could not uninstall " + app + " (concurrent operation ongoing)");
                return;
            }
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            boolean bl = BoxesRunTime.unboxToBoolean((Object)((Some)option2).value());
            if (bl) {
                if (params.verbosity() < 0) return;
                System.err.println("Uninstalled " + app);
                return;
            }
            if (false != bl) throw new MatchError((Object)option2);
            if (params.verbosity() < 1) return;
            System.err.println("Nothing to uninstall for " + app);
        });
    }
}

