/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.params;

import coursier.cache.Cache;
import coursier.cache.CacheLogger;
import coursier.cache.CachePolicy;
import coursier.cache.FileCache;
import coursier.cache.FileCache$;
import coursier.cli.params.CacheParams$;
import coursier.credentials.Credentials;
import coursier.internal.InMemoryCache;
import coursier.internal.InMemoryCache$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class CacheParams
implements Product,
Serializable {
    private final File cacheLocation;
    private final Seq cachePolicies;
    private final Option ttl;
    private final int parallel;
    private final Seq checksum;
    private final int retryCount;
    private final boolean cacheLocalArtifacts;
    private final boolean followHttpToHttpsRedirections;
    private final Seq credentials;
    private final boolean useEnvCredentials;

    public static CacheParams apply(File file, Seq<CachePolicy> seq, Option<Duration> option, int n, Seq<Option<String>> seq2, int n2, boolean bl, boolean bl2, Seq<Credentials> seq3, boolean bl3) {
        return CacheParams$.MODULE$.apply(file, seq, option, n, seq2, n2, bl, bl2, seq3, bl3);
    }

    public static CacheParams fromProduct(Product product) {
        return CacheParams$.MODULE$.fromProduct(product);
    }

    public static CacheParams unapply(CacheParams cacheParams) {
        return CacheParams$.MODULE$.unapply(cacheParams);
    }

    public static Seq<Credentials> $lessinit$greater$default$9() {
        return CacheParams$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean $lessinit$greater$default$10() {
        return CacheParams$.MODULE$.$lessinit$greater$default$10();
    }

    public CacheParams(File cacheLocation, Seq<CachePolicy> cachePolicies, Option<Duration> ttl, int parallel, Seq<Option<String>> checksum, int retryCount, boolean cacheLocalArtifacts, boolean followHttpToHttpsRedirections, Seq<Credentials> credentials, boolean useEnvCredentials) {
        this.cacheLocation = cacheLocation;
        this.cachePolicies = cachePolicies;
        this.ttl = ttl;
        this.parallel = parallel;
        this.checksum = checksum;
        this.retryCount = retryCount;
        this.cacheLocalArtifacts = cacheLocalArtifacts;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.credentials = credentials;
        this.useEnvCredentials = useEnvCredentials;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cacheLocation()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.cachePolicies()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.ttl()));
        n = Statics.mix((int)n, (int)this.parallel());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.checksum()));
        n = Statics.mix((int)n, (int)this.retryCount());
        n = Statics.mix((int)n, (int)(this.cacheLocalArtifacts() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.followHttpToHttpsRedirections() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.credentials()));
        n = Statics.mix((int)n, (int)(this.useEnvCredentials() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CacheParams)) return false;
        CacheParams cacheParams = (CacheParams)object;
        if (this.parallel() != cacheParams.parallel()) return false;
        if (this.retryCount() != cacheParams.retryCount()) return false;
        if (this.cacheLocalArtifacts() != cacheParams.cacheLocalArtifacts()) return false;
        if (this.followHttpToHttpsRedirections() != cacheParams.followHttpToHttpsRedirections()) return false;
        if (this.useEnvCredentials() != cacheParams.useEnvCredentials()) return false;
        File file = this.cacheLocation();
        File file2 = cacheParams.cacheLocation();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<CachePolicy> seq = this.cachePolicies();
        Seq<CachePolicy> seq2 = cacheParams.cachePolicies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = cacheParams.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Option<String>> seq3 = this.checksum();
        Seq<Option<String>> seq4 = cacheParams.checksum();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Credentials> seq5 = this.credentials();
        Seq<Credentials> seq6 = cacheParams.credentials();
        if (seq5 == null) {
            if (seq6 == null) return true;
            return false;
        } else {
            if (!seq5.equals(seq6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CacheParams;
    }

    public int productArity() {
        return 10;
    }

    public String productPrefix() {
        return "CacheParams";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this._8());
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return BoxesRunTime.boxToBoolean((boolean)this._10());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "cacheLocation";
            }
            case 1: {
                return "cachePolicies";
            }
            case 2: {
                return "ttl";
            }
            case 3: {
                return "parallel";
            }
            case 4: {
                return "checksum";
            }
            case 5: {
                return "retryCount";
            }
            case 6: {
                return "cacheLocalArtifacts";
            }
            case 7: {
                return "followHttpToHttpsRedirections";
            }
            case 8: {
                return "credentials";
            }
            case 9: {
                return "useEnvCredentials";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public File cacheLocation() {
        return this.cacheLocation;
    }

    public Seq<CachePolicy> cachePolicies() {
        return this.cachePolicies;
    }

    public Option<Duration> ttl() {
        return this.ttl;
    }

    public int parallel() {
        return this.parallel;
    }

    public Seq<Option<String>> checksum() {
        return this.checksum;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public boolean cacheLocalArtifacts() {
        return this.cacheLocalArtifacts;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public Seq<Credentials> credentials() {
        return this.credentials;
    }

    public boolean useEnvCredentials() {
        return this.useEnvCredentials;
    }

    public CacheParams withCacheLocation(File cacheLocation) {
        return this.copy(cacheLocation, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withCachePolicies(Seq<CachePolicy> cachePolicies) {
        return this.copy(this.copy$default$1(), cachePolicies, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withTtl(Option<Duration> ttl) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), ttl, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withTtl(Duration ttl) {
        Option option = Option$.MODULE$.apply((Object)ttl);
        File file = this.copy$default$1();
        Seq<CachePolicy> seq = this.copy$default$2();
        int n = this.copy$default$4();
        Seq<Option<String>> seq2 = this.copy$default$5();
        int n2 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Seq<Credentials> seq3 = this.copy$default$9();
        boolean bl3 = this.copy$default$10();
        return this.copy(file, seq, (Option<Duration>)option, n, seq2, n2, bl, bl2, seq3, bl3);
    }

    public CacheParams withParallel(int parallel) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), parallel, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withChecksum(Seq<Option<String>> checksum) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), checksum, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withRetryCount(int retryCount) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), retryCount, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withCacheLocalArtifacts(boolean cacheLocalArtifacts) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), cacheLocalArtifacts, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withFollowHttpToHttpsRedirections(boolean followHttpToHttpsRedirections) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), followHttpToHttpsRedirections, this.copy$default$9(), this.copy$default$10());
    }

    public CacheParams withCredentials(Seq<Credentials> credentials) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), credentials, this.copy$default$10());
    }

    public CacheParams withUseEnvCredentials(boolean useEnvCredentials) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), useEnvCredentials);
    }

    public FileCache<Task> cache(ExecutorService pool, CacheLogger logger, Option<Duration> overrideTtl) {
        FileCache c = FileCache$.MODULE$.apply(Task$.MODULE$.sync()).withLocation(this.cacheLocation()).withCachePolicies(this.cachePolicies()).withChecksums(this.checksum()).withLogger(logger).withPool(pool).withTtl(overrideTtl.orElse(this::$anonfun$1)).withRetry(this.retryCount()).withFollowHttpToHttpsRedirections(this.followHttpToHttpsRedirections()).withLocalArtifactsShouldBeCached(this.cacheLocalArtifacts());
        if (!this.useEnvCredentials()) {
            c = c.withCredentials((Seq)package$.MODULE$.Nil());
        }
        c = c.addCredentials(this.credentials());
        return c;
    }

    public Option<Duration> cache$default$3() {
        return None$.MODULE$;
    }

    public Cache<Task> cache(ExecutorService pool, CacheLogger logger, boolean inMemoryCache) {
        InMemoryCache c = this.cache(pool, logger, this.cache$default$3());
        return (Cache)(inMemoryCache ? InMemoryCache$.MODULE$.apply(c, Task$.MODULE$.sync()) : c);
    }

    public CacheParams copy(File cacheLocation, Seq<CachePolicy> cachePolicies, Option<Duration> ttl, int parallel, Seq<Option<String>> checksum, int retryCount, boolean cacheLocalArtifacts, boolean followHttpToHttpsRedirections, Seq<Credentials> credentials, boolean useEnvCredentials) {
        return new CacheParams(cacheLocation, cachePolicies, ttl, parallel, checksum, retryCount, cacheLocalArtifacts, followHttpToHttpsRedirections, credentials, useEnvCredentials);
    }

    public File copy$default$1() {
        return this.cacheLocation();
    }

    public Seq<CachePolicy> copy$default$2() {
        return this.cachePolicies();
    }

    public Option<Duration> copy$default$3() {
        return this.ttl();
    }

    public int copy$default$4() {
        return this.parallel();
    }

    public Seq<Option<String>> copy$default$5() {
        return this.checksum();
    }

    public int copy$default$6() {
        return this.retryCount();
    }

    public boolean copy$default$7() {
        return this.cacheLocalArtifacts();
    }

    public boolean copy$default$8() {
        return this.followHttpToHttpsRedirections();
    }

    public Seq<Credentials> copy$default$9() {
        return this.credentials();
    }

    public boolean copy$default$10() {
        return this.useEnvCredentials();
    }

    public File _1() {
        return this.cacheLocation();
    }

    public Seq<CachePolicy> _2() {
        return this.cachePolicies();
    }

    public Option<Duration> _3() {
        return this.ttl();
    }

    public int _4() {
        return this.parallel();
    }

    public Seq<Option<String>> _5() {
        return this.checksum();
    }

    public int _6() {
        return this.retryCount();
    }

    public boolean _7() {
        return this.cacheLocalArtifacts();
    }

    public boolean _8() {
        return this.followHttpToHttpsRedirections();
    }

    public Seq<Credentials> _9() {
        return this.credentials();
    }

    public boolean _10() {
        return this.useEnvCredentials();
    }

    private final Option $anonfun$1() {
        return this.ttl();
    }
}

