/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.resolve;

import cats.Applicative;
import cats.FlatMap;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import coursier.cli.resolve.ResolveException;
import coursier.cli.resolve.ResolveException$;
import coursier.core.Dependency;
import coursier.core.MinimizedExclusions$;
import coursier.core.Module;
import coursier.core.ModuleName;
import coursier.core.Organization;
import coursier.parse.DependencyParser$;
import coursier.parse.JavaOrScalaDependency;
import coursier.parse.JavaOrScalaModule;
import coursier.version.Version;
import coursier.version.Version$;
import coursier.version.VersionInterval;
import coursier.version.VersionInterval$;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Dependencies$
implements Serializable {
    public static final Dependencies$ MODULE$ = new Dependencies$();

    private Dependencies$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Dependencies$.class);
    }

    public Validated<NonEmptyList<String>, List<Tuple2<JavaOrScalaDependency, Map<String, String>>>> handleDependencies(Seq<String> rawDependencies) {
        return (Validated)implicits$.MODULE$.toTraverseOps((Object)((IterableOnceOps)rawDependencies.map((Function1 & Serializable)s -> {
            Either either = DependencyParser$.MODULE$.javaOrScalaDependencyParams(s);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return Validated$.MODULE$.invalidNel((Object)error);
            }
            if (either instanceof Right) {
                Tuple2 d = (Tuple2)((Right)either).value();
                return Validated$.MODULE$.validNel((Object)new .colon.colon((Object)d, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)either);
        })).toList(), implicits$.MODULE$.catsStdInstancesForList()).flatSequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (FlatMap)implicits$.MODULE$.catsStdInstancesForList());
    }

    public Either<Throwable, Tuple2<List<JavaOrScalaDependency>, Map<Tuple2<JavaOrScalaModule, Version>, URL>>> withExtraRepo(Seq<String> rawDependencies, Seq<Tuple2<JavaOrScalaDependency, Map<String, String>>> extraDependencies) {
        Validated<NonEmptyList<String>, List<Tuple2<JavaOrScalaDependency, Map<String, String>>>> validated = this.handleDependencies(rawDependencies);
        if (validated instanceof Validated.Valid) {
            List l = (List)((Validated.Valid)validated).a();
            List l0 = (List)l.$plus$plus(extraDependencies);
            List deps = l0.map((Function1 & Serializable)_$1 -> (JavaOrScalaDependency)_$1._1());
            Map extraRepo = l0.flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    JavaOrScalaDependency dep = (JavaOrScalaDependency)tuple2._1();
                    Map extraParams = (Map)tuple2._2();
                    return extraParams.get((Object)"url").map((Function1 & Serializable)url -> {
                        VersionInterval versionInterval = dep.versionConstraint().interval();
                        VersionInterval versionInterval2 = VersionInterval$.MODULE$.zero();
                        if ((versionInterval != null ? !versionInterval.equals(versionInterval2) : versionInterval2 != null) || dep.versionConstraint().latest().nonEmpty()) {
                            throw scala.sys.package$.MODULE$.error("Invalid version " + dep.versionConstraint().asString() + ": expected simple version like 1.2.3, not an interval or latest.*");
                        }
                        Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)Tuple2$.MODULE$.apply((Object)dep.module(), dep.versionConstraint().preferred().getOrElse(Dependencies$::$anonfun$2$$anonfun$1$$anonfun$1)));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple2, (Object)new URL(URLDecoder.decode(url, "UTF-8")));
                    });
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)deps, (Object)extraRepo));
        }
        if (validated instanceof Validated.Invalid) {
            NonEmptyList err = (NonEmptyList)((Validated.Invalid)validated).e();
            return package$.MODULE$.Left().apply((Object)new ResolveException("Error processing dependencies:" + System.lineSeparator() + err.toList().map((Function1 & Serializable)_$2 -> "  " + _$2).mkString(System.lineSeparator()), ResolveException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError(validated);
    }

    public Dependency addExclusions(Dependency dep, Map<Module, Set<Module>> perModuleExclude) {
        Option option = perModuleExclude.get((Object)dep.module());
        if (None$.MODULE$.equals(option)) {
            return dep;
        }
        if (option instanceof Some) {
            Set exclusions = (Set)((Some)option).value();
            return dep.withMinimizedExclusions(dep.minimizedExclusions().join(MinimizedExclusions$.MODULE$.apply((Set)exclusions.map((Function1 & Serializable)m -> Tuple2$.MODULE$.apply((Object)new Organization(m.organization()), (Object)new ModuleName(m.name()))))));
        }
        throw new MatchError((Object)option);
    }

    public Seq<Dependency> addExclusions(Seq<Dependency> deps, Map<Module, Set<Module>> perModuleExclude) {
        return (Seq)deps.map((Function1 & Serializable)dep -> MODULE$.addExclusions((Dependency)dep, perModuleExclude));
    }

    private static final Version $anonfun$2$$anonfun$1$$anonfun$1() {
        return Version$.MODULE$.zero();
    }
}

