/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.install;

import caseapp.core.RemainingArgs;
import cats.data.Validated;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.cli.CommandGroup$;
import coursier.cli.Coursier$;
import coursier.cli.CoursierCommand;
import coursier.cli.Util$;
import coursier.cli.Util$ValidatedExitOnError$;
import coursier.cli.channel.Channel$;
import coursier.cli.install.InstallOptions;
import coursier.cli.install.InstallOptions$;
import coursier.cli.install.InstallParams;
import coursier.cli.install.InstallParams$;
import coursier.cli.setup.MaybeSetupPath$;
import coursier.env.ShellUtil$;
import coursier.install.AppInfo;
import coursier.install.Channels;
import coursier.install.Channels$;
import coursier.install.InstallDir;
import coursier.install.error.InstallDirException;
import coursier.paths.Util;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class Install$
extends CoursierCommand<InstallOptions> {
    public static final Install$ MODULE$ = new Install$();

    private Install$() {
        super(InstallOptions$.MODULE$.parser(), InstallOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Install$.class);
    }

    public String group() {
        return CommandGroup$.MODULE$.install();
    }

    public void run(InstallOptions options, RemainingArgs args) {
        Validated validated = Util$.MODULE$.ValidatedExitOnError(InstallParams$.MODULE$.apply(options, args.all().nonEmpty()));
        InstallParams params = (InstallParams)Util$ValidatedExitOnError$.MODULE$.exitOnError$extension(validated, Util$ValidatedExitOnError$.MODULE$.exitOnError$default$1$extension(validated), Util$ValidatedExitOnError$.MODULE$.exitOnError$default$2$extension(validated));
        if (params.output().verbosity() >= 1) {
            System.err.println(new StringBuilder(24).append("Using install directory ").append(params.shared().dir()).toString());
        }
        if (Files.exists(params.shared().dir(), new LinkOption[0])) {
            if (params.output().verbosity() >= 0 && !Files.isDirectory(params.shared().dir(), new LinkOption[0])) {
                System.err.println(new StringBuilder(40).append("Warning: ").append(params.shared().dir()).append(" doesn't seem to be a directory").toString());
            }
        } else {
            Util.createDirectories((Path)params.shared().dir());
        }
        ExecutorService pool = Sync$.MODULE$.fixedThreadPool(params.cache().parallel());
        FileCache<Task> cache = params.cache().cache(pool, params.output().logger(), params.cache().cache$default$3());
        FileCache<Task> noUpdateCoursierCache = params.cache().cache(pool, params.output().logger(), (Option<Duration>)Some$.MODULE$.apply((Object)Duration$.MODULE$.Inf()));
        Function1 & Serializable graalvmHome = (Function1 & Serializable)version -> new Task(Install$.$anonfun$1(params, cache, noUpdateCoursierCache, version));
        InstallDir installDir = params.shared().installDir((Cache<Task>)cache, params.repository().repositories()).withVerbosity(params.output().verbosity()).withNativeImageJavaHome((Option)Some$.MODULE$.apply((Object)graalvmHome));
        if (params.installChannels().nonEmpty()) {
            String progName = Coursier$.MODULE$.progName();
            String options2 = ((IterableOnceOps)params.installChannels().flatMap((Function1 & Serializable)c -> (SeqOps)new .colon.colon((Object)"--add", (List)new .colon.colon(c, (List)Nil$.MODULE$)))).mkString(" ");
            System.err.println(new StringBuilder(73).append("Warning: the --add-channel option is deprecated. Use '").append(progName).append(" channel ").append(options2).append("' instead.").toString());
            Channel$.MODULE$.addChannel((List<String>)params.installChannels().toList(), params.output());
            return;
        }
        if (params.env().env()) {
            String script = params.env().windowsScript() ? installDir.envUpdate().batScript() : installDir.envUpdate().bashScript();
            Predef$.MODULE$.println((Object)script);
            return;
        }
        if (params.env().disableEnv()) {
            String dir = installDir.baseDir().toAbsolutePath().toString();
            Option updatedPath = Option$.MODULE$.apply((Object)System.getenv("PATH")).flatMap((Function1 & Serializable)strPath -> {
                Object[] path = strPath.split(File.pathSeparator);
                Object object = Predef$.MODULE$.refArrayOps(path);
                if (ArrayOps$.MODULE$.contains$extension(object, (Object)dir)) {
                    Object object2 = Predef$.MODULE$.refArrayOps(path);
                    return Some$.MODULE$.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$1 -> {
                        String string = _$1;
                        String string2 = dir;
                        return string == null ? string2 != null : !string.equals(string2);
                    })).mkString(File.pathSeparator));
                }
                return None$.MODULE$;
            });
            String script = (String)updatedPath.fold(Install$::$anonfun$4, (Function1 & Serializable)s -> {
                if (params.env().windowsScript()) {
                    return new StringBuilder(13).append("set \"PATH=").append((String)s).append("\"").append("\r\n").toString();
                }
                return new StringBuilder(15).append("export PATH=\"").append((String)s).append("\"").append("\n").toString();
            });
            Predef$.MODULE$.print((Object)script);
            return;
        }
        if (params.env().setup()) {
            Function1 task = params.env().setupTask(installDir.envUpdate(), params.env().envVarUpdater(), params.output().verbosity(), MaybeSetupPath$.MODULE$.headerComment());
            Task$.MODULE$.PlatformTaskOps(task).unsafeRun((ExecutionContext)cache.ec());
            return;
        }
        if (args.all().isEmpty()) {
            if (params.output().verbosity() >= 0 && params.installChannels().isEmpty()) {
                System.err.println("Nothing to install");
            }
            throw package$.MODULE$.exit(0);
        }
        Channels channels = Channels$.MODULE$.apply(params.channels(), params.repository().repositories(), cache).withVerbosity(params.output().verbosity());
        try {
            args.all().foreach((Function1)(JProcedure1 & Serializable)id -> {
                Option wroteSomethingOpt;
                Function1 function1 = channels.appDescriptor(id);
                Either either = (Either)Task$.MODULE$.PlatformTaskOps(new Task(Task$.MODULE$.attempt$extension(function1)).value()).unsafeRun((ExecutionContext)cache.ec());
                if (either instanceof Left) {
                    Throwable throwable = (Throwable)((Left)either).value();
                    if (throwable instanceof Channels.ChannelsException) {
                        Channels.ChannelsException err = (Channels.ChannelsException)throwable;
                        System.err.println(err.getMessage());
                        throw package$.MODULE$.exit(1);
                    }
                    Throwable err = throwable;
                    throw err;
                }
                if (!(either instanceof Right)) {
                    throw new MatchError((Object)either);
                }
                AppInfo appInfo = (AppInfo)((Right)either).value();
                AppInfo appInfo2 = appInfo;
                Option option = wroteSomethingOpt = installDir.createOrUpdate(appInfo2, Instant.now(), params.force());
                if (option instanceof Some) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
                    if (bl) {
                        if (params.output().verbosity() >= 0) {
                            System.err.println(new StringBuilder(6).append("Wrote ").append(appInfo2.source().id()).toString());
                            return;
                        }
                        return;
                    }
                    if (!bl) {
                        if (params.output().verbosity() >= 1) {
                            System.err.println(new StringBuilder(22).append(appInfo2.source().id()).append(" doesn't need updating").toString());
                            return;
                        }
                        return;
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    if (params.output().verbosity() >= 0) {
                        System.err.println(new StringBuilder(49).append("Could not install ").append(appInfo2.source().id()).append(" (concurrent operation ongoing)").toString());
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            });
        }
        catch (InstallDirException e) {
            System.err.println(e.getMessage());
            if (params.output().verbosity() >= 2) {
                throw e;
            }
            throw package$.MODULE$.exit(1);
        }
        if (params.output().verbosity() >= 0) {
            Set path = ((IterableOnceOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)System.getenv("PATH"))).toSeq().flatMap((Function1 & Serializable)_$2 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$2), File.pathSeparatorChar));
                return ArrayOps$.MODULE$.toSeq$extension(object);
            })).toSet();
            if (!path.apply((Object)params.shared().dir().toAbsolutePath().toString())) {
                System.err.println(new StringBuilder(29).append("Warning: ").append(params.shared().dir()).append(" is not in your PATH").toString());
                if (!Properties$.MODULE$.isWin()) {
                    String rcFile = (String)ShellUtil$.MODULE$.rcFileOpt(ShellUtil$.MODULE$.rcFileOpt$default$1()).getOrElse(Install$::$anonfun$7);
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(97).append("To fix that, add the following line to ").append(rcFile).append("\n                 |\n                 |export PATH=\"$PATH:").append(params.shared().dir().toAbsolutePath()).append("\"").toString())));
                    return;
                }
                return;
            }
            return;
        }
    }

    private static final /* synthetic */ Function1 $anonfun$1(InstallParams params$1, FileCache cache$1, FileCache noUpdateCoursierCache$1, String version) {
        return params$1.sharedJava().javaHome((Cache<Task>)cache$1, (Cache<Task>)noUpdateCoursierCache$1, params$1.repository().repositories(), params$1.output().verbosity()).get(new StringBuilder(8).append("graalvm:").append(version).toString());
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final String $anonfun$7() {
        return "your shell configuration file";
    }
}

