/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.options;

import caseapp.core.help.Help;
import caseapp.core.parser.Parser;
import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import coursier.cache.CacheDefaults$;
import coursier.cache.CachePolicy;
import coursier.cli.options.CacheOptions$;
import coursier.cli.params.CacheParams;
import coursier.cli.params.CacheParams$;
import coursier.credentials.Credentials;
import coursier.credentials.FileCredentials$;
import coursier.parse.CachePolicyParser$;
import coursier.parse.CredentialsParser$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple6$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CacheOptions
implements Product,
Serializable {
    private final Option cache;
    private final String mode;
    private final Option ttl;
    private final int parallel;
    private final List checksum;
    private final int retryCount;
    private final boolean cacheFileArtifacts;
    private final boolean followHttpToHttpsRedirect;
    private final List credentials;
    private final List credentialFile;
    private final boolean useEnvCredentials;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(CacheOptions$.class.getDeclaredField("help$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CacheOptions$.class.getDeclaredField("parser$lzy1"));

    public static CacheOptions apply(Option<String> option, String string, Option<String> option2, int n, List<String> list, int n2, boolean bl, boolean bl2, List<String> list2, List<String> list3, boolean bl3) {
        return CacheOptions$.MODULE$.apply(option, string, option2, n, list, n2, bl, bl2, list2, list3, bl3);
    }

    public static CacheOptions fromProduct(Product product) {
        return CacheOptions$.MODULE$.fromProduct(product);
    }

    public static Help<CacheOptions> help() {
        return CacheOptions$.MODULE$.help();
    }

    public static Parser<CacheOptions> parser() {
        return CacheOptions$.MODULE$.parser();
    }

    public static CacheOptions unapply(CacheOptions cacheOptions) {
        return CacheOptions$.MODULE$.unapply(cacheOptions);
    }

    public static Option<String> $lessinit$greater$default$1() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$1();
    }

    public static String $lessinit$greater$default$2() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$4();
    }

    public static List<String> $lessinit$greater$default$5() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$8();
    }

    public static List<String> $lessinit$greater$default$9() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$9();
    }

    public static List<String> $lessinit$greater$default$10() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$11() {
        return CacheOptions$.MODULE$.$lessinit$greater$default$11();
    }

    public CacheOptions(Option<String> cache, String mode, Option<String> ttl, int parallel, List<String> checksum, int retryCount, boolean cacheFileArtifacts, boolean followHttpToHttpsRedirect, List<String> credentials, List<String> credentialFile, boolean useEnvCredentials) {
        this.cache = cache;
        this.mode = mode;
        this.ttl = ttl;
        this.parallel = parallel;
        this.checksum = checksum;
        this.retryCount = retryCount;
        this.cacheFileArtifacts = cacheFileArtifacts;
        this.followHttpToHttpsRedirect = followHttpToHttpsRedirect;
        this.credentials = credentials;
        this.credentialFile = credentialFile;
        this.useEnvCredentials = useEnvCredentials;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.cache()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mode()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.ttl()));
        n = Statics.mix((int)n, (int)this.parallel());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.checksum()));
        n = Statics.mix((int)n, (int)this.retryCount());
        n = Statics.mix((int)n, (int)(this.cacheFileArtifacts() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.followHttpToHttpsRedirect() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.credentials()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.credentialFile()));
        n = Statics.mix((int)n, (int)(this.useEnvCredentials() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CacheOptions)) return false;
        CacheOptions cacheOptions = (CacheOptions)object;
        if (this.parallel() != cacheOptions.parallel()) return false;
        if (this.retryCount() != cacheOptions.retryCount()) return false;
        if (this.cacheFileArtifacts() != cacheOptions.cacheFileArtifacts()) return false;
        if (this.followHttpToHttpsRedirect() != cacheOptions.followHttpToHttpsRedirect()) return false;
        if (this.useEnvCredentials() != cacheOptions.useEnvCredentials()) return false;
        Option<String> option = this.cache();
        Option<String> option2 = cacheOptions.cache();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.mode();
        String string2 = cacheOptions.mode();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option3 = this.ttl();
        Option<String> option4 = cacheOptions.ttl();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        List<String> list = this.checksum();
        List<String> list2 = cacheOptions.checksum();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<String> list3 = this.credentials();
        List<String> list4 = cacheOptions.credentials();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        List<String> list5 = this.credentialFile();
        List<String> list6 = cacheOptions.credentialFile();
        if (list5 == null) {
            if (list6 == null) return true;
            return false;
        } else {
            if (!list5.equals(list6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CacheOptions;
    }

    public int productArity() {
        return 11;
    }

    public String productPrefix() {
        return "CacheOptions";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this._8());
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return BoxesRunTime.boxToBoolean((boolean)this._11());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "cache";
            }
            case 1: {
                return "mode";
            }
            case 2: {
                return "ttl";
            }
            case 3: {
                return "parallel";
            }
            case 4: {
                return "checksum";
            }
            case 5: {
                return "retryCount";
            }
            case 6: {
                return "cacheFileArtifacts";
            }
            case 7: {
                return "followHttpToHttpsRedirect";
            }
            case 8: {
                return "credentials";
            }
            case 9: {
                return "credentialFile";
            }
            case 10: {
                return "useEnvCredentials";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<String> cache() {
        return this.cache;
    }

    public String mode() {
        return this.mode;
    }

    public Option<String> ttl() {
        return this.ttl;
    }

    public int parallel() {
        return this.parallel;
    }

    public List<String> checksum() {
        return this.checksum;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public boolean cacheFileArtifacts() {
        return this.cacheFileArtifacts;
    }

    public boolean followHttpToHttpsRedirect() {
        return this.followHttpToHttpsRedirect;
    }

    public List<String> credentials() {
        return this.credentials;
    }

    public List<String> credentialFile() {
        return this.credentialFile;
    }

    public boolean useEnvCredentials() {
        return this.useEnvCredentials;
    }

    public Validated<NonEmptyList<String>, CacheParams> params() {
        return this.params((Option<Duration>)CacheDefaults$.MODULE$.ttl());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<NonEmptyList<String>, CacheParams> params(Option<Duration> defaultTtl) {
        Validated validated;
        Option ttlOpt;
        Validated validated2;
        File file;
        Option<String> option = this.cache();
        if (option instanceof Some) {
            String path = (String)((Some)option).value();
            file = new File(path);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            file = CacheDefaults$.MODULE$.location();
        }
        File cache0 = file;
        if (this.mode().isEmpty()) {
            validated2 = Validated$.MODULE$.validNel((Object)CacheDefaults$.MODULE$.cachePolicies());
        } else {
            Either either = CachePolicyParser$.MODULE$.cachePolicies(this.mode(), CacheDefaults$.MODULE$.cachePolicies()).either();
            if (either instanceof Right) {
                Seq cp = (Seq)((Right)either).value();
                validated2 = Validated$.MODULE$.validNel((Object)cp);
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                .colon.colon errors = (.colon.colon)((Left)either).value();
                validated2 = Validated$.MODULE$.invalidNel((Object)new StringBuilder(20).append("Error parsing modes:").append(System.lineSeparator()).append(errors.map((Function1 & Serializable)_$1 -> new StringBuilder(2).append("  ").append((String)_$1).toString()).mkString(System.lineSeparator())).toString());
            }
        }
        Validated cachePoliciesV = validated2;
        Option option2 = ttlOpt = this.ttl().map((Function1 & Serializable)_$2 -> _$2.trim()).filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3)));
        if (None$.MODULE$.equals(option2)) {
            validated = Validated$.MODULE$.validNel(defaultTtl);
        } else {
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            String ttlStr = (String)((Some)option2).value();
            Either either = CacheDefaults$.MODULE$.parseDuration(ttlStr);
            if (either instanceof Left) {
                Throwable e = (Throwable)((Left)either).value();
                validated = Validated$.MODULE$.invalidNel((Object)new StringBuilder(13).append("Parsing TTL: ").append(e.getMessage()).toString());
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Duration d = (Duration)((Right)either).value();
                validated = Validated$.MODULE$.validNel((Object)Some$.MODULE$.apply((Object)d));
            }
        }
        Validated ttlV = validated;
        Validated parallelV = this.parallel() > 0 ? Validated$.MODULE$.validNel((Object)BoxesRunTime.boxToInteger((int)this.parallel())) : Validated$.MODULE$.invalidNel((Object)new StringBuilder(27).append("Parallel must be > 0 (got ").append(this.parallel()).append(")").toString());
        List splitChecksumArgs = this.checksum().flatMap((Function1 & Serializable)_$4 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$4), ','));
            return ArrayOps$.MODULE$.toSeq$extension(object);
        }).filter((Function1 & Serializable)_$5 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$5)));
        Seq res = splitChecksumArgs.isEmpty() ? CacheDefaults$.MODULE$.checksums() : splitChecksumArgs.map((Function1 & Serializable)x$1 -> {
            String string;
            String none = string = x$1;
            String string2 = none.toLowerCase();
            String string3 = "none";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return None$.MODULE$;
            }
            String sumType = string;
            return Some$.MODULE$.apply((Object)sumType);
        });
        Validated checksumV = Validated$.MODULE$.validNel((Object)res);
        Validated retryCountV = this.retryCount() > 0 ? Validated$.MODULE$.validNel((Object)BoxesRunTime.boxToInteger((int)this.retryCount())) : Validated$.MODULE$.invalidNel((Object)new StringBuilder(30).append("Retry count must be > 0 (got ").append(this.retryCount()).append(")").toString());
        Validated credentialsV = ((Validated)implicits$.MODULE$.toTraverseOps(this.credentials(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)s -> {
            Either either = CredentialsParser$.MODULE$.parseSeq(s).either();
            if (either instanceof Left) {
                .colon.colon errors = (.colon.colon)((Left)either).value();
                return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.of(errors.head(), (Seq)errors.tail()));
            }
            if (either instanceof Right) {
                Seq l = (Seq)((Right)either).value();
                return Validated$.MODULE$.validNel((Object)l);
            }
            throw new MatchError((Object)either);
        }, (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable)_$6 -> (List)_$6.flatten(Predef$.MODULE$.$conforms()));
        List credentialFiles = this.credentialFile().map((Function1 & Serializable)f -> FileCredentials$.MODULE$.apply(f));
        return (Validated)implicits$.MODULE$.catsSyntaxTuple6Semigroupal(Tuple6$.MODULE$.apply((Object)cachePoliciesV, (Object)ttlV, (Object)parallelV, (Object)checksumV, (Object)retryCountV, (Object)credentialsV)).mapN((Function6 & Serializable)(cachePolicy, ttl, parallel, checksum, retryCount, credentials0) -> this.params$$anonfun$1(cache0, credentialFiles, (Seq)cachePolicy, (Option)ttl, BoxesRunTime.unboxToInt((Object)parallel), (Seq)checksum, BoxesRunTime.unboxToInt((Object)retryCount), (List)credentials0), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
    }

    public CacheOptions copy(Option<String> cache, String mode, Option<String> ttl, int parallel, List<String> checksum, int retryCount, boolean cacheFileArtifacts, boolean followHttpToHttpsRedirect, List<String> credentials, List<String> credentialFile, boolean useEnvCredentials) {
        return new CacheOptions(cache, mode, ttl, parallel, checksum, retryCount, cacheFileArtifacts, followHttpToHttpsRedirect, credentials, credentialFile, useEnvCredentials);
    }

    public Option<String> copy$default$1() {
        return this.cache();
    }

    public String copy$default$2() {
        return this.mode();
    }

    public Option<String> copy$default$3() {
        return this.ttl();
    }

    public int copy$default$4() {
        return this.parallel();
    }

    public List<String> copy$default$5() {
        return this.checksum();
    }

    public int copy$default$6() {
        return this.retryCount();
    }

    public boolean copy$default$7() {
        return this.cacheFileArtifacts();
    }

    public boolean copy$default$8() {
        return this.followHttpToHttpsRedirect();
    }

    public List<String> copy$default$9() {
        return this.credentials();
    }

    public List<String> copy$default$10() {
        return this.credentialFile();
    }

    public boolean copy$default$11() {
        return this.useEnvCredentials();
    }

    public Option<String> _1() {
        return this.cache();
    }

    public String _2() {
        return this.mode();
    }

    public Option<String> _3() {
        return this.ttl();
    }

    public int _4() {
        return this.parallel();
    }

    public List<String> _5() {
        return this.checksum();
    }

    public int _6() {
        return this.retryCount();
    }

    public boolean _7() {
        return this.cacheFileArtifacts();
    }

    public boolean _8() {
        return this.followHttpToHttpsRedirect();
    }

    public List<String> _9() {
        return this.credentials();
    }

    public List<String> _10() {
        return this.credentialFile();
    }

    public boolean _11() {
        return this.useEnvCredentials();
    }

    private final /* synthetic */ CacheParams params$$anonfun$1(File cache0$1, List credentialFiles$1, Seq cachePolicy, Option ttl, int parallel, Seq checksum, int retryCount, List credentials0) {
        CacheParams baseParams = CacheParams$.MODULE$.apply(cache0$1, (Seq<CachePolicy>)cachePolicy, (Option<Duration>)ttl, parallel, (Seq<Option<String>>)checksum, retryCount, this.cacheFileArtifacts(), this.followHttpToHttpsRedirect(), CacheParams$.MODULE$.$lessinit$greater$default$9(), CacheParams$.MODULE$.$lessinit$greater$default$10());
        return baseParams.withCredentials((Seq<Credentials>)((Seq)credentials0.$plus$plus((IterableOnce)credentialFiles$1))).withUseEnvCredentials(this.useEnvCredentials());
    }
}

