/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.resolve;

import caseapp.core.RemainingArgs;
import cats.data.NonEmptyList;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.cli.CommandGroup$;
import coursier.cli.CoursierCommand;
import coursier.cli.params.CacheParams;
import coursier.cli.params.DependencyParams;
import coursier.cli.params.OutputParams;
import coursier.cli.params.RepositoryParams;
import coursier.cli.resolve.Dependencies$;
import coursier.cli.resolve.Output$;
import coursier.cli.resolve.ResolveException;
import coursier.cli.resolve.ResolveException$;
import coursier.cli.resolve.ResolveOptions;
import coursier.cli.resolve.ResolveOptions$;
import coursier.cli.resolve.ResolveParams;
import coursier.cli.resolve.ResolveParams$;
import coursier.cli.resolve.SharedResolveParams;
import coursier.core.Dependency;
import coursier.core.Module;
import coursier.core.Repository;
import coursier.core.Resolution;
import coursier.error.ResolutionError;
import coursier.install.AppArtifacts;
import coursier.install.AppDescriptor$;
import coursier.install.AppInfo;
import coursier.install.Channel;
import coursier.install.Channels;
import coursier.install.Channels$;
import coursier.install.RawAppDescriptor;
import coursier.install.RawAppDescriptor$;
import coursier.params.ResolutionParams;
import coursier.parse.JavaOrScalaModule;
import coursier.parse.JavaOrScalaModule$;
import coursier.paths.Util;
import coursier.util.InMemoryRepository$;
import coursier.util.Sync$;
import coursier.util.Task;
import coursier.util.Task$;
import coursier.version.Version;
import coursier.version.VersionConstraint;
import coursier.version.VersionConstraint$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class Resolve$
extends CoursierCommand<ResolveOptions> {
    public static final Resolve$ MODULE$ = new Resolve$();

    private Resolve$() {
        super(ResolveOptions$.MODULE$.parser(), ResolveOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Resolve$.class);
    }

    private <T> Function1<Task<T>, Task<T>> benchmark(int iterations) {
        return (Function1 & Serializable)v1 -> new Task(this.benchmark$$anonfun$1(iterations, v1 == null ? null : ((Task)v1).value()));
    }

    private <A> Either<Throwable, A> lift(Function0<A> f) {
        return Try$.MODULE$.apply(f).toEither();
    }

    private <A> A unlift(Function0<Either<Throwable, A>> e) {
        return (A)((Either)e.apply()).fold((Function1 & Serializable)_$1 -> {
            throw _$1;
        }, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public Either<Throwable, Tuple4<Seq<Dependency>, Seq<Repository>, Option<VersionConstraint>, Option<String>>> depsAndReposOrError(SharedResolveParams params, Seq<String> args, Cache<Task> cache) {
        return this.lift(() -> this.depsAndReposOrError$$anonfun$1(params, args, cache));
    }

    public Function1 printTask(ResolveParams params, ExecutorService pool, PrintStream stdout, PrintStream stderr, Seq<String> args, int benchmark, boolean benchmarkCache) {
        Tuple2 tuple2;
        Function1 function1;
        Function1 task0 = this.task(params.shared(), pool, stdout, stderr, args, params.forcePrint(), benchmark, benchmarkCache);
        Option<Tuple2<FiniteDuration, Object>> option = params.retry();
        if (None$.MODULE$.equals(option)) {
            function1 = task0;
        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            FiniteDuration period = (FiniteDuration)tuple2._1();
            int maxAttempts = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
                private final ThreadFactory defaultThreadFactory;
                {
                    this.defaultThreadFactory = Executors.defaultThreadFactory();
                }

                public ThreadFactory defaultThreadFactory() {
                    return this.defaultThreadFactory;
                }

                public Thread newThread(Runnable r) {
                    Thread t = this.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setName("retry-handler");
                    return t;
                }
            });
            Function1 delay = Task$.MODULE$.completeAfter(scheduler, period);
            function1 = this.helper$1(task0, maxAttempts, stderr, delay, 1);
        } else {
            throw new MatchError(option);
        }
        Function1 finalTask = function1;
        return Task$.MODULE$.flatMap$extension(finalTask, (Function1 & Serializable)x$1 -> new Task(Resolve$.printTask$$anonfun$1(params, stdout, stderr, x$1)));
    }

    public int printTask$default$6() {
        return 0;
    }

    public boolean printTask$default$7() {
        return false;
    }

    public Function1 task(SharedResolveParams params, ExecutorService pool, PrintStream stdout, PrintStream stderr, Seq<String> args, boolean force, int benchmark, boolean benchmarkCache) {
        Cache<Task> cache = params.cache().cache(pool, params.output().logger(), benchmark != 0 && benchmarkCache);
        Either<Throwable, Tuple4<Seq<Dependency>, Seq<Repository>, Option<VersionConstraint>, Option<String>>> depsAndReposOrError0 = this.depsAndReposOrError(params, args, cache);
        Function1 function1 = Task$.MODULE$.fromEither(depsAndReposOrError0);
        Function1 function12 = Task$.MODULE$.map$extension(function1, (Function1 & Serializable)res0 -> {
            BoxedUnit boxedUnit;
            Tuple4 tuple4 = res0;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Seq deps = (Seq)tuple4._1();
            Seq repositories = (Seq)tuple4._2();
            Option scalaVersionOpt = (Option)tuple4._3();
            Option platformOpt = (Option)tuple4._4();
            Tuple4 $5$ = tuple4;
            Tuple5 tuple5 = Tuple5$.MODULE$.apply((Object)$5$, (Object)deps, (Object)repositories, (Object)scalaVersionOpt, (Object)platformOpt);
            Tuple4 $5$2 = (Tuple4)tuple5._1();
            Seq deps2 = (Seq)tuple5._2();
            Seq repositories2 = (Seq)tuple5._3();
            Option scalaVersionOpt2 = (Option)tuple5._4();
            Option platformOpt2 = (Option)tuple5._5();
            ResolutionParams resolutionParams = params.updatedResolution((Option<VersionConstraint>)scalaVersionOpt2);
            CacheParams cacheParams = params.copy$default$1();
            OutputParams outputParams = params.copy$default$2();
            RepositoryParams repositoryParams = params.copy$default$3();
            DependencyParams dependencyParams = params.copy$default$4();
            Option<Object> option = params.copy$default$6();
            SharedResolveParams params0 = params.copy(cacheParams, outputParams, repositoryParams, dependencyParams, resolutionParams, option);
            Output$.MODULE$.printDependencies(params0.output(), params0.resolution(), (Seq<Dependency>)deps2, stdout, stderr);
            BoxedUnit $6$ = boxedUnit = BoxedUnit.UNIT;
            BoxedUnit $6$2 = BoxedUnit.UNIT;
            return Tuple4$.MODULE$.apply(res0, (Object)$5$2, (Object)params0, (Object)$6$2);
        });
        return Task$.MODULE$.flatMap$extension(function12, (Function1 & Serializable)x$1 -> new Task(Resolve$.task$$anonfun$2(cache, benchmark, force, stderr, x$1)));
    }

    public boolean task$default$6() {
        return false;
    }

    public int task$default$7() {
        return 0;
    }

    public boolean task$default$8() {
        return false;
    }

    public <T> Tuple2<T, Seq<String>> handleApps(T options, Seq<String> args, Channels channels, Function2<T, RawAppDescriptor, T> withApp) {
        Tuple2 tuple2 = args.partition((Function1 & Serializable)s -> s.startsWith("{") || StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$11 -> Resolve$.$anonfun$17$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$11))).startsWith(":{"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq inlineAppIds = (Seq)tuple2._1();
        Seq args0 = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)inlineAppIds, (Object)args0);
        Seq inlineAppIds2 = (Seq)tuple22._1();
        Seq args02 = (Seq)tuple22._2();
        Tuple2 tuple23 = args02.partition((Function1 & Serializable)s -> StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$12 -> Resolve$.$anonfun$18$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$12))) <= 1);
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq appIds = (Seq)tuple23._1();
        Seq deps = (Seq)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)appIds, (Object)deps);
        Seq appIds2 = (Seq)tuple24._1();
        Seq deps2 = (Seq)tuple24._2();
        if (inlineAppIds2.length() + appIds2.length() > 1) {
            System.err.println("Error: only at most one app can be passed as dependency");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Option inlineDescOpt = inlineAppIds2.headOption().map((Function1 & Serializable)input -> {
            String input0 = input.trim();
            int idx = input0.indexOf(":{");
            Tuple2 tuple2 = idx >= 0 ? Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(input), idx)).filter((Function1 & Serializable)_$13 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$13))), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(input), idx + 1)) : Tuple2$.MODULE$.apply((Object)None$.MODULE$, input);
            Option nameOpt = (Option)tuple2._1();
            String json = (String)tuple2._2();
            Either e = RawAppDescriptor$.MODULE$.parse(json).map((Function1 & Serializable)rawDesc -> rawDesc.withName(rawDesc.name().orElse(() -> Resolve$.$anonfun$21$$anonfun$1(nameOpt))));
            Either either = e;
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                System.err.println(err);
                throw scala.sys.package$.MODULE$.exit(1);
            }
            if (either instanceof Right) {
                RawAppDescriptor res = (RawAppDescriptor)((Right)either).value();
                return res;
            }
            throw new MatchError((Object)either);
        });
        return (Tuple2)inlineDescOpt.orElse(() -> this.handleApps$$anonfun$1(appIds2, channels)).fold(() -> Resolve$.handleApps$$anonfun$2(options, args), (Function1 & Serializable)desc -> Tuple2$.MODULE$.apply(withApp.apply(options, desc), desc.dependencies().$plus$plus((IterableOnce)deps2)));
    }

    public String group() {
        return CommandGroup$.MODULE$.resolve();
    }

    public void run(ResolveOptions options, RemainingArgs args) {
        ObjectRef pool = ObjectRef.create(null);
        Tuple2 tuple2 = (Tuple2)ResolveParams$.MODULE$.apply(options).toEither().toOption().fold(() -> Resolve$.$anonfun$24(options, args), (Function1 & Serializable)initialParams -> {
            Seq<Repository> initialRepositories = initialParams.repositories().repositories();
            Seq<Channel> channels = initialParams.channel().channels();
            pool$1.elem = Sync$.MODULE$.fixedThreadPool(initialParams.cache().parallel());
            CacheParams cacheParams = initialParams.cache();
            FileCache<Task> cache = cacheParams.cache((ExecutorService)pool$1.elem, initialParams.output().logger(), cacheParams.cache$default$3());
            Channels channels0 = Channels$.MODULE$.apply(channels, initialRepositories, cache);
            Tuple2<ResolveOptions, Seq<String>> res = MODULE$.handleApps(options, (Seq<String>)args.all(), channels0, (Function2 & Serializable)(_$14, _$15) -> _$14.addApp((RawAppDescriptor)_$15));
            return res;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResolveOptions options0 = (ResolveOptions)tuple2._1();
        Seq deps = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)options0, (Object)deps);
        ResolveOptions options02 = (ResolveOptions)tuple22._1();
        Seq deps2 = (Seq)tuple22._2();
        Either either = ResolveParams$.MODULE$.apply(options02).toEither();
        if (either instanceof Left) {
            NonEmptyList errors = (NonEmptyList)((Left)either).value();
            errors.toList().foreach((Function1)(JProcedure1 & Serializable)err -> Output$.MODULE$.errPrintln((String)err));
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        ResolveParams params0 = (ResolveParams)((Right)either).value();
        ResolveParams params = params0;
        if ((ExecutorService)pool.elem == null) {
            pool.elem = Sync$.MODULE$.fixedThreadPool(params.cache().parallel());
        }
        ExecutionContextExecutorService ec = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)pool.elem);
        Function1 t = this.printTask(params, (ExecutorService)pool.elem, System.out, System.err, (Seq<String>)deps2, params.benchmark(), params.benchmarkCache());
        Either either2 = (Either)Task$.MODULE$.PlatformTaskOps(Task$.MODULE$.attempt$extension(t)).unsafeRun((ExecutionContext)ec);
        if (either2 instanceof Left) {
            Throwable throwable = (Throwable)((Left)either2).value();
            if (throwable instanceof ResolveException) {
                ResolveException e = (ResolveException)throwable;
                if (params.output().verbosity() <= 1) {
                    Output$.MODULE$.errPrintln(e.getMessage());
                    throw scala.sys.package$.MODULE$.exit(1);
                }
            }
            if (throwable instanceof AppArtifacts.AppArtifactsException) {
                AppArtifacts.AppArtifactsException e = (AppArtifacts.AppArtifactsException)throwable;
                if (params.output().verbosity() <= 1) {
                    Output$.MODULE$.errPrintln(e.getMessage());
                    throw scala.sys.package$.MODULE$.exit(1);
                }
            }
            Throwable e = throwable;
            throw new Exception(e);
        }
        if (either2 instanceof Right) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Right)either2).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                return;
            }
        }
        throw new MatchError((Object)either2);
    }

    private static final long $anonfun$1() {
        return System.currentTimeMillis();
    }

    private static final long $anonfun$2$$anonfun$1$$anonfun$1() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ Tuple2 $anonfun$2$$anonfun$1$$anonfun$2(long start$2, long end) {
        BoxedUnit boxedUnit;
        Console$.MODULE$.err().println(new StringBuilder(3).append(end - start$2).append(" ms").toString());
        BoxedUnit $4$ = boxedUnit = BoxedUnit.UNIT;
        BoxedUnit $4$2 = BoxedUnit.UNIT;
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)end), (Object)$4$2);
    }

    private static final /* synthetic */ Function1 $anonfun$2$$anonfun$1(long start$1, Object res0) {
        Function1 function1 = Task$.MODULE$.delay(Resolve$::$anonfun$2$$anonfun$1$$anonfun$1);
        Function1 function12 = Task$.MODULE$.map$extension(function1, (Function1 & Serializable)end -> Resolve$.$anonfun$2$$anonfun$1$$anonfun$2(start$1, BoxesRunTime.unboxToLong((Object)end)));
        return Task$.MODULE$.map$extension(function12, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long end = BoxesRunTime.unboxToLong((Object)tuple2._1());
                return res0;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final void result$1$$anonfun$1() {
        Console$.MODULE$.err().println("Benchmark resolution");
    }

    private static final /* synthetic */ Function1 result$1$$anonfun$2(Function1 res$2, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return Task$.MODULE$.map$extension(res$2, (Function1 & Serializable)r -> r);
    }

    private static final void result$1$$anonfun$3(int warmUp$1, int iterations$3) {
        Console$.MODULE$.err().println(new StringBuilder(11).append("Warm-up ").append(warmUp$1 + 1).append(" / ").append(iterations$3).toString());
    }

    private final /* synthetic */ Function1 result$1$$anonfun$4$$anonfun$1(int warmUp$3, int iterations$5, Function1 res$4, Object x$1) {
        Object object = x$1;
        Function1 function1 = this.result$1(iterations$5, res$4, warmUp$3 + 1);
        return Task$.MODULE$.map$extension(function1, (Function1 & Serializable)r -> r);
    }

    private final /* synthetic */ Function1 result$1$$anonfun$4(Function1 res$3, int warmUp$2, int iterations$4, BoxedUnit x$12) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return Task$.MODULE$.flatMap$extension(res$3, (Function1 & Serializable)x$1 -> new Task(this.result$1$$anonfun$4$$anonfun$1(warmUp$2, iterations$4, res$3, x$1)));
    }

    private final Function1 result$1(int iterations$2, Function1 res$1, int warmUp) {
        if (warmUp >= iterations$2) {
            Function1 function1 = Task$.MODULE$.delay((Function0 & Serializable)() -> {
                Resolve$.result$1$$anonfun$1();
                return BoxedUnit.UNIT;
            });
            return Task$.MODULE$.flatMap$extension(function1, (Function1 & Serializable)x$1 -> new Task(Resolve$.result$1$$anonfun$2(res$1, x$1)));
        }
        Function1 function1 = Task$.MODULE$.delay((Function0 & Serializable)() -> {
            Resolve$.result$1$$anonfun$3(warmUp, iterations$2);
            return BoxedUnit.UNIT;
        });
        return Task$.MODULE$.flatMap$extension(function1, (Function1 & Serializable)x$1 -> new Task(this.result$1$$anonfun$4(res$1, warmUp, iterations$2, (BoxedUnit)x$1)));
    }

    private final /* synthetic */ Function1 benchmark$$anonfun$1(int iterations$1, Function1 run) {
        Function1 function1 = Task$.MODULE$.delay(Resolve$::$anonfun$1);
        Function1 res = Task$.MODULE$.flatMap$extension(function1, (Function1 & Serializable)v1 -> new Task(Task$.MODULE$.flatMap$extension(run, (Function1 & Serializable)res0 -> new Task(Resolve$.$anonfun$2$$anonfun$1(start, res0)))));
        return this.result$1(iterations$1, res, 0);
    }

    private static final Either $anonfun$3(Seq args$2, Seq fromFilesDependencies$1, SharedResolveParams params$2) {
        return Dependencies$.MODULE$.withExtraRepo((Seq<String>)((Seq)args$2.$plus$plus((IterableOnce)fromFilesDependencies$1)), params$2.dependency().intransitiveDependencies());
    }

    private static final Either $anonfun$4(SharedResolveParams params$3) {
        return Dependencies$.MODULE$.withExtraRepo((Seq<String>)scala.package$.MODULE$.Nil(), params$3.dependency().sbtPluginDependencies());
    }

    private static final /* synthetic */ boolean $anonfun$5$$anonfun$2$$anonfun$1(char _$3) {
        return _$3 == '.';
    }

    private static final /* synthetic */ boolean $anonfun$5$$anonfun$2$$anonfun$2(char c) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '.';
    }

    private static final Either $anonfun$5(List javaOrScalaDeps$1, SharedResolveParams params$4, Cache cache$3) {
        return AppDescriptor$.MODULE$.apply().withDependencies((Seq)javaOrScalaDeps$1).withRepositories(params$4.repositories().repositories()).withScalaVersionOpt(params$4.resolution().scalaVersionOpt0().map((Function1 & Serializable)_$2 -> _$2.asString()).map((Function1 & Serializable)s -> {
            if (StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$3 -> Resolve$.$anonfun$5$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$3))) < 2 && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> Resolve$.$anonfun$5$$anonfun$2$$anonfun$2(BoxesRunTime.unboxToChar((Object)c)))) {
                return new StringBuilder(1).append((String)s).append("+").toString();
            }
            return s;
        })).processDependencies(cache$3, params$4.dependency().platformOpt(), params$4.output().verbosity());
    }

    private static final VersionConstraint $anonfun$6() {
        return VersionConstraint$.MODULE$.empty();
    }

    private static final String $anonfun$10$$anonfun$1() {
        return "";
    }

    private static final Seq $anonfun$13() {
        return scala.package$.MODULE$.Nil();
    }

    public static final /* synthetic */ boolean coursier$cli$resolve$Resolve$$anon$1$$_$isDefinedAt$$anonfun$1(Version version$1, VersionConstraint _$8) {
        VersionConstraint versionConstraint = _$8;
        VersionConstraint versionConstraint2 = VersionConstraint$.MODULE$.fromVersion(version$1);
        return versionConstraint == null ? versionConstraint2 != null : !versionConstraint.equals(versionConstraint2);
    }

    public static final /* synthetic */ boolean coursier$cli$resolve$Resolve$$anon$1$$_$applyOrElse$$anonfun$1(Version version$2, VersionConstraint _$8) {
        VersionConstraint versionConstraint = _$8;
        VersionConstraint versionConstraint2 = VersionConstraint$.MODULE$.fromVersion(version$2);
        return versionConstraint == null ? versionConstraint2 != null : !versionConstraint.equals(versionConstraint2);
    }

    private final Either depsAndReposOrError$$anonfun$1$$anonfun$1(Option extraRepoOpt$1, SharedResolveParams params$6) {
        Seq invalidForced = (Seq)((IterableOps)extraRepoOpt$1.map((Function1 & Serializable)_$7 -> _$7.fallbacks0().toSeq()).getOrElse(Resolve$::$anonfun$13)).collect((PartialFunction)new Serializable(params$6){
            private final SharedResolveParams params$7;
            {
                this.params$7 = params$11;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2;
                Tuple2 tuple22 = x;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Module mod = (Module)tuple2._1();
                    Version version = (Version)tuple2._2();
                    if (this.params$7.resolution().forceVersion0().get((Object)mod).exists(arg_0 -> Resolve$.coursier$cli$resolve$Resolve$$anon$1$$_$isDefinedAt$$anonfun$1(version, arg_0))) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2;
                Tuple2 tuple22 = x;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Module mod = (Module)tuple2._1();
                    Version version = (Version)tuple2._2();
                    if (this.params$7.resolution().forceVersion0().get((Object)mod).exists(arg_0 -> Resolve$.coursier$cli$resolve$Resolve$$anon$1$$_$applyOrElse$$anonfun$1(version, arg_0))) {
                        return Tuple2$.MODULE$.apply((Object)mod, (Object)version);
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{coursier$cli$resolve$Resolve$$anon$1$$_$isDefinedAt$$anonfun$1(coursier.version.Version coursier.version.VersionConstraint ), coursier$cli$resolve$Resolve$$anon$1$$_$applyOrElse$$anonfun$1(coursier.version.Version coursier.version.VersionConstraint )}, serializedLambda);
            }
        });
        if (invalidForced.isEmpty()) {
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return scala.package$.MODULE$.Left().apply((Object)new ResolveException(new StringBuilder(85).append("Cannot force a version that is different from the one specified for modules ").append(((IterableOnceOps)invalidForced.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Module mod = (Module)tuple2._1();
                Version ver = (Version)tuple2._2();
                return new StringBuilder(1).append(mod.repr()).append(":").append(ver.asString()).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ")).append(" with url").toString(), ResolveException$.MODULE$.$lessinit$greater$default$2()));
    }

    private final Tuple4 depsAndReposOrError$$anonfun$1(SharedResolveParams params$1, Seq args$1, Cache cache$2) {
        Seq<String> fromFilesDependencies = params$1.dependency().fromFilesDependencies();
        Tuple2 tuple2 = (Tuple2)this.unlift(() -> Resolve$.$anonfun$3(args$1, fromFilesDependencies, params$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List javaOrScalaDeps = (List)tuple2._1();
        Map urlDeps = (Map)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)javaOrScalaDeps, (Object)urlDeps);
        List javaOrScalaDeps2 = (List)tuple22._1();
        Map urlDeps2 = (Map)tuple22._2();
        Tuple2 tuple23 = (Tuple2)this.unlift(() -> Resolve$.$anonfun$4(params$1));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        List sbtPluginJavaOrScalaDeps = (List)tuple23._1();
        Map sbtPluginUrlDeps = (Map)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)sbtPluginJavaOrScalaDeps, (Object)sbtPluginUrlDeps);
        List sbtPluginJavaOrScalaDeps2 = (List)tuple24._1();
        Map sbtPluginUrlDeps2 = (Map)tuple24._2();
        Tuple3 tuple3 = (Tuple3)this.unlift(() -> Resolve$.$anonfun$5(javaOrScalaDeps2, params$1, cache$2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option scalaVersionOpt = (Option)tuple3._1();
        Option platformOpt = (Option)tuple3._2();
        Seq deps = (Seq)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)scalaVersionOpt, (Object)platformOpt, (Object)deps);
        Option scalaVersionOpt2 = (Option)tuple32._1();
        Option platformOpt2 = (Option)tuple32._2();
        Seq deps2 = (Seq)tuple32._3();
        VersionConstraint scalaVersion = (VersionConstraint)scalaVersionOpt2.getOrElse(Resolve$::$anonfun$6);
        Option extraRepoOpt = Some$.MODULE$.apply((Object)urlDeps2.$plus$plus((IterableOnce)sbtPluginUrlDeps2)).filter((Function1 & Serializable)_$4 -> _$4.nonEmpty()).map((Function1 & Serializable)m -> {
            Map m0 = (Map)m.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    JavaOrScalaModule mod = (JavaOrScalaModule)tuple2._1();
                    Version version = (Version)tuple2._2();
                    URL url = (URL)tuple22._2();
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)mod.module(scalaVersion.asString()), (Object)version), (Object)Tuple2$.MODULE$.apply((Object)url, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
                }
                throw new MatchError((Object)tuple22);
            });
            return InMemoryRepository$.MODULE$.privateApply(m0, params$1.cache().cacheLocalArtifacts());
        });
        Seq<Dependency> deps0 = Dependencies$.MODULE$.addExclusions((Seq<Dependency>)((Seq)deps2.$plus$plus((IterableOnce)sbtPluginJavaOrScalaDeps2.map((Function1 & Serializable)_$5 -> _$5.dependency(JavaOrScalaModule$.MODULE$.scalaBinaryVersion(scalaVersion.asString()), scalaVersion.asString(), (String)platformOpt2.getOrElse(Resolve$::$anonfun$10$$anonfun$1))))), (Map<Module, Set<Module>>)((Map)params$1.dependency().perModuleExclude().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JavaOrScalaModule k = (JavaOrScalaModule)tuple2._1();
                Set s = (Set)tuple2._2();
                Module module = (Module)Predef$.MODULE$.ArrowAssoc((Object)k.module(scalaVersion.asString()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)module, s.map((Function1 & Serializable)_$6 -> _$6.module(scalaVersion.asString())));
            }
            throw new MatchError((Object)tuple2);
        })));
        Seq repositories = (Seq)Option$.MODULE$.option2Iterable(extraRepoOpt).toSeq().$plus$plus(params$1.repositories().repositories());
        this.unlift(() -> this.depsAndReposOrError$$anonfun$1$$anonfun$1(extraRepoOpt, params$1));
        return Tuple4$.MODULE$.apply(deps0, (Object)repositories, (Object)scalaVersionOpt2, (Object)platformOpt2);
    }

    private static final void $anonfun$14(PrintStream stderr$3, int count$2, Throwable e$1) {
        stderr$3.println(new StringBuilder(17).append("Attempt ").append(count$2).append(" failed: ").append(e$1).toString());
    }

    private final /* synthetic */ Function1 helper$1$$anonfun$1$$anonfun$1$$anonfun$1(int count$4, Function1 task0$4, int maxAttempts$4, PrintStream stderr$5, Function1 delay$4, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Function1 function1 = this.helper$1(task0$4, maxAttempts$4, stderr$5, delay$4, count$4 + 1);
        return Task$.MODULE$.map$extension(function1, (Function1 & Serializable)res -> res);
    }

    private final /* synthetic */ Function1 helper$1$$anonfun$1$$anonfun$1(Function1 delay$3, int count$3, Function1 task0$3, int maxAttempts$3, PrintStream stderr$4, BoxedUnit x$12) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return Task$.MODULE$.flatMap$extension(delay$3, (Function1 & Serializable)x$1 -> new Task(this.helper$1$$anonfun$1$$anonfun$1$$anonfun$1(count$3, task0$3, maxAttempts$3, stderr$4, delay$3, (BoxedUnit)x$1)));
    }

    private final /* synthetic */ Function1 helper$1$$anonfun$1(int count$1, int maxAttempts$2, PrintStream stderr$2, Function1 delay$2, Function1 task0$2, Either x$12) {
        Either either = x$12;
        if (either instanceof Left) {
            Throwable e = (Throwable)((Left)either).value();
            if (count$1 >= maxAttempts$2) {
                Throwable throwable = e;
                Exception ex = throwable instanceof ResolveException ? new ResolveException(new StringBuilder(42).append("Resolution still failing after ").append(maxAttempts$2).append(" attempts: ").append(e.getMessage()).toString(), e) : new Exception(new StringBuilder(40).append("Resolution still failing after ").append(maxAttempts$2).append(" attempts").toString(), e);
                return Task$.MODULE$.fail((Throwable)ex);
            }
            Function1 print = Task$.MODULE$.delay((Function0 & Serializable)() -> {
                Resolve$.$anonfun$14(stderr$2, count$1, e);
                return BoxedUnit.UNIT;
            });
            return Task$.MODULE$.flatMap$extension(print, (Function1 & Serializable)x$1 -> new Task(this.helper$1$$anonfun$1$$anonfun$1(delay$2, count$1, task0$2, maxAttempts$2, stderr$2, (BoxedUnit)x$1)));
        }
        if (either instanceof Right) {
            Tuple4 res = (Tuple4)((Right)either).value();
            return Task$.MODULE$.point((Object)res);
        }
        throw new MatchError((Object)either);
    }

    private final Function1 helper$1(Function1 task0$1, int maxAttempts$1, PrintStream stderr$1, Function1 delay$1, int count) {
        Function1 function1 = Task$.MODULE$.attempt$extension(task0$1);
        return Task$.MODULE$.flatMap$extension(function1, (Function1 & Serializable)x$1 -> new Task(this.helper$1$$anonfun$1(count, maxAttempts$1, stderr$1, delay$1, task0$1, (Either)x$1)));
    }

    private static final void printTask$$anonfun$1$$anonfun$1(boolean outputToStdout$1, ResolveParams params$9, Option scalaVersionOpt$1, Option platformOpt$2, Resolution res$5, PrintStream stdout$2, PrintStream stderr$7) {
        Output$.MODULE$.printResolutionResult(outputToStdout$1, params$9, (Option<String>)scalaVersionOpt$1, (Option<String>)platformOpt$2, res$5, stdout$2, stderr$7, Util.useColorOutput());
    }

    private static final /* synthetic */ Function1 printTask$$anonfun$1(ResolveParams params$8, PrintStream stdout$1, PrintStream stderr$6, Tuple4 x$1) {
        Tuple4 tuple4 = x$1;
        if (tuple4 != null) {
            boolean outputToStdout;
            Resolution res = (Resolution)tuple4._1();
            Option scalaVersionOpt = (Option)tuple4._2();
            Option platformOpt = (Option)tuple4._3();
            Option errorOpt = (Option)tuple4._4();
            boolean bl = outputToStdout = errorOpt.isEmpty() || params$8.forcePrint();
            if (outputToStdout || params$8.output().verbosity() >= 2) {
                return Task$.MODULE$.delay((Function0 & Serializable)() -> {
                    Resolve$.printTask$$anonfun$1$$anonfun$1(outputToStdout, params$8, scalaVersionOpt, platformOpt, res, stdout$1, stderr$6);
                    return BoxedUnit.UNIT;
                });
            }
            return Task$.MODULE$.point((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)tuple4);
    }

    private static final /* synthetic */ Function1 task$$anonfun$2$$anonfun$1(int benchmark$2, Function1 t) {
        if (benchmark$2 == 0) {
            return t;
        }
        Object object = MODULE$.benchmark(package$.MODULE$.abs(benchmark$2)).apply((Object)new Task(t));
        if (object == null) {
            return null;
        }
        return ((Task)object).value();
    }

    private static final void $anonfun$15(Seq modVers$1) {
        Output$.MODULE$.errPrintln(new StringBuilder(30).append("Getting ").append(modVers$1.length()).append(" project definition(s)").toString());
    }

    private static final /* synthetic */ Function1 task$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Function1 f$2, Seq modVers$2, BoxedUnit _$9) {
        Object object = f$2.apply((Object)modVers$2);
        if (object == null) {
            return null;
        }
        return ((Task)object).value();
    }

    private static final /* synthetic */ Function1 task$$anonfun$2$$anonfun$2$$anonfun$1(Function1 f$1, Seq modVers) {
        Function1 print = Task$.MODULE$.delay((Function0 & Serializable)() -> {
            Resolve$.$anonfun$15(modVers);
            return BoxedUnit.UNIT;
        });
        return Task$.MODULE$.flatMap$extension(print, (Function1 & Serializable)_$9 -> new Task(Resolve$.task$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(f$1, modVers, _$9)));
    }

    private static final /* synthetic */ Function1 task$$anonfun$2$$anonfun$3(boolean force$2, Either x$12) {
        Task task;
        Task task2;
        Throwable throwable;
        Either either = x$12;
        if (either instanceof Left && (throwable = (Throwable)((Left)either).value()) instanceof ResolutionError) {
            ResolutionError ex = (ResolutionError)throwable;
            task2 = force$2 ? new Task(Task$.MODULE$.point((Object)Tuple3$.MODULE$.apply((Object)ex.resolution(), (Object)scala.package$.MODULE$.Nil(), (Object)Some$.MODULE$.apply((Object)ex)))) : new Task(Task$.MODULE$.fail((Throwable)new ResolveException(new StringBuilder(18).append("Resolution error: ").append(ex.getMessage()).toString(), (Throwable)ex)));
        } else {
            Either e = either;
            task2 = task = new Task(Task$.MODULE$.fromEither(e.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Resolution r = (Resolution)tuple2._1();
                    Seq w = (Seq)tuple2._2();
                    return Tuple3$.MODULE$.apply((Object)r, (Object)w, (Object)None$.MODULE$);
                }
                throw new MatchError((Object)tuple2);
            })));
        }
        if (task == null) {
            return null;
        }
        return task.value();
    }

    private static final /* synthetic */ Function1 task$$anonfun$2(Cache cache$4, int benchmark$1, boolean force$1, PrintStream stderr$9, Tuple4 x$12) {
        Tuple4 tuple4 = x$12;
        if (tuple4 != null) {
            Tuple4 tuple42 = (Tuple4)tuple4._2();
            Tuple4 res0 = (Tuple4)tuple4._1();
            if (tuple42 != null) {
                Seq deps = (Seq)tuple42._1();
                Seq repositories = (Seq)tuple42._2();
                Option scalaVersionOpt = (Option)tuple42._3();
                Option platformOpt = (Option)tuple42._4();
                SharedResolveParams params0 = (SharedResolveParams)tuple4._3();
                Object object = coursier.Resolve$.MODULE$.apply().withDependencies(deps).withRepositories(repositories).withResolutionParams(params0.resolution()).withBomDependencies(params0.dependency().bomDependencies()).withCache(cache$4).transformResolution((Function1 & Serializable)v1 -> new Task(Resolve$.task$$anonfun$2$$anonfun$1(benchmark$1, v1 == null ? null : ((Task)v1).value()))).transformFetcher((Function1 & Serializable)f -> {
                    if (params0.output().verbosity() >= 2) {
                        return (Function1 & Serializable)modVers -> new Task(Resolve$.task$$anonfun$2$$anonfun$2$$anonfun$1(f, modVers));
                    }
                    return f;
                }).ioWithConflicts();
                Function1 function1 = object == null ? null : ((Task)object).value();
                Function1 function12 = new Task(Task$.MODULE$.attempt$extension(function1)).value();
                Function1 function13 = Task$.MODULE$.flatMap$extension(function12, (Function1 & Serializable)x$1 -> new Task(Resolve$.task$$anonfun$2$$anonfun$3(force$1, x$1)));
                Function1 function14 = Task$.MODULE$.map$extension(function13, (Function1 & Serializable)res1 -> {
                    BoxedUnit boxedUnit;
                    Tuple3 tuple3 = res1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Resolution res = (Resolution)tuple3._1();
                    Option errorOpt = (Option)tuple3._3();
                    Tuple3 $8$ = tuple3;
                    Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)$8$, (Object)res, (Object)errorOpt);
                    Tuple3 $8$2 = (Tuple3)tuple32._1();
                    Resolution res2 = (Resolution)tuple32._2();
                    Option errorOpt2 = (Option)tuple32._3();
                    errorOpt2.foreach((Function1)(JProcedure1 & Serializable)ex -> ex.errors().foreach((Function1)(JProcedure1 & Serializable)err -> stderr$9.println(err.getMessage())));
                    BoxedUnit $9$ = boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit $9$2 = BoxedUnit.UNIT;
                    return Tuple3$.MODULE$.apply(res1, (Object)$8$2, (Object)$9$2);
                });
                return Task$.MODULE$.map$extension(function14, (Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        Tuple3 tuple32 = (Tuple3)tuple3._2();
                        Tuple3 res1 = (Tuple3)tuple3._1();
                        if (tuple32 != null) {
                            Resolution res = (Resolution)tuple32._1();
                            Option errorOpt = (Option)tuple32._3();
                            return Tuple4$.MODULE$.apply((Object)res, (Object)scalaVersionOpt.map((Function1 & Serializable)_$10 -> _$10.asString()), (Object)platformOpt, (Object)errorOpt);
                        }
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
        }
        throw new MatchError((Object)tuple4);
    }

    private static final /* synthetic */ boolean $anonfun$17$$anonfun$1(char _$11) {
        return _$11 != ':';
    }

    private static final /* synthetic */ boolean $anonfun$18$$anonfun$1(char _$12) {
        return _$12 == ':';
    }

    private static final Option $anonfun$21$$anonfun$1(Option nameOpt$2) {
        return nameOpt$2;
    }

    private static final /* synthetic */ Function1 $anonfun$22(Either x$1) {
        Task task;
        Either either = x$1;
        if (either instanceof Left) {
            Throwable throwable = (Throwable)((Left)either).value();
            if (throwable instanceof Channels.ChannelsException) {
                Channels.ChannelsException e = (Channels.ChannelsException)throwable;
                task = new Task(Task$.MODULE$.point((Object)scala.package$.MODULE$.Left().apply((Object)e.getMessage())));
            } else {
                Throwable e = throwable;
                task = new Task(Task$.MODULE$.fail((Throwable)new Exception(e)));
            }
        } else if (either instanceof Right) {
            AppInfo res = (AppInfo)((Right)either).value();
            task = new Task(Task$.MODULE$.point((Object)scala.package$.MODULE$.Right().apply((Object)res)));
        } else {
            throw new MatchError((Object)either);
        }
        Task task2 = task;
        if (task2 == null) {
            return null;
        }
        return task2.value();
    }

    private static final Option $anonfun$23$$anonfun$1$$anonfun$1(AppInfo info$2) {
        return info$2.appDescriptor().nameOpt();
    }

    private final Option descOpt$1(Seq appIds$1, Channels channels$1) {
        return appIds$1.headOption().map((Function1 & Serializable)id -> {
            Function1 function1 = channels$1.appDescriptor(id);
            Function1 function12 = new Task(Task$.MODULE$.attempt$extension(function1)).value();
            Either e = ((Either)Task$.MODULE$.PlatformTaskOps(Task$.MODULE$.flatMap$extension(function12, (Function1 & Serializable)x$1 -> new Task(Resolve$.$anonfun$22(x$1)))).unsafeRun(channels$1.cache().ec())).flatMap((Function1 & Serializable)info -> RawAppDescriptor$.MODULE$.parse(new String(info.appDescriptorBytes(), StandardCharsets.UTF_8)).map((Function1 & Serializable)rawDesc -> rawDesc.withName(rawDesc.name().orElse(() -> Resolve$.$anonfun$23$$anonfun$1$$anonfun$1(info))).overrideVersion(info.overrideVersionOpt(), true)));
            Either either = e;
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                System.err.println(err);
                throw scala.sys.package$.MODULE$.exit(1);
            }
            if (either instanceof Right) {
                RawAppDescriptor res = (RawAppDescriptor)((Right)either).value();
                return res;
            }
            throw new MatchError((Object)either);
        });
    }

    private final Option handleApps$$anonfun$1(Seq appIds$2, Channels channels$3) {
        return this.descOpt$1(appIds$2, channels$3);
    }

    private static final Tuple2 handleApps$$anonfun$2(Object options$1, Seq args$3) {
        return Tuple2$.MODULE$.apply(options$1, (Object)args$3);
    }

    private static final Tuple2 $anonfun$24(ResolveOptions options$3, RemainingArgs args$4) {
        return Tuple2$.MODULE$.apply((Object)options$3, (Object)args$4.all());
    }
}

