/*
 * Decompiled with CFR 0.152.
 */
package coursier.cli.util;

import cats.data.Chain;
import cats.data.Chain$;
import cats.data.NonEmptyChainImpl$;
import cats.data.NonEmptyChainOps$;
import cats.data.package$;
import cats.kernel.Eq;
import coursier.cli.util.TreeZipper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public final class TreeZipper<A> {
    private final Object path;
    private final Function1<A, Seq<A>> fetchChildren;
    private final Eq<A> evidence$1;
    private final Set<A> visited;

    public static <A> TreeZipper<A> of(A a, Function1<A, Seq<A>> function1, Eq<A> eq2) {
        return TreeZipper$.MODULE$.of(a, function1, eq2);
    }

    public TreeZipper(Object path, Function1<A, Seq<A>> fetchChildren, Eq<A> evidence$1) {
        this.path = path;
        this.fetchChildren = fetchChildren;
        this.evidence$1 = evidence$1;
        Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(path);
        this.visited = NonEmptyChainOps$.MODULE$.iterator$extension(object).toSet();
    }

    public A focus() {
        Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(this.path);
        return (A)NonEmptyChainOps$.MODULE$.head$extension(object);
    }

    private Chain<A> parents() {
        Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(this.path);
        return NonEmptyChainOps$.MODULE$.tail$extension(object);
    }

    public Option<TreeZipper<A>> moveDown() {
        Seq nonVisitedChildren = (Seq)((IterableOps)this.fetchChildren.apply(this.focus())).filterNot(this.visited);
        if (nonVisitedChildren.isEmpty()) {
            return None$.MODULE$;
        }
        Object object = nonVisitedChildren.head();
        Object object2 = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(this.path);
        Object newPath = NonEmptyChainOps$.MODULE$.$plus$colon$extension(object2, object);
        return Some$.MODULE$.apply(new TreeZipper<A>(newPath, this.fetchChildren, this.evidence$1));
    }

    public Option<TreeZipper<A>> moveUp() {
        return this.parents().uncons().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object item = tuple2._1();
                Chain superPath = (Chain)tuple2._2();
                Object parentPath = package$.MODULE$.NonEmptyChain().fromChainPrepend(item, superPath);
                return new TreeZipper<A>(parentPath, this.fetchChildren, this.evidence$1);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Chain<TreeZipper<A>> siblings() {
        return Chain$.MODULE$.fromOption(this.parents().headOption()).flatMap((Function1 & Serializable)parentItem -> {
            Seq seq = ((IterableOnceOps)((IterableOps)((SeqOps)this.fetchChildren.apply(parentItem)).view().filterNot(this.visited)).map((Function1 & Serializable)item -> {
                Object newPath = package$.MODULE$.NonEmptyChain().fromChainPrepend(item, this.parents());
                return new TreeZipper<A>(newPath, this.fetchChildren, this.evidence$1);
            })).toSeq();
            return Chain$.MODULE$.fromSeq(seq);
        });
    }

    public Chain<TreeZipper<A>> children() {
        return Chain$.MODULE$.fromOption(this.moveDown()).flatMap((Function1 & Serializable)child -> Chain$.MODULE$.one(child).$plus$plus(child.siblings()));
    }
}

