/*
 * Decompiled with CFR 0.152.
 */
package coursier.docker;

import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveCache$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.DigestArtifact;
import coursier.cache.DigestArtifact$;
import coursier.cache.DigestBasedArchiveCache;
import coursier.cache.DigestBasedArchiveCache$;
import coursier.cache.DigestBasedCache;
import coursier.cache.DigestBasedCache$;
import coursier.cache.FileCache;
import coursier.cache.FileCache$;
import coursier.docker.DockerBuild;
import coursier.docker.DockerFile;
import coursier.docker.DockerFile$;
import coursier.docker.DockerFile$WithLines$;
import coursier.docker.DockerImageConfig;
import coursier.docker.DockerImageConfig$Config$;
import coursier.docker.DockerImageLayer;
import coursier.docker.DockerImageLayer$;
import coursier.docker.DockerInstruction;
import coursier.docker.DockerPull;
import coursier.docker.DockerPull$;
import coursier.docker.DockerRun;
import coursier.docker.DockerRun$;
import coursier.docker.DockerUnpack$;
import coursier.docker.DockerUtil$;
import coursier.docker.vm.Vm;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import os.BasePathImpl;
import os.CommandResult;
import os.FilePath$;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.PermSet;
import os.PermSet$;
import os.ProcessOutput;
import os.ReadablePath;
import os.RelPath;
import os.RelPath$;
import os.Shellable;
import os.Shellable$;
import os.SubPath;
import os.SubPath$;
import os.read;
import os.size$;
import os.temp$;
import os.write$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

public final class DockerBuild$
implements Serializable {
    public static final DockerBuild$ MODULE$ = new DockerBuild$();

    private DockerBuild$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DockerBuild$.class);
    }

    public String sha256(InputStream is) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buf = new byte[16384];
        int read2 = 0;
        while ((read2 = is.read(buf)) >= 0) {
            md.update(buf, 0, read2);
        }
        byte[] b = md.digest();
        BigInteger num = new BigInteger(1, b);
        return String.format("%064x", num);
    }

    public String sha256(Path path) {
        return (String)Using$.MODULE$.resource((Object)read.inputStream$.MODULE$.apply((ReadablePath)path), (Function1 & Serializable)is -> MODULE$.sha256(new BufferedInputStream((InputStream)is)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Option<Tuple2<Path, String>> layerArchive(Path dir, Path archivePath, DockerRun.MaybeSudo maybeSudo) {
        IndexedSeq entries = (IndexedSeq)maybeSudo.list().apply(dir).map((Function1 & Serializable)_$1 -> _$1.relativeTo(dir).asSubPath().toString());
        if (entries.isEmpty()) {
            return None$.MODULE$;
        }
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.StringShellable("tar"), Shellable$.MODULE$.StringShellable("--sort=name"), Shellable$.MODULE$.StringShellable("--mtime=1970-01-01 00:00:00"), Shellable$.MODULE$.StringShellable("-zcf"), Shellable$.MODULE$.StringShellable(archivePath.toString()), Shellable$.MODULE$.IterableShellable((Iterable)entries, (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s))});
        maybeSudo.sudoWith((Seq<Shellable>)arraySeq, dir, maybeSudo.sudoWith$default$3((Seq<Shellable>)arraySeq), maybeSudo.sudoWith$default$4((Seq<Shellable>)arraySeq), maybeSudo.sudoWith$default$5((Seq<Shellable>)arraySeq));
        maybeSudo.perms().set().apply(archivePath, PermSet$.MODULE$.fromString("rw-r--r--"), maybeSudo.perms().set().apply$default$3());
        String sum = this.sha256(archivePath);
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)archivePath, (Object)sum));
    }

    public Tuple2<DockerImageConfig.Config, List<Tuple2<DockerImageLayer, Path>>> build(Path contextDir, Option<Path> dockerFile, Option<Vm> vmOpt, String authRegistry, FileCache<Task> cache, String os0, String arch, Option<String> archVariant) {
        Path dockerFile0 = (Path)dockerFile.getOrElse(() -> DockerBuild$.$anonfun$3(contextDir));
        IndexedSeq dockerFileLines = read.lines$.MODULE$.apply((ReadablePath)dockerFile0);
        Seq res = (Seq)DockerFile$.MODULE$.parse((Iterator<DockerFile.WithLines<String>>)dockerFileLines.iterator().zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return DockerFile$WithLines$.MODULE$.apply(line, (SortedSet<Object>)((SortedSet)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{idx}), (Object)Ordering.Int$.MODULE$)));
            }
            throw new MatchError((Object)tuple2);
        })).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get();
        Tuple2 tuple2 = (Tuple2)DockerFile$.MODULE$.validateShape((Seq<DockerFile.WithLines<DockerInstruction>>)res).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DockerFile.WithLines from = (DockerFile.WithLines)tuple2._1();
        Seq others = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)from, (Object)others);
        DockerFile.WithLines from2 = (DockerFile.WithLines)tuple22._1();
        Seq others2 = (Seq)tuple22._2();
        Tuple2<String, String> tuple23 = DockerUtil$.MODULE$.repoNameVersion(((DockerInstruction.From)from2.value()).imageName());
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        String repoName = (String)tuple23._1();
        String repoVersion = (String)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)repoName, (Object)repoVersion);
        String repoName2 = (String)tuple24._1();
        String repoVersion2 = (String)tuple24._2();
        return this.build(repoName2, repoVersion2, contextDir, authRegistry, cache, (Seq<DockerFile.WithLines<DockerInstruction.NonHead>>)others2, dockerFile0.toString(), os0, arch, archVariant, vmOpt);
    }

    public String build$default$4() {
        return DockerPull$.MODULE$.defaultAuthRegistry();
    }

    public FileCache<Task> build$default$5() {
        return FileCache$.MODULE$.apply(Task$.MODULE$.sync());
    }

    public String build$default$6() {
        return DockerPull$.MODULE$.defaultOs();
    }

    public String build$default$7() {
        return DockerPull$.MODULE$.defaultArch();
    }

    public Option<String> build$default$8() {
        return DockerPull$.MODULE$.defaultArchVariant();
    }

    public Tuple2<DockerImageConfig.Config, List<Tuple2<DockerImageLayer, Path>>> build(String fromRepoName, String fromRepoVersion, Path contextDir, String authRegistry, FileCache<Task> cache, Seq<DockerFile.WithLines<DockerInstruction.NonHead>> instructions, String dockerFile, String os0, String arch, Option<String> archVariant, Option<Vm> vmOpt) {
        DockerPull.Result dockerPullResults = DockerPull$.MODULE$.pull(fromRepoName, fromRepoVersion, os0, arch, archVariant, authRegistry, (Cache<Task>)cache);
        ObjectRef config = ObjectRef.create((Object)DockerImageConfig$Config$.MODULE$.apply((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin", (List)new .colon.colon((Object)"TERM=xterm", (List)Nil$.MODULE$)))), (Seq<String>)package$.MODULE$.Nil(), (Option<String>)None$.MODULE$));
        ObjectRef layers = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef shell = ObjectRef.create((Object)((Seq)((SeqOps)new .colon.colon((Object)"/bin/sh", (List)new .colon.colon((Object)"-c", (List)Nil$.MODULE$)))));
        UUID uuid = UUID.randomUUID();
        String containerName = DockerRun$.MODULE$.defaultContainerName() + "-build-" + uuid;
        ArchiveCache priviledgedArchiveCache = ArchiveCache$.MODULE$.priviledged(ArchiveCache$.MODULE$.priviledged$default$1());
        DigestBasedArchiveCache priviledgedDigestArchiveCache = DigestBasedArchiveCache$.MODULE$.apply(priviledgedArchiveCache, Task$.MODULE$.sync());
        DigestBasedCache digestCache = DigestBasedCache$.MODULE$.apply();
        DockerRun.MaybeSudo maybeSudo = new DockerRun.MaybeSudo(true);
        instructions.foreach((Function1)(JProcedure1 & Serializable)inst -> {
            DockerInstruction.NonHead nonHead = (DockerInstruction.NonHead)inst.value();
            if (nonHead instanceof DockerInstruction.Cmd) {
                DockerInstruction.Cmd cmd = (DockerInstruction.Cmd)nonHead;
                DockerImageConfig.Config config = (DockerImageConfig.Config)config$2.elem;
                config$2.elem = config.copy(config.copy$default$1(), cmd.command(), config.copy$default$3());
                return;
            }
            if (nonHead instanceof DockerInstruction.WorkDir) {
                DockerInstruction.WorkDir workDir = (DockerInstruction.WorkDir)nonHead;
                DockerImageConfig.Config config = (DockerImageConfig.Config)config$2.elem;
                Some some = Some$.MODULE$.apply((Object)workDir.path());
                Seq<String> seq = config.copy$default$1();
                Seq<String> seq2 = config.copy$default$2();
                config$2.elem = config.copy(seq, seq2, (Option<String>)some);
                return;
            }
            if (nonHead instanceof DockerInstruction.Expose) {
                DockerInstruction.Expose expose = (DockerInstruction.Expose)nonHead;
                DockerImageConfig.Config config = (DockerImageConfig.Config)config$2.elem;
                config$2.elem = config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3());
                System.err.println("Ignore exposed instruction " + expose);
                return;
            }
            if (nonHead instanceof DockerInstruction.Copy) {
                Path path;
                DockerInstruction.Copy copy = (DockerInstruction.Copy)nonHead;
                BasePathImpl basePathImpl = FilePath$.MODULE$.apply((Object)copy.from(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
                if (basePathImpl instanceof Path) {
                    Path p;
                    path = p = (Path)basePathImpl;
                } else if (basePathImpl instanceof SubPath) {
                    SubPath s = (SubPath)basePathImpl;
                    path = contextDir.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(s));
                } else if (basePathImpl instanceof RelPath) {
                    RelPath r = (RelPath)basePathImpl;
                    path = contextDir.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(SubPath$.MODULE$.apply(r.segments())));
                } else {
                    throw new MatchError((Object)basePathImpl);
                }
                Path from = path;
                if (!copy.to().startsWith("/")) {
                    throw scala.sys.package$.MODULE$.error(dockerFile + ":" + inst.lines().head() + ": Expected COPY destination to start with '/'");
                }
                SubPath to = SubPath$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(copy.to()), "/"), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
                PermSet permSet = PermSet$.MODULE$.fromString("rwxr-xr-x");
                Path path2 = temp$.MODULE$.dir$default$1();
                boolean bl = temp$.MODULE$.dir$default$3();
                Path tmpDir = temp$.MODULE$.dir(path2, "cs-docker-build", bl, permSet);
                try {
                    Path dest = tmpDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"dest"})));
                    maybeSudo.makeDir().all().apply(dest);
                    maybeSudo.copy().apply(from, dest.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(to)), true);
                    maybeSudo.owner().set().apply(dest.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(to)), "root", "root", maybeSudo.owner().set().apply$default$4());
                    Path archivePath = tmpDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"archive.tar"})));
                    Option<Tuple2<Path, String>> layerOpt = this.layerArchive(dest, archivePath, maybeSudo);
                    layerOpt.withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Path path = (Path)tuple2._1();
                            String digest = (String)tuple2._2();
                            return true;
                        }
                        return false;
                    }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Path path = (Path)tuple2._1();
                            String digest = (String)tuple2._2();
                            Path path0 = Path$.MODULE$.apply((Object)digestCache.import(DigestArtifact$.MODULE$.apply(digest, path.toNIO())), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$);
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)DockerImageLayer$.MODULE$.apply(size$.MODULE$.apply(path0), digest, DockerImageLayer$.MODULE$.mediaType()), (Object)path0);
                            layers$2.elem = ((List)layers$2.elem).$colon$colon((Object)tuple22);
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                finally {
                    maybeSudo.remove().all().apply(tmpDir);
                }
                return;
            }
            if (nonHead instanceof DockerInstruction.Run) {
                boolean bl;
                ProcessOutput processOutput;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                DockerInstruction.Run run = (DockerInstruction.Run)nonHead;
                DockerImageConfig.Config config = (DockerImageConfig.Config)config$2.elem;
                Seq seq = (Seq)((Seq)shell$1.elem).$colon$plus((Object)run.command().mkString(" "));
                Seq<String> seq3 = config.copy$default$1();
                Option<String> option = config.copy$default$3();
                DockerImageConfig.Config config2 = config.copy(seq3, (Seq<String>)seq, option);
                Function0 & Serializable intersect = (Function0 & Serializable)() -> (Seq)((IterableOps)dockerPullResults.layerFiles().map((Function1 & Serializable)_$2 -> Path$.MODULE$.apply(_$2, (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$))).$plus$plus((IterableOnce)((List)layers$3.elem).reverse().map((Function1 & Serializable)_$3 -> (Path)_$3._2()));
                Function0 & Serializable intersect2 = (Function0 & Serializable)() -> {
                    Seq fromBase = (Seq)DockerUnpack$.MODULE$.unpack((ArchiveCache<Task>)priviledgedArchiveCache, dockerPullResults.layerArtifacts()).map((Function1 & Serializable)_$4 -> Path$.MODULE$.apply(_$4, (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$));
                    List fromBuiltLayersTasks = ((List)layers$4.elem).reverse().map((Function1 & Serializable)x$1 -> new Task(DockerBuild$.$anonfun$8(priviledgedDigestArchiveCache, x$1)));
                    Object object = Task$.MODULE$.gather().gather((Seq)fromBuiltLayersTasks);
                    Seq fromBuiltLayersOrErrors = (Seq)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun(true, (ExecutionContext)cache.ec());
                    Seq fromBuiltErrors = (Seq)fromBuiltLayersOrErrors.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Either x) {
                            Either either = x;
                            if (either instanceof Left) {
                                ArtifactError err = (ArtifactError)((Left)either).value();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Either x, Function1 function1) {
                            Either either = x;
                            if (either instanceof Left) {
                                ArtifactError err = (ArtifactError)((Left)either).value();
                                return err;
                            }
                            return function1.apply((Object)x);
                        }
                    });
                    Seq seq = fromBuiltErrors;
                    if (seq == null) throw new MatchError((Object)seq);
                    SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) != 0) {
                        Seq seq2;
                        ArtifactError artifactError;
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) < 0) throw new MatchError((Object)seq);
                        ArtifactError first = artifactError = (ArtifactError)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                        Seq others = seq2 = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(seqOps, 1);
                        others.foreach((Function1)(JProcedure1 & Serializable)other -> first.addSuppressed((Throwable)other));
                        throw new Exception((Throwable)first);
                    }
                    Seq fromBuiltLayers = (Seq)fromBuiltLayersOrErrors.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Either x) {
                            Either either = x;
                            if (either instanceof Right) {
                                File f = (File)((Right)either).value();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Either x, Function1 function1) {
                            Either either = x;
                            if (either instanceof Right) {
                                File f = (File)((Right)either).value();
                                return Path$.MODULE$.apply((Object)f, (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$);
                            }
                            return function1.apply((Object)x);
                        }
                    });
                    return (Seq)fromBase.$plus$plus((IterableOnce)fromBuiltLayers);
                };
                Some some = Some$.MODULE$.apply((JProcedure1 & Serializable)upperDir -> {
                    PermSet permSet = PermSet$.MODULE$.fromString("rwxr-xr-x");
                    Path path = temp$.MODULE$.dir$default$1();
                    boolean bl = temp$.MODULE$.dir$default$3();
                    Path tmpDir = temp$.MODULE$.dir(path, "cs-docker-build", bl, permSet);
                    try {
                        Path archivePath = tmpDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"archive.tar.gz"})));
                        Option<Tuple2<Path, String>> layerOpt = MODULE$.layerArchive((Path)upperDir, archivePath, maybeSudo);
                        layerOpt.withFilter((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Path path = (Path)tuple2._1();
                                String digest = (String)tuple2._2();
                                return true;
                            }
                            return false;
                        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Path path = (Path)tuple2._1();
                                String digest = (String)tuple2._2();
                                Path path0 = Path$.MODULE$.apply((Object)digestCache.import(DigestArtifact$.MODULE$.apply(digest, path.toNIO())), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$);
                                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)DockerImageLayer$.MODULE$.apply(size$.MODULE$.apply(path0), digest, DockerImageLayer$.MODULE$.mediaType()), (Object)path0);
                                layers$6.elem = ((List)layers$6.elem).$colon$colon((Object)tuple22);
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    finally {
                        maybeSudo.remove().all().apply(tmpDir);
                    }
                });
                Some some2 = Some$.MODULE$.apply((JProcedure1 & Serializable)upperDirArchive -> {
                    None$ none$;
                    boolean archiveIsEmpty = BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.resource((Object)read.inputStream$.MODULE$.apply((ReadablePath)upperDirArchive), (Function1 & Serializable)is -> new TarArchiveInputStream(is).getNextEntry() == null, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                    if (archiveIsEmpty) {
                        none$ = None$.MODULE$;
                    } else {
                        String s$proxy1 = upperDirArchive.last() + ".gz";
                        Path dest = upperDirArchive.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())).$div((PathChunk)new PathChunk.StringPathChunk(s$proxy1));
                        Using$.MODULE$.resources((Object)read.inputStream$.MODULE$.apply((ReadablePath)upperDirArchive), () -> DockerBuild$.$anonfun$12(dest), (Function2)(JProcedure2 & Serializable)(is, os) -> {
                            public final class Coursier_docker_DockerBuild$PatchOutputStream$1
                            extends OutputStream {
                                private final OutputStream underlying;
                                private int count;
                                private final int patchByteAtIndex;
                                private final int forcedPatchedByteValue;

                                public Coursier_docker_DockerBuild$PatchOutputStream$1(OutputStream underlying) {
                                    this.underlying = underlying;
                                    this.count = 0;
                                    this.patchByteAtIndex = 9;
                                    this.forcedPatchedByteValue = 3;
                                }

                                public int count() {
                                    return this.count;
                                }

                                public void count_$eq(int x$1) {
                                    this.count = x$1;
                                }

                                public int patchByteAtIndex() {
                                    return this.patchByteAtIndex;
                                }

                                public int forcedPatchedByteValue() {
                                    return this.forcedPatchedByteValue;
                                }

                                public void write(int n) {
                                    this.underlying.write(this.count() == this.patchByteAtIndex() ? this.forcedPatchedByteValue() : n);
                                    if (this.count() <= this.patchByteAtIndex()) {
                                        this.count_$eq(this.count() + 1);
                                        return;
                                    }
                                }

                                public void write(byte[] b, int off, int len) {
                                    if (this.count() <= this.patchByteAtIndex() && this.count() + len > this.patchByteAtIndex()) {
                                        this.underlying.write(b, off, this.patchByteAtIndex() - this.count());
                                        this.underlying.write(this.forcedPatchedByteValue());
                                        this.underlying.write(b, off + this.patchByteAtIndex() - this.count() + 1, len - (this.patchByteAtIndex() - this.count() + 1));
                                    } else {
                                        this.underlying.write(b, off, len);
                                    }
                                    if (this.count() <= this.patchByteAtIndex()) {
                                        this.count_$eq(this.count() + len);
                                        return;
                                    }
                                }
                            }
                            GZIPOutputStream gzos = new GZIPOutputStream(new Coursier_docker_DockerBuild$PatchOutputStream$1((OutputStream)os));
                            byte[] buf = new byte[16384];
                            int read2 = 0;
                            while ((read2 = is.read(buf)) >= 0) {
                                gzos.write(buf, 0, read2);
                            }
                            gzos.finish();
                            gzos.flush();
                        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                        none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)dest, (Object)this.sha256(dest)));
                    }
                    None$ layerOpt = none$;
                    layerOpt.withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Path path = (Path)tuple2._1();
                            String digest = (String)tuple2._2();
                            return true;
                        }
                        return false;
                    }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Path path = (Path)tuple2._1();
                            String digest = (String)tuple2._2();
                            Path path0 = Path$.MODULE$.apply((Object)digestCache.import(DigestArtifact$.MODULE$.apply(digest, path.toNIO())), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$);
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)DockerImageLayer$.MODULE$.apply(size$.MODULE$.apply(path0), digest, DockerImageLayer$.MODULE$.mediaType()), (Object)path0);
                            layers$8.elem = ((List)layers$8.elem).$colon$colon((Object)tuple22);
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                });
                String string = DockerRun$.MODULE$.run$default$8();
                CommandResult res = DockerRun$.MODULE$.run(cache, (DigestBasedCache<Task>)digestCache, config2, (Function0<Seq<Path>>)intersect, (Function0<Seq<Path>>)intersect2, containerName, vmOpt, string, bl4 = DockerRun$.MODULE$.run$default$9(), bl3 = DockerRun$.MODULE$.run$default$10(), (Option<Function1<Path, BoxedUnit>>)some, (Option<Function1<Path, BoxedUnit>>)some2, bl2 = DockerRun$.MODULE$.run$default$13(), processOutput = DockerRun$.MODULE$.run$default$14(), bl = DockerRun$.MODULE$.run$default$15());
                if (res.exitCode() != 0) {
                    System.err.println(dockerFile + ":" + inst.lines().head() + ": command failed with exit code " + res.exitCode());
                    throw scala.sys.package$.MODULE$.exit(res.exitCode());
                }
                return;
            }
            throw new MatchError((Object)nonHead);
        });
        return Tuple2$.MODULE$.apply((Object)((DockerImageConfig.Config)config.elem), (Object)((List)layers.elem).reverse());
    }

    private static final Path $anonfun$3(Path contextDir$1) {
        return contextDir$1.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"Dockerfile"})));
    }

    private static final /* synthetic */ Function1 $anonfun$8(DigestBasedArchiveCache priviledgedDigestArchiveCache$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            DockerImageLayer info = (DockerImageLayer)tuple2._1();
            Path path = (Path)tuple2._2();
            DigestArtifact art = DigestArtifact$.MODULE$.apply(info.digest(), path.toNIO());
            Object object = priviledgedDigestArchiveCache$3.get(art);
            if (object == null) {
                return null;
            }
            return ((Task)object).value();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final OutputStream $anonfun$12(Path dest$1) {
        return write$.MODULE$.outputStream(dest$1, write$.MODULE$.outputStream$default$2(), write$.MODULE$.outputStream$default$3(), write$.MODULE$.outputStream$default$4());
    }
}

