/*
 * Decompiled with CFR 0.152.
 */
package coursier.docker;

import com.jcraft.jsch.Session;
import coursier.cache.DigestBasedCache;
import coursier.cache.FileCache;
import coursier.docker.DockerVm$;
import coursier.docker.vm.Vm;
import coursier.docker.vm.Vm$;
import coursier.util.Task;
import java.io.Serializable;
import java.util.UUID;
import os.CommandResult;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.ProcessOutput;
import os.RelPath$;
import os.SegmentedPath;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.SubPath;
import os.remove$;
import os.write$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class DockerVm {
    public static void pullContainer(Path path, FileCache<Task> fileCache, Seq<Path> seq, Vm vm, Session session, boolean bl) {
        DockerVm$.MODULE$.pullContainer(path, fileCache, seq, vm, session, bl);
    }

    public static CommandResult runContainer(Path path, FileCache<Task> fileCache, DigestBasedCache<Task> digestBasedCache, Seq<Path> seq, String string, Path path2, Path path3, Vm vm, Session session, ProcessOutput processOutput, Option<Function1<Path, BoxedUnit>> option, boolean bl) {
        return DockerVm$.MODULE$.runContainer(path, fileCache, digestBasedCache, seq, string, path2, path3, vm, session, processOutput, option, bl);
    }

    public static boolean pullContainer$default$6() {
        return DockerVm$.MODULE$.pullContainer$default$6();
    }

    public static ProcessOutput runContainer$default$10() {
        return DockerVm$.MODULE$.runContainer$default$10();
    }

    public static Option<Function1<Path, BoxedUnit>> runContainer$default$11() {
        return DockerVm$.MODULE$.runContainer$default$11();
    }

    public static boolean runContainer$default$12() {
        return DockerVm$.MODULE$.runContainer$default$12();
    }

    public static class Pull {
        private final Path workDir;
        private final FileCache<Task> cache;
        private final Option<DigestBasedCache<Task>> digestCacheOpt;
        private final Vm vm;
        private final Session session;
        private final boolean debug;
        private final UUID randomUuid;
        private final SubPath vmPriviledgedArchiveCachePath;

        public Pull(Path workDir, FileCache<Task> cache, Option<DigestBasedCache<Task>> digestCacheOpt, Vm vm, Session session, boolean debug) {
            this.workDir = workDir;
            this.cache = cache;
            this.digestCacheOpt = digestCacheOpt;
            this.vm = vm;
            this.session = session;
            this.debug = debug;
            this.randomUuid = UUID.randomUUID();
            this.vmPriviledgedArchiveCachePath = (SubPath)os.package$.MODULE$.sub().$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"cs", "parc"})));
        }

        public UUID randomUuid() {
            return this.randomUuid;
        }

        public SubPath toVmPath(Path path) {
            return (SubPath)this.vm.params().mounts().collectFirst((PartialFunction)new Serializable(path){
                private final Path path$1;
                {
                    this.path$1 = path$3;
                }

                public final boolean isDefinedAt(Vm.Mount x) {
                    Vm.Mount mount = x;
                    Vm.Mount mount2 = mount;
                    return this.path$1.startsWith(mount2.hostPath());
                }

                public final Object applyOrElse(Vm.Mount x, Function1 function1) {
                    Vm.Mount mount = x;
                    Vm.Mount mount2 = mount;
                    if (this.path$1.startsWith(mount2.hostPath())) {
                        return (SubPath)mount2.guestPath().$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(this.path$1.relativeTo(mount2.hostPath()).asSubPath()));
                    }
                    return function1.apply((Object)x);
                }
            }).getOrElse(() -> DockerVm$.coursier$docker$DockerVm$Pull$$_$toVmPath$$anonfun$1(path));
        }

        public String toVmPathStr(Path path) {
            return "/" + this.toVmPath(path).toString();
        }

        public SubPath vmPriviledgedArchiveCachePath() {
            return this.vmPriviledgedArchiveCachePath;
        }

        public SubPath vmUnpackPathFor(Path archive) {
            SubPath subPath;
            if (archive.startsWith(Path$.MODULE$.apply((Object)this.cache.location(), (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$))) {
                subPath = archive.relativeTo(Path$.MODULE$.apply((Object)this.cache.location(), (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$)).asSubPath();
            } else {
                DigestBasedCache digestCache;
                Option<DigestBasedCache<Task>> option = this.digestCacheOpt;
                if (option instanceof Some && archive.startsWith(Path$.MODULE$.apply((Object)(digestCache = (DigestBasedCache)((Some)option).value()).location(), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$))) {
                    subPath = (SubPath)((SegmentedPath)os.package$.MODULE$.sub().$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"digest"})))).$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(archive.relativeTo(Path$.MODULE$.apply((Object)digestCache.location(), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$)).asSubPath()));
                } else {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
            }
            SubPath archiveSubPath = subPath;
            return (SubPath)this.vmPriviledgedArchiveCachePath().$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(archiveSubPath));
        }

        public String ifDebug(Function0<String> s) {
            if (this.debug) {
                return (String)s.apply();
            }
            return "";
        }

        public String unpackLayerScript(Path archive) {
            SubPath vmArchivePath = this.toVmPath(archive);
            SubPath dest = this.vmUnpackPathFor(archive);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#!/usr/bin/env bash\n         |set -e\n         |\n         |if [ ! -d \"/" + this.vmPriviledgedArchiveCachePath() + "\" ]; then\n         |  mkdir -p \"/" + this.vmPriviledgedArchiveCachePath() + "\"\n         |fi\n         |\n         |chown root:root \"/" + this.vmPriviledgedArchiveCachePath() + "\"\n         |\n         |DEST=\"/" + dest + "\"\n         |\n         |if [ -d \"$DEST\" ]; then" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Pull$$_$unpackLayerScript$$anonfun$1(vmArchivePath))) + "\n         |  exit 0\n         |fi\n         |\n         |TMP_DEST=\"/" + dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())) + "/." + dest.last() + "." + this.randomUuid() + "\"\n         |mkdir -p \"$TMP_DEST\"\n         |\n         |# TODO trap thing to clean-up $TMP_DEST\n         |\n         |cd \"$TMP_DEST\"" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Pull$$_$unpackLayerScript$$anonfun$2(vmArchivePath))) + "\n         |tar -zxf \"/" + vmArchivePath + "\"\n         |\n         |if [ -d \"$DEST\" ]; then\n         |  echo \"$DEST created concurrently\" 1>&2\n         |  rm -rf \"$TMP_DEST\"\n         |  exit 0\n         |fi\n         |\n         |# FIXME Can we ensure this is atomic?\n         |# FIXME Can we ensure $DEST isn't created in the mean time and we don't end up as a sub-directory of it?\n         |mv \"$TMP_DEST\" \"$DEST\"" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Pull$$_$unpackLayerScript$$anonfun$3(vmArchivePath))) + "\n         |"));
        }

        public void runAsSudoViaWorkDir(String name, String script) {
            String s$proxy1 = name + ".sh";
            Path scriptPath = this.workDir.$div((PathChunk)new PathChunk.StringPathChunk(s$proxy1));
            write$.MODULE$.apply(scriptPath, (Source)Source$.MODULE$.WritableSource((Object)script, DockerVm$::coursier$docker$DockerVm$Pull$$_$runAsSudoViaWorkDir$$anonfun$1), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
            Vm$.MODULE$.runCommand(this.session, Vm$.MODULE$.runCommand$default$2(), Vm$.MODULE$.runCommand$default$3(), Vm$.MODULE$.runCommand$default$4(), Vm$.MODULE$.runCommand$default$5(), (Seq<Shellable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.StringShellable("sudo"), Shellable$.MODULE$.StringShellable("bash"), Shellable$.MODULE$.StringShellable(this.toVmPathStr(scriptPath))}));
            remove$.MODULE$.apply(scriptPath);
        }
    }

    public static class Run
    extends Pull {
        private final Seq<Path> layerFiles;
        private final String rootFsDirName;
        private final boolean debug;
        private final SubPath vmUnionFsWorkDir;

        public Run(Path workDir, FileCache<Task> cache, DigestBasedCache<Task> digestCache, Seq<Path> layerFiles, String rootFsDirName, Vm vm, Session session, boolean debug) {
            this.layerFiles = layerFiles;
            this.rootFsDirName = rootFsDirName;
            this.debug = debug;
            super(workDir, cache, (Option<DigestBasedCache<Task>>)Some$.MODULE$.apply(digestCache), vm, session, debug);
            String s$proxy2 = this.randomUuid().toString();
            this.vmUnionFsWorkDir = (SubPath)((SegmentedPath)os.package$.MODULE$.sub().$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"overlays"})))).$div((PathChunk)new PathChunk.StringPathChunk(s$proxy2));
        }

        public SubPath vmUnionFsWorkDir() {
            return this.vmUnionFsWorkDir;
        }

        public String makeUnionFsScript() {
            String bt = "\\";
            Seq lowerDirs = (Seq)((IterableOps)this.layerFiles.map((Function1 & Serializable)archive -> this.vmUnpackPathFor((Path)archive))).map(DockerVm$::coursier$docker$DockerVm$Run$$_$_$$anonfun$2);
            String arg = "\"lowerdir=" + lowerDirs + ",upperdir=$WORKDIR/upper,workdir=$WORKDIR/work\"";
            int maxGroupSize = 2048;
            List groups0 = this.groups$1(maxGroupSize, (List)package$.MODULE$.Nil(), lowerDirs.toList(), (List)package$.MODULE$.Nil(), 0).reverse();
            String scriptPart = ((List)groups0.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int groupIdx;
                    List group2 = (List)tuple2._1();
                    return this.groupScript$1(bt, (Seq)group2, groupIdx, (groupIdx = BoxesRunTime.unboxToInt((Object)tuple2._2())) == groups0.length() - 1);
                }
                throw new MatchError((Object)tuple2);
            }).mkString();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#!/usr/bin/env bash\n         |set -eu\n         |WORKDIR=\"/" + this.vmUnionFsWorkDir() + "\"\n         |")) + scriptPart;
        }

        public String cleanUpUnionFsScript() {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#!/usr/bin/env bash\n         |set -e\n         |WORKDIR=\"/overlays/" + this.randomUuid() + "\"\n         |sudo umount \"$WORKDIR/" + this.rootFsDirName + "\"\n         |sudo rm -rf \"$WORKDIR/upper\"\n         |sudo rm -rf \"$WORKDIR/work\"\n         |"));
        }

        public <T> T withUnionFs(Function1<SubPath, T> f) {
            Object object;
            this.runAsSudoViaWorkDir("make-fs", this.makeUnionFsScript());
            try {
                String s$proxy3 = this.randomUuid().toString();
                object = f.apply((Object)((SegmentedPath)((SegmentedPath)os.package$.MODULE$.sub().$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"overlays"})))).$div((PathChunk)new PathChunk.StringPathChunk(s$proxy3))).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"upper"}))));
            }
            finally {
                this.runAsSudoViaWorkDir("unmount-fs", this.cleanUpUnionFsScript());
            }
            return (T)object;
        }

        public String runcScript(Path runcFile, Path configFile, Option<Tuple2<SubPath, Path>> keepArchive) {
            Object object;
            Tuple2 tuple2;
            String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#!/usr/bin/env bash\n           |set -e\n           |cd \"/" + this.vmUnionFsWorkDir() + "\"\n           |cp \"" + this.toVmPathStr(configFile) + "\" config.json\n           |"));
            String mainCommand = this.toVmPathStr(runcFile) + " run cs-test-container";
            Option<Tuple2<SubPath, Path>> option = keepArchive;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                SubPath vmDir = (SubPath)tuple2._1();
                Path archiveDest = (Path)tuple2._2();
                SubPath archiveDestInVm = this.toVmPath(archiveDest);
                object = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("set +e\n             |" + mainCommand + "\n             |EXIT_CODE=$?\n             |set -e" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Run$$_$_$$anonfun$4(archiveDestInVm))) + "\n             |if [ -z \"$(ls -A \"/" + vmDir + "\" 2>/dev/null)\" ]; then\n             |  " + (this.debug ? "echo \"No new files\" 1>&2" : ":") + "\n             |else\n             |  ( cd \"/" + vmDir + "\" && shopt -s dotglob nullglob && tar --sort=name --mtime='1970-01-01 00:00:00' -cvf \"/" + archiveDestInVm + "\" * )" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Run$$_$_$$anonfun$5(archiveDestInVm))) + "\n             |fi\n             |exit \"$EXIT_CODE\"\n             |"));
            } else if (None$.MODULE$.equals(option)) {
                object = "exec " + mainCommand + "\n";
            } else {
                throw new MatchError(option);
            }
            String mainContent = object;
            return header + mainContent;
        }

        private final List groups$1(int maxGroupSize$1, List acc, List input, List current, int currentSize) {
            List list;
            while (true) {
                list = input;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    if (current.isEmpty()) {
                        return acc.reverse();
                    }
                    List list3 = current.reverse();
                    List list4 = acc.$colon$colon((Object)list3);
                    Nil$ nil$2 = package$.MODULE$.Nil();
                    int n = 0;
                    acc = list4;
                    current = nil$2;
                    currentSize = n;
                    continue;
                }
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                List list5 = colon2.next$access$1();
                String h = (String)colon2.head();
                List t = list5;
                if (h.length() > maxGroupSize$1) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (currentSize + h.length() > maxGroupSize$1) {
                    List list6 = current.reverse();
                    List list7 = acc.$colon$colon((Object)list6);
                    Nil$ nil$3 = package$.MODULE$.Nil();
                    int n = 0;
                    acc = list7;
                    current = nil$3;
                    currentSize = n;
                    continue;
                }
                List list8 = t;
                List list9 = current.$colon$colon((Object)h);
                int n = h.length() + currentSize;
                input = list8;
                current = list9;
                currentSize = n;
            }
            throw new MatchError((Object)list);
        }

        private final String groupScript$1(String bt$1, Seq elems, int index, boolean isLast) {
            Object suffixIfNotLast = isLast ? "" : "-" + index;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |mkdir -p \"$WORKDIR/upper" + (String)suffixIfNotLast + "\"\n           |mkdir -p \"$WORKDIR/work-" + index + "\"\n           |mkdir -p \"$WORKDIR/" + this.rootFsDirName + (String)suffixIfNotLast + "\"" + this.ifDebug((Function0<String>)((Function0 & Serializable)() -> DockerVm$.coursier$docker$DockerVm$Run$$_$groupScript$1$$anonfun$1(index))) + "\n           |mount " + bt$1 + "\n           |  -o \"lowerdir=" + elems.mkString(":") + ",upperdir=$WORKDIR/upper" + (String)suffixIfNotLast + ",workdir=$WORKDIR/work-" + index + "\" " + bt$1 + "\n           |  -t overlay " + bt$1 + "\n           |  overlay \"$WORKDIR/" + this.rootFsDirName + (String)suffixIfNotLast + "\"\n           |"));
        }
    }
}

