/*
 * Decompiled with CFR 0.152.
 */
package coursier.docker;

import com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.util.Cpu;
import coursier.cache.util.Cpu$;
import coursier.docker.Runc;
import coursier.docker.Runc$Config$;
import coursier.docker.Runc$Config$Linux$;
import coursier.docker.Runc$Config$LinuxDevice$;
import coursier.docker.Runc$Config$LinuxNamespace$;
import coursier.docker.Runc$Config$LinuxResources$;
import coursier.docker.Runc$Config$Mount$;
import coursier.docker.Runc$Config$Process$;
import coursier.docker.Runc$Config$Rlimit$;
import coursier.docker.Runc$Config$Root$;
import coursier.docker.Runc$Config$User$;
import coursier.util.Artifact;
import coursier.util.Artifact$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Runc$
implements Serializable {
    public static final Runc$Config$ Config;
    public static final Runc$ MODULE$;

    private Runc$() {
    }

    static {
        MODULE$ = new Runc$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Runc$.class);
    }

    public String defaultRuncVersion() {
        return "1.2.4";
    }

    public String defaultCrunVersion() {
        return "1.20";
    }

    public Artifact runcArtifact(String version, Cpu cpu) {
        String string;
        Cpu cpu2 = cpu;
        if (Cpu.X86_64$.MODULE$.equals(cpu2)) {
            string = "amd64";
        } else if (Cpu.Arm64$.MODULE$.equals(cpu2)) {
            string = "arm64";
        } else {
            throw new MatchError((Object)cpu2);
        }
        String cpuPart = string;
        return Artifact$.MODULE$.apply("https://github.com/opencontainers/runc/releases/download/v" + version + "/runc." + cpuPart);
    }

    public String runcArtifact$default$1() {
        return this.defaultRuncVersion();
    }

    public Cpu runcArtifact$default$2() {
        return Cpu$.MODULE$.get();
    }

    public Artifact crunArtifact(String version, Cpu cpu) {
        String string;
        Cpu cpu2 = cpu;
        if (Cpu.X86_64$.MODULE$.equals(cpu2)) {
            string = "amd64";
        } else if (Cpu.Arm64$.MODULE$.equals(cpu2)) {
            string = "arm64";
        } else {
            throw new MatchError((Object)cpu2);
        }
        String cpuPart = string;
        return Artifact$.MODULE$.apply("https://github.com/containers/crun/releases/download/" + version + "/crun-" + version + "-linux-" + cpuPart);
    }

    public String crunArtifact$default$1() {
        return this.defaultCrunVersion();
    }

    public Cpu crunArtifact$default$2() {
        return Cpu$.MODULE$.get();
    }

    public File runc(Cache<Task> cache) {
        CacheLogger logger = (CacheLogger)cache.loggerOpt().getOrElse(Runc$::$anonfun$1);
        Artifact runcArtifact = this.crunArtifact(this.crunArtifact$default$1(), this.crunArtifact$default$2());
        Object object = logger.using().apply(cache.file(runcArtifact).run(), Task$.MODULE$.sync());
        Function1 function1 = object == null ? null : ((Task)object).value();
        Either either = (Either)Await$.MODULE$.result((Awaitable)Task$.MODULE$.future$extension(function1, cache.ec()), (Duration)Duration$.MODULE$.Inf());
        if (either instanceof Left) {
            ArtifactError err = (ArtifactError)((Left)either).value();
            throw new Exception((Throwable)err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        File f = (File)((Right)either).value();
        File runcFile = f;
        boolean runcMadeExecutable = runcFile.setExecutable(true, false);
        if (!runcMadeExecutable) {
            System.err.println("Warning: could not make " + runcFile + " executable, proceeding anyway");
        }
        return runcFile;
    }

    public Runc.Config config(boolean terminal, Seq<String> env, String cwd, Seq<String> cmd, String rootFsDirName) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bounding");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((SeqOps)new .colon.colon((Object)"CAP_AUDIT_WRITE", (List)new .colon.colon((Object)"CAP_KILL", (List)new .colon.colon((Object)"CAP_NET_BIND_SERVICE", (List)Nil$.MODULE$)))));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"effective");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((SeqOps)new .colon.colon((Object)"CAP_AUDIT_WRITE", (List)new .colon.colon((Object)"CAP_KILL", (List)new .colon.colon((Object)"CAP_NET_BIND_SERVICE", (List)Nil$.MODULE$)))));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"permitted");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)((SeqOps)new .colon.colon((Object)"CAP_AUDIT_WRITE", (List)new .colon.colon((Object)"CAP_KILL", (List)new .colon.colon((Object)"CAP_NET_BIND_SERVICE", (List)Nil$.MODULE$)))));
        return Runc$Config$.MODULE$.apply("1.2.0", Runc$Config$Process$.MODULE$.apply(terminal, Runc$Config$User$.MODULE$.apply(0, 0), cmd, env, cwd.isEmpty() ? "/" : cwd, (ListMap<String, Seq<String>>)((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (Seq<Runc.Config.Rlimit>)((Seq)((SeqOps)new .colon.colon((Object)Runc$Config$Rlimit$.MODULE$.apply("RLIMIT_NOFILE", 1024, 1024), (List)Nil$.MODULE$))), true), Runc$Config$Root$.MODULE$.apply(rootFsDirName, false), "runc", (Seq<Runc.Config.Mount>)((Seq)((SeqOps)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/proc", "proc", "proc", Runc$Config$Mount$.MODULE$.$lessinit$greater$default$4()), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/dev", "tmpfs", "tmpfs", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "strictatime", "mode=755", "size=65536k"})))), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/dev/pts", "devpts", "devpts", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "noexec", "newinstance", "ptmxmode=0666", "mode=0620", "gid=5"})))), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/dev/shm", "tmpfs", "shm", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "noexec", "nodev", "mode=1777", "size=65536k"})))), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/dev/mqueue", "mqueue", "mqueue", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "noexec", "nodev"})))), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/sys", "sysfs", "sysfs", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "noexec", "nodev", "ro"})))), (List)new .colon.colon((Object)Runc$Config$Mount$.MODULE$.apply("/sys/fs/cgroup", "cgroup", "cgroup", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nosuid", "noexec", "nodev", "relatime", "ro"})))), (List)Nil$.MODULE$))))))))), Runc$Config$Linux$.MODULE$.apply(Runc$Config$LinuxResources$.MODULE$.apply((Seq<Runc.Config.LinuxDevice>)((Seq)((SeqOps)new .colon.colon((Object)Runc$Config$LinuxDevice$.MODULE$.apply(false, "rwm"), (List)Nil$.MODULE$)))), (Seq<Runc.Config.LinuxNamespace>)((Seq)((SeqOps)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("pid"), (List)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("network"), (List)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("ipc"), (List)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("uts"), (List)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("mount"), (List)new .colon.colon((Object)Runc$Config$LinuxNamespace$.MODULE$.apply("cgroup"), (List)Nil$.MODULE$)))))))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/proc/acpi", "/proc/asound", "/proc/kcore", "/proc/keys", "/proc/latency_stats", "/proc/timer_list", "/proc/timer_stats", "/proc/sched_debug", "/sys/firmware", "/proc/scsi"}))), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"/proc/bus", (List)new .colon.colon((Object)"/proc/fs", (List)new .colon.colon((Object)"/proc/irq", (List)new .colon.colon((Object)"/proc/sys", (List)new .colon.colon((Object)"/proc/sysrq-trigger", (List)Nil$.MODULE$)))))))));
    }

    private static final CacheLogger $anonfun$1() {
        return CacheLogger$.MODULE$.nop();
    }

    public static final /* synthetic */ void coursier$docker$Runc$Config$$$_$e3$1$$anonfun$1(JsonWriter out$1, String x) {
        out$1.writeVal(x);
    }

    public static final /* synthetic */ void coursier$docker$Runc$Config$$$_$e10$1$$anonfun$1(JsonWriter out$4, String x) {
        out$4.writeVal(x);
    }
}

