/*
 * Decompiled with CFR 0.152.
 */
package coursier.env;

import coursier.env.PowershellRunner$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u0010 \u0005\u0011B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005y!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003H\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011\u0001-\t\u000be\u0003A\u0011\u0001.\t\u000bu\u0003A\u0011\u00010\t\u000b\u0001\u0004A\u0011A1\t\u000b\r\u0004A\u0011\u00013\t\u000b\u0019\u0004A\u0011I4\t\u000b=\u0004A\u0011\t9\t\u000bY\u0004A\u0011I<\t\u000be\u0004A\u0011\t>\t\u000by\u0004A\u0011B@\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003/\u0001A\u0011IA\r\u000f\u001d\tib\bE\u0001\u0003?1aAH\u0010\t\u0002\u0005\u0005\u0002BB)\u0018\t\u0003\ti\u0003\u0003\u0004\u00020]!\tA\u0012\u0005\b\u0003c9B\u0011BA\u001a\u0011\u0019\tYe\u0006C\u00011\"9\u00111J\f\u0005\u0002\u00055\u0003\"CA+/\u0005\u0005I\u0011BA,\u0005A\u0001vn^3sg\",G\u000e\u001c*v]:,'O\u0003\u0002!C\u0005\u0019QM\u001c<\u000b\u0003\t\n\u0001bY8veNLWM]\u0002\u0001'\u0011\u0001Qe\u000b\u0018\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\t1C&\u0003\u0002.O\t9\u0001K]8ek\u000e$\bCA\u00188\u001d\t\u0001TG\u0004\u00022i5\t!G\u0003\u00024G\u00051AH]8pizJ\u0011\u0001K\u0005\u0003m\u001d\nq\u0001]1dW\u0006<W-\u0003\u00029s\ta1+\u001a:jC2L'0\u00192mK*\u0011agJ\u0001\u0012a><XM]:iK2dW\t_3QCRDW#\u0001\u001f\u0011\u0005u\neB\u0001 @!\t\tt%\u0003\u0002AO\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001u%\u0001\nq_^,'o\u001d5fY2,\u00050\u001a)bi\"\u0004\u0013aB8qi&|gn]\u000b\u0002\u000fB\u0019q\u0006\u0013\u001f\n\u0005%K$aA*fc\u0006Aq\u000e\u001d;j_:\u001c\b%A\u0007f]\u000e|G-\u001a)s_\u001e\u0014\u0018-\\\u000b\u0002\u001bB\u0011aET\u0005\u0003\u001f\u001e\u0012qAQ8pY\u0016\fg.\u0001\bf]\u000e|G-\u001a)s_\u001e\u0014\u0018-\u001c\u0011\u0002\rqJg.\u001b;?)\u0011\u0019VKV,\u0011\u0005Q\u0003Q\"A\u0010\t\u000bi:\u0001\u0019\u0001\u001f\t\u000b\u0015;\u0001\u0019A$\t\u000b-;\u0001\u0019A'\u0015\u0003M\u000b\u0011B];o'\u000e\u0014\u0018\u000e\u001d;\u0015\u0005qZ\u0006\"\u0002/\n\u0001\u0004a\u0014AB:de&\u0004H/A\u000bxSRD\u0007k\\<feNDW\r\u001c7Fq\u0016\u0004\u0016\r\u001e5\u0015\u0005M{\u0006\"\u0002\u001e\u000b\u0001\u0004a\u0014aC<ji\"|\u0005\u000f^5p]N$\"a\u00152\t\u000b\u0015[\u0001\u0019A$\u0002#]LG\u000f[#oG>$W\r\u0015:pOJ\fW\u000e\u0006\u0002TK\")1\n\u0004a\u0001\u001b\u0006AAo\\*ue&tw\rF\u0001i!\tIg.D\u0001k\u0015\tYG.\u0001\u0003mC:<'\"A7\u0002\t)\fg/Y\u0005\u0003\u0005*\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0003\u001bFDQA\u001d\bA\u0002M\f1a\u001c2k!\t1C/\u0003\u0002vO\t\u0019\u0011I\\=\u0002\r\u0015\fX/\u00197t)\ti\u0005\u0010C\u0003s\u001f\u0001\u00071/\u0001\u0005iCND7i\u001c3f)\u0005Y\bC\u0001\u0014}\u0013\tixEA\u0002J]R\fQ\u0001^;qY\u0016,\"!!\u0001\u0011\r\u0019\n\u0019\u0001P$N\u0013\r\t)a\n\u0002\u0007)V\u0004H.Z\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005A\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A>\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191/a\u0005\t\r\u0005UA\u00031\u0001|\u0003\u0005q\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2\u0001[A\u000e\u0011\u0019\t)\"\u0006a\u0001w\u0006\u0001\u0002k\\<feNDW\r\u001c7Sk:tWM\u001d\t\u0003)^\u0019BaF\u0013\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*1\f!![8\n\u0007a\n9\u0003\u0006\u0002\u0002 \u0005qA-\u001a4bk2$x\n\u001d;j_:\u001c\u0018!\u0003:fC\u00124U\u000f\u001c7z)\u0011\t)$!\u0011\u0011\u000b\u0019\n9$a\u000f\n\u0007\u0005erEA\u0003BeJ\f\u0017\u0010E\u0002'\u0003{I1!a\u0010(\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005\r#\u00041\u0001\u0002F\u0005\u0011\u0011n\u001d\t\u0005\u0003K\t9%\u0003\u0003\u0002J\u0005\u001d\"aC%oaV$8\u000b\u001e:fC6\fQ!\u00199qYf$raUA(\u0003#\n\u0019\u0006C\u0003;9\u0001\u0007A\bC\u0003F9\u0001\u0007q\tC\u0003L9\u0001\u0007Q*\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002ZA\u0019\u0011.a\u0017\n\u0007\u0005u#N\u0001\u0004PE*,7\r\u001e")
public final class PowershellRunner
implements Product,
Serializable {
    private final String powershellExePath;
    private final Seq<String> options;
    private final boolean encodeProgram;

    public static PowershellRunner apply(String powershellExePath, Seq<String> options, boolean encodeProgram) {
        return PowershellRunner$.MODULE$.apply(powershellExePath, options, encodeProgram);
    }

    public static PowershellRunner apply() {
        return PowershellRunner$.MODULE$.apply();
    }

    public static Seq<String> defaultOptions() {
        return PowershellRunner$.MODULE$.defaultOptions();
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String powershellExePath() {
        return this.powershellExePath;
    }

    public Seq<String> options() {
        return this.options;
    }

    public boolean encodeProgram() {
        return this.encodeProgram;
    }

    public String runScript(String script) {
        Seq seq;
        String fullScript = new StringBuilder(63).append("& {\n[Console]::OutputEncoding = [System.Text.Encoding]::UTF8\n").append(script).append("\n}").toString();
        if (this.encodeProgram()) {
            Base64.Encoder base64 = Base64.getEncoder();
            String encodedScript = base64.encodeToString(fullScript.getBytes(StandardCharsets.UTF_16LE));
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-EncodedCommand", encodedScript}));
        } else {
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Command", fullScript}));
        }
        Seq scriptArgs = seq;
        Seq command = (Seq)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.powershellExePath()})).$plus$plus(this.options())).$plus$plus((IterableOnce)scriptArgs);
        ProcessBuilder b = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = b.start();
        p.getOutputStream().close();
        byte[] outputBytes = PowershellRunner$.MODULE$.coursier$env$PowershellRunner$$readFully(p.getInputStream());
        int retCode = p.waitFor();
        if (retCode != 0) {
            throw new Exception(new StringBuilder(7).append(new StringBuilder(45).append("Error running powershell script (exit code: ").append(retCode).append(")").toString()).append(System.lineSeparator()).append("Error running command:").append(System.lineSeparator()).append(((IterableOnceOps)command.map((Function1 & Serializable)x$1 -> new StringBuilder(2).append("  ").append((String)x$1).append(System.lineSeparator()).toString())).mkString()).append(System.lineSeparator()).append("Output:").append(System.lineSeparator()).append(Try$.MODULE$.apply((Function0 & Serializable)() -> new String(outputBytes, StandardCharsets.UTF_8)).toOption().getOrElse((Function0 & Serializable)() -> "[Could not convert output]")).toString());
        }
        return new String(outputBytes, StandardCharsets.UTF_8);
    }

    public PowershellRunner withPowershellExePath(String powershellExePath) {
        return new PowershellRunner(powershellExePath, this.options(), this.encodeProgram());
    }

    public PowershellRunner withOptions(Seq<String> options) {
        return new PowershellRunner(this.powershellExePath(), options, this.encodeProgram());
    }

    public PowershellRunner withEncodeProgram(boolean encodeProgram) {
        return new PowershellRunner(this.powershellExePath(), this.options(), encodeProgram);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("PowershellRunner(");
        b.append(String.valueOf(this.powershellExePath()));
        b.append(", ");
        b.append(String.valueOf(this.options()));
        b.append(", ");
        b.append(String.valueOf(this.encodeProgram()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof PowershellRunner && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        PowershellRunner other = (PowershellRunner)obj;
        if (!true) return false;
        String string = this.powershellExePath();
        String string2 = other.powershellExePath();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<String> seq = this.options();
        Seq<String> seq2 = other.options();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.encodeProgram() != other.encodeProgram()) return false;
        return true;
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"PowershellRunner");
        code = 37 * code + Statics.anyHash((Object)this.powershellExePath());
        code = 37 * code + Statics.anyHash(this.options());
        code = 37 * code + (this.encodeProgram() ? 1231 : 1237);
        return 37 * code;
    }

    private Tuple3<String, Seq<String>, Object> tuple() {
        return new Tuple3((Object)this.powershellExePath(), this.options(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encodeProgram()));
    }

    public String productPrefix() {
        return "PowershellRunner";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this.powershellExePath();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.encodeProgram());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "powershellExePath";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            case 2: {
                string = "encodeProgram";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return string;
    }

    public PowershellRunner(String powershellExePath, Seq<String> options, boolean encodeProgram) {
        this.powershellExePath = powershellExePath;
        this.options = options;
        this.encodeProgram = encodeProgram;
        Product.$init$((Product)this);
    }

    public PowershellRunner() {
        this("powershell.exe", PowershellRunner$.MODULE$.defaultOptions(), true);
    }
}

