/*
 * Decompiled with CFR 0.152.
 */
package coursier.exec;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.LibC;
import coursier.exec.ErrnoException;
import coursier.exec.GraalvmErrnoExtras;
import coursier.exec.GraalvmUnistdExtras;
import java.io.FileNotFoundException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;

@TargetClass(className="coursier.exec.Execve")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class ExecveGraalvm {
    ExecveGraalvm() {
    }

    @Substitute
    public static boolean available() {
        return true;
    }

    @Substitute
    public static void execve(String string, String[] stringArray, String[] stringArray2) throws ErrnoException {
        CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);
        CTypeConversion.CCharPointerPointerHolder cCharPointerPointerHolder = CTypeConversion.toCStrings((CharSequence[])stringArray);
        CTypeConversion.CCharPointerPointerHolder cCharPointerPointerHolder2 = CTypeConversion.toCStrings((CharSequence[])stringArray2);
        GraalvmUnistdExtras.execve(cCharPointerHolder.get(), cCharPointerPointerHolder.get(), cCharPointerPointerHolder2.get());
        int n = LibC.errno();
        FileNotFoundException fileNotFoundException = null;
        if (n == GraalvmErrnoExtras.ENOENT() || n == GraalvmErrnoExtras.ENOTDIR()) {
            fileNotFoundException = new FileNotFoundException(string);
        }
        throw new ErrnoException(n, (Throwable)fileNotFoundException);
    }
}

