/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.scala.scalanative.io;

import coursier.shaded.scala.scalanative.io.VirtualDirectory;
import coursier.shaded.scala.scalanative.io.VirtualDirectory$EmptyDirectory$;
import coursier.shaded.scala.scalanative.util.Scope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class VirtualDirectory$ {
    public static VirtualDirectory$ MODULE$;
    private final VirtualDirectory empty;

    static {
        new VirtualDirectory$();
    }

    public VirtualDirectory local(Path file) {
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local directory doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.absolute$1(file)})));
        Predef$.MODULE$.assert(Files.isDirectory(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.absolute$1(file)})));
        return new VirtualDirectory.LocalDirectory(file);
    }

    public VirtualDirectory jar(Path file, Scope in) {
        Path absolute = file.toAbsolutePath();
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jar doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absolute})));
        Predef$.MODULE$.assert(((Object)absolute).toString().endsWith(".jar"), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a jar: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absolute})));
        return new VirtualDirectory.JarDirectory(file, in);
    }

    public VirtualDirectory real(Path file, Scope in) {
        VirtualDirectory virtualDirectory;
        if (Files.isDirectory(file, new LinkOption[0])) {
            virtualDirectory = this.local(file);
        } else if (((Object)file).toString().endsWith(".jar")) {
            virtualDirectory = this.jar(file, in);
        } else {
            throw new UnsupportedOperationException("Neither a jar, nor a directory: " + file);
        }
        return virtualDirectory;
    }

    public VirtualDirectory empty() {
        return this.empty;
    }

    private static final Path absolute$1(Path file$1) {
        return file$1.toAbsolutePath();
    }

    private VirtualDirectory$() {
        MODULE$ = this;
        this.empty = VirtualDirectory$EmptyDirectory$.MODULE$;
    }
}

