/*
 * Decompiled with CFR 0.152.
 */
package coursier.install;

import coursier.Fetch;
import coursier.Fetch$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.FileCache$;
import coursier.cache.loggers.ProgressBarRefreshDisplay$;
import coursier.core.Dependency;
import coursier.core.Repository;
import coursier.install.AppDescriptor;
import coursier.install.GraalvmParams;
import coursier.install.InstallDir;
import coursier.install.MainClass$;
import coursier.jvm.ArchiveType;
import coursier.jvm.ArchiveType$;
import coursier.launcher.ClassPathEntry;
import coursier.launcher.Preamble;
import coursier.launcher.Preamble$;
import coursier.package;
import coursier.paths.CoursierPaths;
import coursier.util.Artifact;
import coursier.util.Artifact$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class InstallDir$
implements scala.Serializable {
    public static InstallDir$ MODULE$;
    private Path defaultDir0;
    private final String isInstalledLauncherEnvVar;
    private final String isJvmLauncherEnvVar;
    private final String isNativeLauncherEnvVar;
    private volatile boolean bitmap$0;

    static {
        new InstallDir$();
    }

    public String isInstalledLauncherEnvVar() {
        return this.isInstalledLauncherEnvVar;
    }

    public String isJvmLauncherEnvVar() {
        return this.isJvmLauncherEnvVar;
    }

    public String isNativeLauncherEnvVar() {
        return this.isNativeLauncherEnvVar;
    }

    private Path defaultDir0$lzycompute() {
        InstallDir$ installDir$ = this;
        synchronized (installDir$) {
            if (!this.bitmap$0) {
                Option fromEnv = Option$.MODULE$.apply((Object)System.getenv("COURSIER_BIN_DIR")).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$defaultDir0$1(x$23))).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("COURSIER_INSTALL_DIR")).filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$defaultDir0$3(x$24))));
                this.defaultDir0 = (Path)fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> InstallDir$.fromProps$1()).map((Function1 & Serializable & scala.Serializable)x$25 -> Paths.get(x$25, new String[0])).getOrElse((Function0 & Serializable & scala.Serializable)() -> InstallDir$.default$1());
                this.bitmap$0 = true;
            }
        }
        return this.defaultDir0;
    }

    private Path defaultDir0() {
        return !this.bitmap$0 ? this.defaultDir0$lzycompute() : this.defaultDir0;
    }

    public Path defaultDir() {
        return this.defaultDir0();
    }

    public ClassPathEntry coursier$install$InstallDir$$classpathEntry(Artifact a, File f, boolean forceResource) {
        return forceResource || a.changing() || a.url().startsWith("file:") ? ClassPathEntry.Resource$.MODULE$.apply(f.getName(), f.lastModified(), Files.readAllBytes(f.toPath())) : ClassPathEntry.Url$.MODULE$.apply(a.url());
    }

    private boolean classpathEntry$default$3() {
        return false;
    }

    public Option<String> coursier$install$InstallDir$$foundMainClassOpt(Seq<File> shared, Seq<File> jars, int verbosity, Option<Dependency> mainDependencyOpt) {
        Map<Tuple2<String, String>, String> m;
        block0: {
            m = MainClass$.MODULE$.mainClasses(jars);
            if (verbosity < 2) break block0;
            System.err.println(new java.lang.StringBuilder(20).append("Found ").append(m.size()).append(" main classes:").toString());
            m.foreach((Function1 & Serializable & scala.Serializable)a -> {
                System.err.println(new java.lang.StringBuilder(2).append("  ").append(a).toString());
                return BoxedUnit.UNIT;
            });
        }
        return MainClass$.MODULE$.retainedMainClassOpt(m, (Option<Tuple2<String, String>>)mainDependencyOpt.map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)d.module().organization(), (Object)d.module().name())));
    }

    public Function1<Seq<String>, Seq<File>> coursier$install$InstallDir$$simpleFetch(Cache<Task> cache, Seq<Repository> repositories) {
        Fetch fetch = Fetch$.MODULE$.apply(cache, Task$.MODULE$.sync()).withRepositories(repositories);
        return (Function1 & Serializable & scala.Serializable)deps -> {
            Seq deps0 = (Seq)deps.map((Function1 & Serializable & scala.Serializable)dep -> {
                String[] stringArray = dep.split(":", 3);
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
                String org = (String)((SeqLike)option.get()).apply(0);
                String name = (String)((SeqLike)option.get()).apply(1);
                String ver = (String)((SeqLike)option.get()).apply(2);
                Dependency dependency = package.Dependency$.MODULE$.apply(package.Module$.MODULE$.apply(org, name, package.Module$.MODULE$.apply$default$3()), ver);
                return dependency;
            }, Seq$.MODULE$.canBuildFrom());
            Fetch qual$1 = Fetch$.MODULE$.FetchTaskOps(fetch.addDependencies(deps0));
            ExecutionContext x$1 = Fetch.FetchTaskOps$.MODULE$.run$default$1$extension(qual$1);
            return Fetch.FetchTaskOps$.MODULE$.run$extension(qual$1, x$1);
        };
    }

    public <T> T coursier$install$InstallDir$$writing(Path path, int verbosity, Option<Instant> modifiedTime, Function0<T> f) {
        Object t;
        block1: {
            if (verbosity >= 2) {
                System.err.println(new java.lang.StringBuilder(8).append("Writing ").append(path).toString());
            }
            t = f.apply();
            modifiedTime.foreach((Function1 & Serializable & scala.Serializable)time -> Files.setLastModifiedTime(path, FileTime.from(time)));
            if (verbosity < 1) break block1;
            System.err.println(new java.lang.StringBuilder(6).append("Wrote ").append(path).toString());
        }
        return (T)t;
    }

    private <T> Option<Instant> writing$default$3() {
        return None$.MODULE$;
    }

    private Option<Seq<Tuple2<Artifact, Option<Tuple2<ArchiveType, Option<String>>>>>> candidatePrebuiltArtifacts(AppDescriptor desc, Cache<Task> cache, int verbosity, Option<String> platform, Seq<String> platformExtensions, boolean preferPrebuilt) {
        return desc.launcherType().isNative() ? desc.prebuiltLauncher().orElse((Function0 & Serializable & scala.Serializable)() -> desc.prebuiltBinaries().get(platform.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))).map((Function1 & Serializable & scala.Serializable)pattern -> InstallDir$.patternArtifacts$1(pattern, platform, platformExtensions, desc, cache, verbosity, preferPrebuilt)) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<File> handleArtifactErrors(Either<ArtifactError, File> maybeFile, Artifact artifact, int verbosity) {
        ArtifactError.DownloadError downloadError;
        ArtifactError e;
        boolean bl = false;
        Left left = null;
        Either<ArtifactError, File> either = maybeFile;
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            ArtifactError e2 = (ArtifactError)left.value();
            if (e2 instanceof ArtifactError.NotFound) {
                if (verbosity < 2) return None$.MODULE$;
                System.err.println(new java.lang.StringBuilder(30).append("No prebuilt launcher found at ").append(artifact.url()).toString());
                return None$.MODULE$;
            }
        }
        if (bl && (e = (ArtifactError)left.value()) instanceof ArtifactError.DownloadError && (downloadError = (ArtifactError.DownloadError)e).getCause() instanceof SSLHandshakeException) {
            if (verbosity < 2) return None$.MODULE$;
            System.err.println(new java.lang.StringBuilder(56).append("No prebuilt launcher found at ").append(artifact.url()).append(" (SSL handshake exception)").toString());
            return None$.MODULE$;
        }
        if (bl) {
            ArtifactError e3 = (ArtifactError)left.value();
            throw new InstallDir.DownloadError(artifact.url(), (Throwable)e3);
        }
        if (!(either instanceof Right)) throw new MatchError(either);
        Right right = (Right)either;
        File f = (File)right.value();
        if (verbosity < 1) return new Some((Object)f);
        String size = ProgressBarRefreshDisplay$.MODULE$.byteCount(Files.size(f.toPath()), ProgressBarRefreshDisplay$.MODULE$.byteCount$default$2());
        System.err.println(new java.lang.StringBuilder(30).append("Found prebuilt launcher at ").append(artifact.url()).append(" (").append(size).append(")").toString());
        return new Some((Object)f);
    }

    public Either<Seq<String>, Tuple3<Artifact, File, Option<Tuple2<ArchiveType, Option<String>>>>> coursier$install$InstallDir$$prebuiltOrNotFoundUrls(AppDescriptor desc, Cache<Task> cache, int verbosity, Option<String> platform, Seq<String> platformExtensions, boolean preferPrebuilt) {
        return this.candidatePrebuiltArtifacts(desc, cache, verbosity, platform, platformExtensions, preferPrebuilt).toRight((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)artifacts -> {
            Iterator iterator = InstallDir$.downloadArtifacts$1(artifacts, verbosity, cache);
            return iterator.hasNext() ? package$.MODULE$.Right().apply(iterator.next()) : package$.MODULE$.Left().apply(artifacts.map((Function1 & Serializable & scala.Serializable)x$37 -> ((Artifact)x$37._1()).url(), Seq$.MODULE$.canBuildFrom()));
        });
    }

    public String auxName(String name, String auxExtension) {
        String name0;
        Tuple2 tuple2;
        int idx = name.lastIndexOf(46);
        Tuple2 tuple22 = tuple2 = idx >= 0 ? new Tuple2(new StringOps(Predef$.MODULE$.augmentString(name)).take(idx), new StringOps(Predef$.MODULE$.augmentString(name)).drop(idx)) : new Tuple2((Object)name, (Object)"");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = name0 = (String)tuple2._1();
        String name02 = string;
        return new java.lang.StringBuilder(5).append(".").append(name02).append(".aux").append(auxExtension).toString();
    }

    public Seq<String> platformExtensions(String os) {
        String os0 = os.toLowerCase(Locale.ROOT);
        return os0.contains("windows") ? (Seq)new .colon.colon((Object)".exe", (List)Nil$.MODULE$) : Nil$.MODULE$;
    }

    public Seq<String> platformExtensions() {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)System.getProperty("os.name"))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$38 -> MODULE$.platformExtensions((String)x$38), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> platform(String os) {
        return this.platform(os, (String)Option$.MODULE$.apply((Object)System.getProperty("os.arch")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "x86_64"));
    }

    public Option<String> platform(String os, String arch) {
        String arch0;
        String os0 = os.toLowerCase(Locale.ROOT);
        String string = arch;
        String string2 = "amd64";
        String string3 = !(string != null ? !string.equals(string2) : string2 != null) ? "x86_64" : (arch0 = arch);
        return os0.contains("linux") ? new Some((Object)new java.lang.StringBuilder(9).append(arch0).append("-pc-linux").toString()) : (os0.contains("mac") ? new Some((Object)new java.lang.StringBuilder(13).append(arch0).append("-apple-darwin").toString()) : (os0.contains("windows") ? new Some((Object)new java.lang.StringBuilder(9).append(arch0).append("-pc-win32").toString()) : None$.MODULE$));
    }

    public Option<String> platform() {
        return Option$.MODULE$.apply((Object)System.getProperty("os.name")).flatMap((Function1 & Serializable & scala.Serializable)os -> Option$.MODULE$.apply((Object)System.getProperty("os.arch")).flatMap((Function1 & Serializable & scala.Serializable)arch -> MODULE$.platform((String)os, (String)arch).map((Function1 & Serializable & scala.Serializable)p -> p)));
    }

    private <T> T withTgzEntriesIterator(File tgz, Function1<Iterator<Tuple2<ArchiveEntry, InputStream>>, T> f) {
        Object object;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(tgz);
            CompressorInputStream uncompressedInputStream = new CompressorStreamFactory().createCompressorInputStream(fis.markSupported() ? fis : new BufferedInputStream(fis));
            ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)(uncompressedInputStream.markSupported() ? uncompressedInputStream : new BufferedInputStream((InputStream)uncompressedInputStream)));
            ObjectRef nextEntryOrNull = ObjectRef.create(null);
            Iterator<Tuple2<ArchiveEntry, InputStream>> it = new Iterator<Tuple2<ArchiveEntry, InputStream>>(nextEntryOrNull, archiveInputStream){
                private final ObjectRef nextEntryOrNull$1;
                private final ArchiveInputStream archiveInputStream$1;

                public Iterator<Tuple2<ArchiveEntry, InputStream>> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Tuple2<ArchiveEntry, InputStream>, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Tuple2<ArchiveEntry, InputStream>, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<ArchiveEntry, InputStream>, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> withFilter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filterNot(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> takeWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> partition(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> span(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> dropWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Tuple2<ArchiveEntry, InputStream>, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Tuple2<ArchiveEntry, InputStream>> find(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Tuple2<ArchiveEntry, InputStream>> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Tuple2<ArchiveEntry, InputStream>> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Tuple2<ArchiveEntry, InputStream>> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Tuple2<ArchiveEntry, InputStream>> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Tuple2<ArchiveEntry, InputStream>> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Tuple2<ArchiveEntry, InputStream>> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Tuple2<ArchiveEntry, InputStream>> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Tuple2<ArchiveEntry, InputStream>> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Tuple2<ArchiveEntry, InputStream>> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<ArchiveEntry, InputStream>, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<ArchiveEntry, InputStream>, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    if ((ArchiveEntry)this.nextEntryOrNull$1.elem == null) {
                        this.nextEntryOrNull$1.elem = this.archiveInputStream$1.getNextEntry();
                    }
                    return (ArchiveEntry)this.nextEntryOrNull$1.elem != null;
                }

                /*
                 * WARNING - void declaration
                 */
                public Tuple2<ArchiveEntry, InputStream> next() {
                    void var1_1;
                    Predef$.MODULE$.assert(this.hasNext());
                    Tuple2 value = new Tuple2((Object)((ArchiveEntry)this.nextEntryOrNull$1.elem), (Object)this.archiveInputStream$1);
                    this.nextEntryOrNull$1.elem = null;
                    return var1_1;
                }
                {
                    this.nextEntryOrNull$1 = nextEntryOrNull$1;
                    this.archiveInputStream$1 = archiveInputStream$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            };
            object = f.apply((Object)it);
        }
        return (T)object;
    }

    public <T> T coursier$install$InstallDir$$withFirstFileInTgz(File tgz, Function1<InputStream, T> f) {
        return this.withTgzEntriesIterator(tgz, (Function1 & Serializable & scala.Serializable)it -> {
            Iterator it0 = it.filter((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$withFirstFileInTgz$2(x$39))).map((Function1 & Serializable & scala.Serializable)x$40 -> (InputStream)x$40._2());
            if (!it0.hasNext()) {
                throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(tgz).toString());
            }
            return f.apply(it0.next());
        });
    }

    public <T> T coursier$install$InstallDir$$withFileInTgz(File tgz, String pathInArchive, Function1<InputStream, T> f) {
        return this.withTgzEntriesIterator(tgz, (Function1 & Serializable & scala.Serializable)it -> {
            Iterator it0 = it.collect((PartialFunction)new scala.Serializable(pathInArchive){
                public static final long serialVersionUID = 0L;
                private final String pathInArchive$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<ArchiveEntry, InputStream>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        ArchiveEntry ent = (ArchiveEntry)A1._1();
                        InputStream is = (InputStream)A1._2();
                        if (!ent.isDirectory()) {
                            String string = ent.getName();
                            String string2 = this.pathInArchive$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                object = is;
                                return (B1)object;
                            }
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<ArchiveEntry, InputStream> x1) {
                    Tuple2<ArchiveEntry, InputStream> tuple2 = x1;
                    if (tuple2 == null) return false;
                    ArchiveEntry ent = (ArchiveEntry)tuple2._1();
                    if (ent.isDirectory()) return false;
                    String string = ent.getName();
                    String string2 = this.pathInArchive$1;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
                {
                    this.pathInArchive$1 = pathInArchive$1;
                }
            });
            if (!it0.hasNext()) {
                throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(tgz).toString());
            }
            return f.apply(it0.next());
        });
    }

    public <T> T coursier$install$InstallDir$$withFirstFileInZip(File zip, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)((Iterator)CollectionConverters$.MODULE$.enumerationAsScalaIteratorConverter(zf.entries()).asScala()).find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$withFirstFileInZip$1(e))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public <T> T coursier$install$InstallDir$$withFileInZip(File zip, String pathInArchive, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)Option$.MODULE$.apply((Object)zf.getEntry(pathInArchive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public void coursier$install$InstallDir$$writeTo(InputStream is, Path dest) {
        try (OutputStream os = null;){
            os = Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
            int read = -1;
            while ((read = is.read(buf)) >= 0) {
                if (read <= 0) continue;
                os.write(buf, 0, read);
            }
        }
    }

    public InstallDir apply() {
        return new InstallDir(this.defaultDir(), (Cache<Task>)FileCache$.MODULE$.apply(Task$.MODULE$.sync()), 0, (Option<GraalvmParams>)None$.MODULE$, (Seq<Repository>)Nil$.MODULE$, this.platform(), this.platformExtensions(), System.getProperty("os.name", ""), (Option<Function1<String, Task<File>>>)None$.MODULE$, false, true, Preamble$.MODULE$.apply().addExtraEnvVar(this.isInstalledLauncherEnvVar(), "true"), (Option<Object>)None$.MODULE$);
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache) {
        return new InstallDir(baseDir, cache, 0, (Option<GraalvmParams>)None$.MODULE$, (Seq<Repository>)Nil$.MODULE$, this.platform(), this.platformExtensions(), System.getProperty("os.name", ""), (Option<Function1<String, Task<File>>>)None$.MODULE$, false, true, Preamble$.MODULE$.apply().addExtraEnvVar(this.isInstalledLauncherEnvVar(), "true"), (Option<Object>)None$.MODULE$);
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache, int verbosity, Option<GraalvmParams> graalvmParamsOpt, Seq<Repository> coursierRepositories, Option<String> platform, Seq<String> platformExtensions, String os, Option<Function1<String, Task<File>>> nativeImageJavaHome, boolean onlyPrebuilt, boolean preferPrebuilt, Preamble basePreamble) {
        return new InstallDir(baseDir, cache, verbosity, graalvmParamsOpt, coursierRepositories, platform, platformExtensions, os, nativeImageJavaHome, onlyPrebuilt, preferPrebuilt, basePreamble, (Option<Object>)None$.MODULE$);
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache, int verbosity, Option<GraalvmParams> graalvmParamsOpt, Seq<Repository> coursierRepositories, Option<String> platform, Seq<String> platformExtensions, String os, Option<Function1<String, Task<File>>> nativeImageJavaHome, boolean onlyPrebuilt, boolean preferPrebuilt, Preamble basePreamble, Option<Object> overrideProguardedBootstraps) {
        return new InstallDir(baseDir, cache, verbosity, graalvmParamsOpt, coursierRepositories, platform, platformExtensions, os, nativeImageJavaHome, onlyPrebuilt, preferPrebuilt, basePreamble, overrideProguardedBootstraps);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$defaultDir0$1(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$defaultDir0$3(String x$24) {
        return new StringOps(Predef$.MODULE$.augmentString(x$24)).nonEmpty();
    }

    private static final Option fromProps$1() {
        return Option$.MODULE$.apply((Object)System.getProperty("coursier.install.dir"));
    }

    private static final Path default$1() {
        return CoursierPaths.dataLocalDirectory().toPath().resolve("bin");
    }

    private static final Iterator mainVersionsIterator$1(AppDescriptor desc$2, Cache cache$1, int verbosity$1, boolean preferPrebuilt$1) {
        Iterator it0 = desc$2.candidateMainVersions((Cache<Task>)cache$1, verbosity$1);
        Iterator it = it0.hasNext() ? it0 : desc$2.mainVersionOpt().iterator();
        return it.take(preferPrebuilt$1 ? 5 : 1);
    }

    private static final Tuple2 urlArchiveType$1(String url) {
        Tuple2 tuple2;
        int idx = url.indexOf(43);
        if (idx < 0) {
            tuple2 = new Tuple2((Object)url, (Object)None$.MODULE$);
        } else {
            Tuple2 tuple22;
            Option option = ArchiveType$.MODULE$.parse((String)new StringOps(Predef$.MODULE$.augmentString(url)).take(idx));
            if (option instanceof Some) {
                Tuple2 tuple23;
                Some some = (Some)option;
                ArchiveType tpe = (ArchiveType)some.value();
                String url0 = (String)new StringOps(Predef$.MODULE$.augmentString(url)).drop(idx + 1);
                int subPathIndex = url0.indexOf(33);
                if (subPathIndex < 0) {
                    tuple23 = new Tuple2((Object)url0, (Object)new Some((Object)new Tuple2((Object)tpe, (Object)None$.MODULE$)));
                } else {
                    String subPath = (String)new StringOps(Predef$.MODULE$.augmentString(url0)).drop(subPathIndex + 1);
                    tuple23 = new Tuple2(new StringOps(Predef$.MODULE$.augmentString(url0)).take(subPathIndex), (Object)new Some((Object)new Tuple2((Object)tpe, (Object)new Some((Object)subPath))));
                }
                tuple22 = tuple23;
            } else if (None$.MODULE$.equals(option)) {
                tuple22 = new Tuple2((Object)url, (Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$candidatePrebuiltArtifacts$4(Tuple2 x$26) {
        return ((Option)x$26._2()).nonEmpty();
    }

    private static final Seq patternArtifacts$1(String pattern, Option platform$1, Seq platformExtensions$1, AppDescriptor desc$2, Cache cache$1, int verbosity$1, boolean preferPrebuilt$1) {
        Iterator artifactsIt = InstallDir$.mainVersionsIterator$1(desc$2, cache$1, verbosity$1, preferPrebuilt$1).map((Function1 & Serializable & scala.Serializable)version -> {
            boolean isSnapshot = version.endsWith("SNAPSHOT");
            String baseUrl0 = pattern.replace("${version}", (CharSequence)version).replace("${platform}", (CharSequence)platform$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            Tuple2 tuple2 = InstallDir$.urlArchiveType$1(baseUrl0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String baseUrl = (String)tuple2._1();
            Option archiveTypeAndPathOpt = (Option)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)baseUrl, (Object)archiveTypeAndPathOpt);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$28 = (Tuple2)tuple32._1();
            String string = (String)tuple32._2();
            Option option = (Option)tuple32._3();
            return new Tuple4(version, (Object)BoxesRunTime.boxToBoolean((boolean)isSnapshot), (Object)baseUrl0, (Object)x$28);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$33 -> {
            Tuple2 tuple2;
            boolean isSnapshot;
            block3: {
                Tuple4 tuple4;
                block2: {
                    tuple4 = x$33;
                    if (tuple4 == null) break block2;
                    isSnapshot = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
                    tuple2 = (Tuple2)tuple4._4();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple4);
            }
            String baseUrl = (String)tuple2._1();
            Option archiveTypeAndPathOpt = (Option)tuple2._2();
            Iterator iterator = (archiveTypeAndPathOpt.forall((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$candidatePrebuiltArtifacts$4(x$26))) ? platformExtensions$1.iterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))) : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))).map((Function1 & Serializable & scala.Serializable)ext -> {
                Some some;
                Tuple2 tuple2;
                Tuple2 tuple22;
                Option option = archiveTypeAndPathOpt;
                if (None$.MODULE$.equals(option)) {
                    tuple22 = new Tuple2((Object)new java.lang.StringBuilder(0).append(baseUrl).append((String)ext).toString(), (Object)archiveTypeAndPathOpt);
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    ArchiveType tpe = (ArchiveType)tuple2._1();
                    Option subPath0 = (Option)tuple2._2();
                    tuple22 = new Tuple2((Object)baseUrl, (Object)new Some((Object)new Tuple2((Object)tpe, (Object)subPath0.map((Function1 & Serializable & scala.Serializable)x$27 -> new java.lang.StringBuilder(0).append((String)x$27).append((String)ext).toString()))));
                } else {
                    throw new MatchError((Object)option);
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                String url = (String)tuple23._1();
                Option archiveTypeAndPathOpt0 = (Option)tuple23._2();
                Tuple3 tuple3 = new Tuple3((Object)tuple23, (Object)url, (Object)archiveTypeAndPathOpt0);
                Tuple3 tuple32 = tuple3;
                Tuple2 x$30 = (Tuple2)tuple32._1();
                String string = (String)tuple32._2();
                Option option2 = (Option)tuple32._3();
                return new Tuple2(ext, (Object)x$30);
            }).map((Function1 & Serializable & scala.Serializable)x$32 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$32;
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                    throw new MatchError((Object)tuple22);
                }
                String url = (String)tuple2._1();
                Option archiveTypeAndPathOpt0 = (Option)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)Artifact$.MODULE$.apply(url).withChanging(isSnapshot), (Object)archiveTypeAndPathOpt0);
                return tuple23;
            });
            return iterator;
        });
        return artifactsIt.toVector();
    }

    private static final Iterator downloadArtifacts$1(Seq artifacts, int verbosity$2, Cache cache$2) {
        return artifacts.iterator().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either;
            Option archiveTypeOpt;
            Artifact artifact;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                artifact = (Artifact)tuple2._1();
                archiveTypeOpt = (Option)tuple2._2();
                if (verbosity$2 >= 2) {
                    System.err.println(new java.lang.StringBuilder(30).append("Checking prebuilt launcher at ").append(artifact.url()).toString());
                }
                cache$2.loggerOpt().foreach((Function1 & Serializable & scala.Serializable)x$34 -> {
                    x$34.init(x$34.init$default$1());
                    return BoxedUnit.UNIT;
                });
                try {
                    either = (Either)Task$.MODULE$.PlatformTaskOps(((Task)cache$2.file(artifact).run()).value()).unsafeRun(cache$2.ec());
                }
                finally {
                    cache$2.loggerOpt().foreach((Function1 & Serializable & scala.Serializable)x$35 -> {
                        x$35.stop();
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Either maybeFile = either;
            Iterator iterator = MODULE$.handleArtifactErrors((Either<ArtifactError, File>)maybeFile, artifact, verbosity$2).iterator().map((Function1 & Serializable & scala.Serializable)x$36 -> new Tuple3((Object)artifact, x$36, (Object)archiveTypeOpt));
            return iterator;
        });
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInTgz$2(Tuple2 x$39) {
        return !((ArchiveEntry)x$39._1()).isDirectory();
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInZip$1(ZipEntry e) {
        return !e.isDirectory();
    }

    private InstallDir$() {
        MODULE$ = this;
        this.isInstalledLauncherEnvVar = "IS_CS_INSTALLED_LAUNCHER";
        this.isJvmLauncherEnvVar = "CS_JVM_LAUNCHER";
        this.isNativeLauncherEnvVar = "CS_NATIVE_LAUNCHER";
    }
}

