/*
 * Decompiled with CFR 0.152.
 */
package coursier.install;

import coursier.Fetch;
import coursier.Fetch$;
import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveCache$;
import coursier.cache.Cache;
import coursier.cache.FileCache$;
import coursier.core.Dependency;
import coursier.core.Repository;
import coursier.install.GraalvmParams;
import coursier.install.InstallDir;
import coursier.install.MainClass$;
import coursier.install.Platform$;
import coursier.launcher.ClassPathEntry;
import coursier.launcher.Preamble;
import coursier.launcher.Preamble$;
import coursier.package;
import coursier.paths.CoursierPaths;
import coursier.util.Artifact;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Locale;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class InstallDir$
implements scala.Serializable {
    public static InstallDir$ MODULE$;
    private Path defaultDir0;
    private volatile boolean bitmap$0;

    static {
        new InstallDir$();
    }

    private Path defaultDir0$lzycompute() {
        InstallDir$ installDir$ = this;
        synchronized (installDir$) {
            if (!this.bitmap$0) {
                Option fromEnv = Option$.MODULE$.apply((Object)System.getenv("COURSIER_BIN_DIR")).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$defaultDir0$1(x$18))).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("COURSIER_INSTALL_DIR")).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)InstallDir$.$anonfun$defaultDir0$3(x$19))));
                this.defaultDir0 = (Path)fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> InstallDir$.fromProps$1()).map((Function1 & Serializable & scala.Serializable)x$20 -> Paths.get(x$20, new String[0])).getOrElse((Function0 & Serializable & scala.Serializable)() -> InstallDir$.default$1());
                this.bitmap$0 = true;
            }
        }
        return this.defaultDir0;
    }

    private Path defaultDir0() {
        if (!this.bitmap$0) {
            return this.defaultDir0$lzycompute();
        }
        return this.defaultDir0;
    }

    public Path defaultDir() {
        return this.defaultDir0();
    }

    public ClassPathEntry coursier$install$InstallDir$$classpathEntry(Artifact a, File f, boolean forceResource) {
        if (forceResource || a.changing() || a.url().startsWith("file:")) {
            return ClassPathEntry.Resource$.MODULE$.apply(f.getName(), f.lastModified(), Files.readAllBytes(f.toPath()));
        }
        return ClassPathEntry.Url$.MODULE$.apply(a.url());
    }

    private boolean classpathEntry$default$3() {
        return false;
    }

    public Option<String> coursier$install$InstallDir$$foundMainClassOpt(Seq<File> shared, Seq<File> jars, int verbosity, Option<Dependency> mainDependencyOpt) {
        Map<Tuple2<String, String>, String> m;
        block0: {
            m = MainClass$.MODULE$.mainClasses(jars);
            if (verbosity < 2) break block0;
            System.err.println(new StringBuilder(20).append("Found ").append(m.size()).append(" main classes:").toString());
            m.foreach((Function1 & Serializable & scala.Serializable)a -> {
                System.err.println(new StringBuilder(2).append("  ").append(a).toString());
                return BoxedUnit.UNIT;
            });
        }
        return MainClass$.MODULE$.retainedMainClassOpt(m, (Option<Tuple2<String, String>>)mainDependencyOpt.map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)d.module().organization(), (Object)d.module().name())));
    }

    public Function1<Seq<String>, Seq<File>> coursier$install$InstallDir$$simpleFetch(Cache<Task> cache, Seq<Repository> repositories) {
        Fetch fetch = Fetch$.MODULE$.apply(cache, Task$.MODULE$.sync()).withRepositories(repositories);
        return (Function1 & Serializable & scala.Serializable)deps -> {
            Seq deps0 = (Seq)deps.map((Function1 & Serializable & scala.Serializable)dep -> {
                String[] stringArray = dep.split(":", 3);
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                    String org = (String)((SeqLike)option.get()).apply(0);
                    String name = (String)((SeqLike)option.get()).apply(1);
                    String ver = (String)((SeqLike)option.get()).apply(2);
                    return package.Dependency$.MODULE$.apply(package.Module$.MODULE$.apply(org, name, package.Module$.MODULE$.apply$default$3()), ver);
                }
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }, Seq$.MODULE$.canBuildFrom());
            Fetch qual$1 = Fetch$.MODULE$.FetchTaskOps(fetch.addDependencies(deps0));
            ExecutionContext x$1 = Fetch.FetchTaskOps$.MODULE$.run$default$1$extension(qual$1);
            return Fetch.FetchTaskOps$.MODULE$.run$extension(qual$1, x$1);
        };
    }

    public <T> T coursier$install$InstallDir$$writing(Path path, int verbosity, Option<Instant> modifiedTime, Function0<T> f) {
        Object t;
        block1: {
            if (verbosity >= 2) {
                System.err.println(new StringBuilder(8).append("Writing ").append(path).toString());
            }
            t = f.apply();
            modifiedTime.foreach((Function1 & Serializable & scala.Serializable)time -> Files.setLastModifiedTime(path, FileTime.from(time)));
            if (verbosity < 1) break block1;
            System.err.println(new StringBuilder(6).append("Wrote ").append(path).toString());
        }
        return (T)t;
    }

    private <T> Option<Instant> writing$default$3() {
        return None$.MODULE$;
    }

    public String auxName(String name, String auxExtension) {
        Tuple2 tuple2;
        int idx = name.lastIndexOf(46);
        Tuple2 tuple22 = tuple2 = idx >= 0 ? new Tuple2(new StringOps(Predef$.MODULE$.augmentString(name)).take(idx), new StringOps(Predef$.MODULE$.augmentString(name)).drop(idx)) : new Tuple2((Object)name, (Object)"");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name0 = (String)tuple2._1();
        String name02 = name0;
        return new StringBuilder(5).append(".").append(name02).append(".aux").append(auxExtension).toString();
    }

    public Seq<String> platformExtensions(String os) {
        String os0 = os.toLowerCase(Locale.ROOT);
        if (os0.contains("windows")) {
            return (Seq)new .colon.colon((Object)".exe", (List)new .colon.colon((Object)".bat", (List)Nil$.MODULE$));
        }
        return Nil$.MODULE$;
    }

    public Seq<String> platformExtensions() {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)System.getProperty("os.name"))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$21 -> MODULE$.platformExtensions((String)x$21), Seq$.MODULE$.canBuildFrom());
    }

    public void coursier$install$InstallDir$$writeTo(InputStream is, Path dest) {
        try (OutputStream os = null;){
            os = Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
            int read = -1;
            while ((read = is.read(buf)) >= 0) {
                if (read <= 0) continue;
                os.write(buf, 0, read);
            }
        }
    }

    public InstallDir apply() {
        return new InstallDir(this.defaultDir(), (Cache<Task>)FileCache$.MODULE$.apply(Task$.MODULE$.sync()), 0, (Option<GraalvmParams>)None$.MODULE$, (Seq<Repository>)Nil$.MODULE$, Platform$.MODULE$.get(), this.platformExtensions(), System.getProperty("os.name", ""), (Option<Function1<String, Task<File>>>)None$.MODULE$, false, true, Preamble$.MODULE$.apply(), (Option<Object>)None$.MODULE$, (ArchiveCache<Task>)ArchiveCache$.MODULE$.apply(Task$.MODULE$.sync()));
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache) {
        return new InstallDir(baseDir, cache, 0, (Option<GraalvmParams>)None$.MODULE$, (Seq<Repository>)Nil$.MODULE$, Platform$.MODULE$.get(), this.platformExtensions(), System.getProperty("os.name", ""), (Option<Function1<String, Task<File>>>)None$.MODULE$, false, true, Preamble$.MODULE$.apply(), (Option<Object>)None$.MODULE$, (ArchiveCache<Task>)ArchiveCache$.MODULE$.apply(Task$.MODULE$.sync()));
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache, int verbosity, Option<GraalvmParams> graalvmParamsOpt, Seq<Repository> coursierRepositories, Option<String> platform, Seq<String> platformExtensions, String os, Option<Function1<String, Task<File>>> nativeImageJavaHome, boolean onlyPrebuilt, boolean preferPrebuilt, Preamble basePreamble) {
        return new InstallDir(baseDir, cache, verbosity, graalvmParamsOpt, coursierRepositories, platform, platformExtensions, os, nativeImageJavaHome, onlyPrebuilt, preferPrebuilt, basePreamble, (Option<Object>)None$.MODULE$, (ArchiveCache<Task>)ArchiveCache$.MODULE$.apply(Task$.MODULE$.sync()));
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache, int verbosity, Option<GraalvmParams> graalvmParamsOpt, Seq<Repository> coursierRepositories, Option<String> platform, Seq<String> platformExtensions, String os, Option<Function1<String, Task<File>>> nativeImageJavaHome, boolean onlyPrebuilt, boolean preferPrebuilt, Preamble basePreamble, Option<Object> overrideProguardedBootstraps) {
        return new InstallDir(baseDir, cache, verbosity, graalvmParamsOpt, coursierRepositories, platform, platformExtensions, os, nativeImageJavaHome, onlyPrebuilt, preferPrebuilt, basePreamble, overrideProguardedBootstraps, (ArchiveCache<Task>)ArchiveCache$.MODULE$.apply(Task$.MODULE$.sync()));
    }

    public InstallDir apply(Path baseDir, Cache<Task> cache, int verbosity, Option<GraalvmParams> graalvmParamsOpt, Seq<Repository> coursierRepositories, Option<String> platform, Seq<String> platformExtensions, String os, Option<Function1<String, Task<File>>> nativeImageJavaHome, boolean onlyPrebuilt, boolean preferPrebuilt, Preamble basePreamble, Option<Object> overrideProguardedBootstraps, ArchiveCache<Task> archiveCache) {
        return new InstallDir(baseDir, cache, verbosity, graalvmParamsOpt, coursierRepositories, platform, platformExtensions, os, nativeImageJavaHome, onlyPrebuilt, preferPrebuilt, basePreamble, overrideProguardedBootstraps, archiveCache);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$defaultDir0$1(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$defaultDir0$3(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).nonEmpty();
    }

    private static final Option fromProps$1() {
        return Option$.MODULE$.apply((Object)System.getProperty("coursier.install.dir"));
    }

    private static final Path default$1() {
        return CoursierPaths.dataLocalDirectory().toPath().resolve("bin");
    }

    private InstallDir$() {
        MODULE$ = this;
    }
}

