/*
 * Decompiled with CFR 0.152.
 */
package coursier.install.internal;

import coursier.cache.ArchiveType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class ArchiveUtil$ {
    public static ArchiveUtil$ MODULE$;

    static {
        new ArchiveUtil$();
    }

    private <T> T withCompressedTarArchiveEntriesIterator(File archive, ArchiveType.Tar compression, Function1<Iterator<Tuple2<ArchiveEntry, InputStream>>, T> f) {
        Object object;
        String string;
        ArchiveType.Tar tar = compression;
        if (ArchiveType.Tgz$.MODULE$.equals(tar)) {
            string = "gz";
        } else if (ArchiveType.Tbz2$.MODULE$.equals(tar)) {
            string = "bzip2";
        } else {
            throw new MatchError((Object)tar);
        }
        String method = string;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(archive);
            CompressorInputStream uncompressedInputStream = new CompressorStreamFactory().createCompressorInputStream(method, fis.markSupported() ? fis : new BufferedInputStream(fis));
            ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)(uncompressedInputStream.markSupported() ? uncompressedInputStream : new BufferedInputStream((InputStream)uncompressedInputStream)));
            ObjectRef nextEntryOrNull = ObjectRef.create(null);
            Iterator<Tuple2<ArchiveEntry, InputStream>> it = new Iterator<Tuple2<ArchiveEntry, InputStream>>(nextEntryOrNull, archiveInputStream){
                private final ObjectRef nextEntryOrNull$1;
                private final ArchiveInputStream archiveInputStream$1;

                public Iterator<Tuple2<ArchiveEntry, InputStream>> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Tuple2<ArchiveEntry, InputStream>, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Tuple2<ArchiveEntry, InputStream>, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<ArchiveEntry, InputStream>, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> withFilter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filterNot(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> takeWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> partition(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> span(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> dropWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Tuple2<ArchiveEntry, InputStream>, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Tuple2<ArchiveEntry, InputStream>> find(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Tuple2<ArchiveEntry, InputStream>> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Tuple2<ArchiveEntry, InputStream>> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Tuple2<ArchiveEntry, InputStream>> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Tuple2<ArchiveEntry, InputStream>> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Tuple2<ArchiveEntry, InputStream>> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Tuple2<ArchiveEntry, InputStream>> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Tuple2<ArchiveEntry, InputStream>> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Tuple2<ArchiveEntry, InputStream>> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Tuple2<ArchiveEntry, InputStream>> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<ArchiveEntry, InputStream>, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<ArchiveEntry, InputStream>, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    if ((ArchiveEntry)this.nextEntryOrNull$1.elem == null) {
                        this.nextEntryOrNull$1.elem = this.archiveInputStream$1.getNextEntry();
                    }
                    return (ArchiveEntry)this.nextEntryOrNull$1.elem != null;
                }

                public Tuple2<ArchiveEntry, InputStream> next() {
                    Predef$.MODULE$.assert(this.hasNext());
                    Tuple2 value = new Tuple2((Object)((ArchiveEntry)this.nextEntryOrNull$1.elem), (Object)this.archiveInputStream$1);
                    this.nextEntryOrNull$1.elem = null;
                    return value;
                }
                {
                    this.nextEntryOrNull$1 = nextEntryOrNull$1;
                    this.archiveInputStream$1 = archiveInputStream$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            };
            object = f.apply((Object)it);
        }
        return (T)object;
    }

    public <T> T withFirstFileInCompressedTarArchive(File archive, ArchiveType.Tar compression, Function1<InputStream, T> f) {
        return this.withCompressedTarArchiveEntriesIterator(archive, compression, (Function1 & Serializable & scala.Serializable)it -> {
            Iterator it0 = it.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchiveUtil$.$anonfun$withFirstFileInCompressedTarArchive$2(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (InputStream)x$2._2());
            if (it0.hasNext()) {
                return f.apply(it0.next());
            }
            throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(archive).toString());
        });
    }

    public <T> T withFileInCompressedTarArchive(File archive, ArchiveType.Tar compression, String pathInArchive, Function1<InputStream, T> f) {
        return this.withCompressedTarArchiveEntriesIterator(archive, compression, (Function1 & Serializable & scala.Serializable)it -> {
            Iterator it0 = it.collect((PartialFunction)new scala.Serializable(pathInArchive){
                public static final long serialVersionUID = 0L;
                private final String pathInArchive$1;

                public final <A1 extends Tuple2<ArchiveEntry, InputStream>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        ArchiveEntry ent = (ArchiveEntry)A1._1();
                        InputStream is = (InputStream)A1._2();
                        if (!ent.isDirectory()) {
                            String string = ent.getName();
                            String string2 = this.pathInArchive$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return (B1)is;
                            }
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<ArchiveEntry, InputStream> x1) {
                    ArchiveEntry ent;
                    Tuple2<ArchiveEntry, InputStream> tuple2 = x1;
                    if (tuple2 != null && !(ent = (ArchiveEntry)tuple2._1()).isDirectory()) {
                        String string = ent.getName();
                        String string2 = this.pathInArchive$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.pathInArchive$1 = pathInArchive$1;
                }
            });
            if (it0.hasNext()) {
                return f.apply(it0.next());
            }
            throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(archive).toString());
        });
    }

    public <T> T withGzipContent(File gzFile, Function1<InputStream, T> f) {
        Object object;
        FileInputStream fis = null;
        GZIPInputStream gzis = null;
        try {
            fis = new FileInputStream(gzFile);
            gzis = new GZIPInputStream(fis);
            object = f.apply((Object)gzis);
        }
        finally {
            if (gzis != null) {
                gzis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return (T)object;
    }

    public <T> T withFirstFileInZip(File zip, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)((Iterator)CollectionConverters$.MODULE$.enumerationAsScalaIteratorConverter(zf.entries()).asScala()).find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ArchiveUtil$.$anonfun$withFirstFileInZip$1(e))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public <T> T withFileInZip(File zip, String pathInArchive, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)Option$.MODULE$.apply((Object)zf.getEntry(pathInArchive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInCompressedTarArchive$2(Tuple2 x$1) {
        return !((ArchiveEntry)x$1._1()).isDirectory();
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInZip$1(ZipEntry e) {
        return !e.isDirectory();
    }

    private ArchiveUtil$() {
        MODULE$ = this;
    }
}

