/*
 * Decompiled with CFR 0.152.
 */
package coursier.install.internal;

import coursier.cache.ArchiveType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ArchiveUtil$ {
    public static final ArchiveUtil$ MODULE$ = new ArchiveUtil$();

    private <T> T withCompressedTarArchiveEntriesIterator(File archive, ArchiveType.Tar compression, Function1<Iterator<Tuple2<ArchiveEntry, InputStream>>, T> f) {
        Object object;
        None$ none$;
        ArchiveType.Tar tar = compression;
        if (ArchiveType.Tar$.MODULE$.equals(tar)) {
            none$ = None$.MODULE$;
        } else if (ArchiveType.Tgz$.MODULE$.equals(tar)) {
            none$ = new Some((Object)"gz");
        } else if (ArchiveType.Tbz2$.MODULE$.equals(tar)) {
            none$ = new Some((Object)"bzip2");
        } else if (ArchiveType.Txz$.MODULE$.equals(tar)) {
            none$ = new Some((Object)"xz");
        } else if (ArchiveType.Tzst$.MODULE$.equals(tar)) {
            none$ = new Some((Object)"zstd");
        } else {
            throw new MatchError((Object)tar);
        }
        None$ methodOpt = none$;
        try (InputStream fis = null;){
            InputStream inputStream;
            fis = Files.newInputStream(archive.toPath(), new OpenOption[0]);
            None$ none$2 = methodOpt;
            if (none$2 instanceof Some) {
                Some some = (Some)none$2;
                String method = (String)some.value();
                inputStream = new CompressorStreamFactory().createCompressorInputStream(method, fis.markSupported() ? fis : new BufferedInputStream(fis));
            } else if (None$.MODULE$.equals(none$2)) {
                inputStream = fis;
            } else {
                throw new MatchError((Object)none$2);
            }
            InputStream uncompressedInputStream = inputStream;
            ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(uncompressedInputStream.markSupported() ? uncompressedInputStream : new BufferedInputStream(uncompressedInputStream));
            ObjectRef nextEntryOrNull = ObjectRef.create(null);
            Iterator<Tuple2<ArchiveEntry, InputStream>> it = new Iterator<Tuple2<ArchiveEntry, InputStream>>(nextEntryOrNull, archiveInputStream){
                private final ObjectRef nextEntryOrNull$1;
                private final ArchiveInputStream archiveInputStream$1;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<Tuple2<ArchiveEntry, InputStream>> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<Tuple2<ArchiveEntry, InputStream>> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<Tuple2<ArchiveEntry, InputStream>> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> partition(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filterNot(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> filterImpl(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> withFilter(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B> Iterator<Tuple2<ArchiveEntry, InputStream>> distinctBy(Function1<Tuple2<ArchiveEntry, InputStream>, B> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<Tuple2<ArchiveEntry, InputStream>, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<Tuple2<ArchiveEntry, InputStream>, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B> Iterator<B> flatten(Function1<Tuple2<ArchiveEntry, InputStream>, IterableOnce<B>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> takeWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> dropWhile(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> span(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, B>> zip(IterableOnce<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<Tuple2<ArchiveEntry, InputStream>, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U> Iterator<Tuple2<ArchiveEntry, InputStream>> tapEach(Function1<Tuple2<ArchiveEntry, InputStream>, U> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<Tuple2<ArchiveEntry, InputStream>> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<Tuple2<ArchiveEntry, InputStream>>, Iterator<Tuple2<ArchiveEntry, InputStream>>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U> void foreach(Function1<Tuple2<ArchiveEntry, InputStream>, U> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<Tuple2<ArchiveEntry, InputStream>> find(Function1<Tuple2<ArchiveEntry, InputStream>, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B> B foldLeft(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B> B $div$colon(B z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B> B $colon$bslash(B z, Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<ArchiveEntry, InputStream>, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Tuple2<ArchiveEntry, InputStream>, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Tuple2<ArchiveEntry, InputStream>> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Tuple2<ArchiveEntry, InputStream>> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<Tuple2<ArchiveEntry, InputStream>> maxByOption(Function1<Tuple2<ArchiveEntry, InputStream>, B> f, Ordering<B> ord) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
                }

                public Object minBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<Tuple2<ArchiveEntry, InputStream>> minByOption(Function1<Tuple2<ArchiveEntry, InputStream>, B> f, Ordering<B> ord) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
                }

                public <B> Option<B> collectFirst(PartialFunction<Tuple2<ArchiveEntry, InputStream>, B> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<ArchiveEntry, InputStream>, B> seqop, Function2<B, B, B> combop) {
                    return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<ArchiveEntry, InputStream>, B, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<Tuple2<ArchiveEntry, InputStream>, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<Tuple2<ArchiveEntry, InputStream>> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<Tuple2<ArchiveEntry, InputStream>> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<Tuple2<ArchiveEntry, InputStream>> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> Map<K, V> toMap(.less.colon.less<Tuple2<ArchiveEntry, InputStream>, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<Tuple2<ArchiveEntry, InputStream>> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<Tuple2<ArchiveEntry, InputStream>> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<Tuple2<ArchiveEntry, InputStream>> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<Tuple2<ArchiveEntry, InputStream>> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<ArchiveEntry, InputStream>, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                public boolean hasNext() {
                    if ((ArchiveEntry)this.nextEntryOrNull$1.elem == null) {
                        this.nextEntryOrNull$1.elem = this.archiveInputStream$1.getNextEntry();
                    }
                    return (ArchiveEntry)this.nextEntryOrNull$1.elem != null;
                }

                public Tuple2<ArchiveEntry, InputStream> next() {
                    Predef$.MODULE$.assert(this.hasNext());
                    Tuple2 value = new Tuple2((Object)((ArchiveEntry)this.nextEntryOrNull$1.elem), (Object)this.archiveInputStream$1);
                    this.nextEntryOrNull$1.elem = null;
                    return value;
                }
                {
                    this.nextEntryOrNull$1 = nextEntryOrNull$1;
                    this.archiveInputStream$1 = archiveInputStream$1;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                }
            };
            object = f.apply((Object)it);
        }
        return (T)object;
    }

    public <T> T withFirstFileInCompressedTarArchive(File archive, ArchiveType.Tar compression, Function1<InputStream, T> f) {
        return this.withCompressedTarArchiveEntriesIterator(archive, compression, (Function1 & Serializable)it -> {
            Iterator it0 = it.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchiveUtil$.$anonfun$withFirstFileInCompressedTarArchive$2(x$1))).map((Function1 & Serializable)x$2 -> (InputStream)x$2._2());
            if (it0.hasNext()) {
                return f.apply(it0.next());
            }
            throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(archive).toString());
        });
    }

    public <T> T withFileInCompressedTarArchive(File archive, ArchiveType.Tar compression, String pathInArchive, Function1<InputStream, T> f) {
        return this.withCompressedTarArchiveEntriesIterator(archive, compression, (Function1 & Serializable)it -> {
            Iterator it0 = it.collect((PartialFunction)new Serializable(pathInArchive){
                private static final long serialVersionUID = 0L;
                private final String pathInArchive$1;

                public final <A1 extends Tuple2<ArchiveEntry, InputStream>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        ArchiveEntry ent = (ArchiveEntry)A1._1();
                        InputStream is = (InputStream)A1._2();
                        if (!ent.isDirectory()) {
                            String string = ent.getName();
                            String string2 = this.pathInArchive$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return (B1)is;
                            }
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<ArchiveEntry, InputStream> x1) {
                    ArchiveEntry ent;
                    Tuple2<ArchiveEntry, InputStream> tuple2 = x1;
                    if (tuple2 != null && !(ent = (ArchiveEntry)tuple2._1()).isDirectory()) {
                        String string = ent.getName();
                        String string2 = this.pathInArchive$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.pathInArchive$1 = pathInArchive$1;
                }
            });
            if (it0.hasNext()) {
                return f.apply(it0.next());
            }
            throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(archive).toString());
        });
    }

    public <T> T withGzipContent(File gzFile, Function1<InputStream, T> f) {
        Object object;
        InputStream fis = null;
        GZIPInputStream gzis = null;
        try {
            fis = Files.newInputStream(gzFile.toPath(), new OpenOption[0]);
            gzis = new GZIPInputStream(fis);
            object = f.apply((Object)gzis);
        }
        finally {
            if (gzis != null) {
                gzis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return (T)object;
    }

    public <T> T withFirstFileInZip(File zip, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)CollectionConverters$.MODULE$.EnumerationHasAsScala(zf.entries()).asScala().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ArchiveUtil$.$anonfun$withFirstFileInZip$1(e))).getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(17).append("No file found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public <T> T withFileInZip(File zip, String pathInArchive, Function1<InputStream, T> f) {
        Object object;
        ZipFile zf = null;
        InputStream is = null;
        try {
            zf = new ZipFile(zip);
            ZipEntry ent = (ZipEntry)Option$.MODULE$.apply((Object)zf.getEntry(pathInArchive)).getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException(new java.lang.StringBuilder(14).append(pathInArchive).append(" not found in ").append(zip).toString());
            });
            is = zf.getInputStream(ent);
            object = f.apply((Object)is);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInCompressedTarArchive$2(Tuple2 x$1) {
        return !((ArchiveEntry)x$1._1()).isDirectory();
    }

    public static final /* synthetic */ boolean $anonfun$withFirstFileInZip$1(ZipEntry e) {
        return !e.isDirectory();
    }

    private ArchiveUtil$() {
    }
}

